/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.help.IContext;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.ui.SapphireHelpContext;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.swt.HelpSystem;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public abstract class FormComponentPresentation
extends SwtPresentation {
    private Composite composite;
    private DisposeListener compositeDisposeListener;
    private List<Control> controls;

    public FormComponentPresentation(FormComponentPart part, SwtPresentation parent, Composite composite) {
        super(part, parent, composite.getShell());
        this.composite = composite;
        this.compositeDisposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                FormComponentPresentation.this.dispose();
            }
        };
        this.composite.addDisposeListener(this.compositeDisposeListener);
    }

    @Override
    public FormComponentPart part() {
        return (FormComponentPart)super.part();
    }

    public final Composite composite() {
        return this.composite;
    }

    protected boolean isSingleLine() {
        return false;
    }

    protected static final void attachHelp(Control control, Property property) {
        final SapphireHelpContext context = new SapphireHelpContext(property.element(), property.definition());
        if (context.getText() != null || context.getRelatedTopics() != null && context.getRelatedTopics().length > 0) {
            control.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent event) {
                    Point point = HelpSystem.computePopUpLocation(event.widget.getDisplay());
                    PlatformUI.getWorkbench().getHelpSystem().displayContext((IContext)context, point.x, point.y);
                }
            });
        }
    }

    protected final void register(Control control) {
        if (control == null) {
            throw new IllegalArgumentException();
        }
        if (this.controls == null) {
            this.controls = new ArrayList<Control>(2);
        }
        this.controls.add(control);
    }

    public void layout() {
        Composite composite = this.composite();
        composite.getShell().layout(true, true);
        while (composite != null && !(composite instanceof ScrolledComposite)) {
            composite = composite.getParent();
        }
        if (composite != null) {
            if (composite instanceof SharedScrolledComposite) {
                ((SharedScrolledComposite)composite).reflow(true);
            } else {
                ScrolledComposite scrolledComposite = (ScrolledComposite)composite;
                Control scrolledCompositeContent = scrolledComposite.getContent();
                if (scrolledCompositeContent != null) {
                    scrolledComposite.setMinSize(scrolledCompositeContent.computeSize(-1, -1));
                    FormComponentPresentation.updatePageIncrement(scrolledComposite);
                }
            }
        }
    }

    private static void updatePageIncrement(ScrolledComposite scomp) {
        ScrollBar hbar;
        ScrollBar vbar = scomp.getVerticalBar();
        if (vbar != null) {
            vbar.setPageIncrement(scomp.getClientArea().height - 5);
        }
        if ((hbar = scomp.getHorizontalBar()) != null) {
            hbar.setPageIncrement(scomp.getClientArea().width - 5);
        }
    }

    public void refresh() {
        SwtPresentation parent = this.parent();
        if (parent instanceof FormComponentPresentation) {
            ((FormComponentPresentation)parent).refresh();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.composite != null) {
            if (!this.composite.isDisposed()) {
                this.composite.removeDisposeListener(this.compositeDisposeListener);
            }
            this.composite = null;
            this.compositeDisposeListener = null;
        }
        if (this.controls != null) {
            for (Control control : this.controls) {
                if (control.isDisposed()) continue;
                control.setVisible(false);
                control.dispose();
            }
            this.controls = null;
        }
    }
}

