/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.def.HorizontalAlignment;
import org.eclipse.sapphire.ui.forms.ActuatorDef;
import org.eclipse.sapphire.ui.forms.ActuatorPart;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.forms.swt.SapphireKeyboardActionPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.forms.swt.internal.ActuatorPresentation;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public final class ActuatorButtonPresentation
extends ActuatorPresentation {
    private SapphireActionPresentationManager actionPresentationManager;

    public ActuatorButtonPresentation(FormComponentPart part, SwtPresentation parent, Composite composite) {
        super(part, parent, composite);
    }

    @Override
    public void render() {
        ImageData image;
        int hSpan;
        final ActuatorPart part = this.part();
        ActuatorDef def = part.definition();
        SapphireActionGroup actions = part.getActions();
        this.actionPresentationManager = new SapphireActionPresentationManager(this, actions);
        SapphireKeyboardActionPresentation keyboardActionPresentation = new SapphireKeyboardActionPresentation(this.actionPresentationManager);
        HorizontalAlignment hAlign = (HorizontalAlignment)((Object)def.getHorizontalAlignment().content());
        int hAlignCode = hAlign == HorizontalAlignment.LEFT ? 16384 : (hAlign == HorizontalAlignment.RIGHT ? 131072 : 0x1000000);
        int n = hSpan = (Boolean)def.getSpanBothColumns().content() != false ? 2 : 1;
        if (hSpan == 1) {
            Label spacer = new Label(this.composite(), 0);
            spacer.setLayoutData((Object)GridLayoutUtil.gd());
            spacer.setText("");
            this.register((Control)spacer);
        }
        final Button button = new Button(this.composite(), 8);
        button.setLayoutData((Object)GridLayoutUtil.gdhspan(GridLayoutUtil.gdhindent(GridLayoutUtil.gdhalign(GridLayoutUtil.gd(), hAlignCode), 8), hSpan));
        this.register((Control)button);
        keyboardActionPresentation.attach((Control)button);
        String label = part.label(CapitalizationType.TITLE_STYLE, true);
        if (label != null) {
            button.setText(label);
        }
        if ((image = part.image(16)) != null) {
            button.setImage(this.resources().image(image));
        }
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SapphireActionHandler handler = part.handler();
                if (handler != null) {
                    handler.execute(ActuatorButtonPresentation.this);
                }
            }
        });
        button.setEnabled(part.enabled());
        this.attachPartListener(new Listener(){

            public void handle(Event event) {
                if (event instanceof ActuatorPart.EnablementChangedEvent) {
                    button.setEnabled(part.enabled());
                } else if (event instanceof SapphirePart.LabelChangedEvent) {
                    String label = part.label(CapitalizationType.TITLE_STYLE);
                    button.setText(label == null ? "" : label);
                    button.getParent().layout(true, true);
                } else if (event instanceof SapphirePart.ImageChangedEvent) {
                    button.setImage(ActuatorButtonPresentation.this.resources().image(part.image(16)));
                }
            }
        });
        keyboardActionPresentation.render();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.actionPresentationManager != null) {
            this.actionPresentationManager.dispose();
            this.actionPresentationManager = null;
        }
    }
}

