/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public final class TextOverlayPainter {
    private static final Point TEXT_OFFSET;
    private final Display display;
    private final Text textControl;
    private final Controller controller;
    private boolean controlKeyActive;
    private Point textExtent;
    private boolean hyperlinkActive;
    private boolean mouseOverText;

    static {
        String os = Platform.getOS();
        TEXT_OFFSET = os.equals("win32") ? new Point(4, 1) : new Point(2, 2);
    }

    private TextOverlayPainter(Text textControl, Controller controller) {
        this.display = textControl.getDisplay();
        this.textControl = textControl;
        this.controller = controller;
        this.controlKeyActive = false;
        this.hyperlinkActive = false;
        this.mouseOverText = false;
        final Listener keyListener = new Listener(){

            public void handleEvent(Event event) {
                TextOverlayPainter.this.handleKeyEvent(event);
            }
        };
        this.display.addFilter(1, keyListener);
        this.display.addFilter(2, keyListener);
        this.textControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                TextOverlayPainter.this.display.removeFilter(1, keyListener);
                TextOverlayPainter.this.display.removeFilter(2, keyListener);
            }
        });
        this.textControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                TextOverlayPainter.this.updateTextExtent();
            }
        });
        this.updateTextExtent();
        this.textControl.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                TextOverlayPainter.this.handlePaint(event);
            }
        });
        this.textControl.addListener(5, new Listener(){

            public void handleEvent(Event event) {
                TextOverlayPainter.this.handleMouseMove(event);
            }
        });
        this.textControl.addListener(7, new Listener(){

            public void handleEvent(Event event) {
                TextOverlayPainter.this.handleMouseExit(event);
            }
        });
        this.textControl.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                TextOverlayPainter.this.handleMouseDown(event);
            }
        });
    }

    public static void install(Text textControl, Controller controller) {
        new TextOverlayPainter(textControl, controller);
    }

    private void handleKeyEvent(Event event) {
        if (event.keyCode == 262144) {
            boolean bl = this.controlKeyActive = event.type == 1;
            if (!this.controlKeyActive) {
                this.update();
            }
        }
    }

    private void handleMouseMove(Event event) {
        this.mouseOverText = event.x <= this.textExtent.x && event.y <= this.textExtent.y;
        this.update();
    }

    private void handleMouseExit(Event event) {
        this.mouseOverText = false;
        this.update();
    }

    private void handleMouseDown(Event event) {
        if (this.hyperlinkActive) {
            this.textControl.setCursor(null);
            this.handleJumpCommand();
        }
    }

    private void handleJumpCommand() {
        Runnable op = new Runnable(){

            @Override
            public void run() {
                TextOverlayPainter.this.controller.handleHyperlinkEvent();
            }
        };
        BusyIndicator.showWhile((Display)this.display, (Runnable)op);
    }

    private void update() {
        boolean shouldHyperlinkBeActive;
        boolean bl = shouldHyperlinkBeActive = this.controlKeyActive && this.mouseOverText && this.controller.isHyperlinkEnabled();
        if (this.hyperlinkActive != shouldHyperlinkBeActive) {
            this.hyperlinkActive = shouldHyperlinkBeActive;
            this.textControl.setCursor(shouldHyperlinkBeActive ? this.display.getSystemCursor(21) : null);
            this.textControl.redraw();
        }
    }

    private void updateTextExtent() {
        GC gc = new GC((Drawable)this.textControl);
        this.textExtent = gc.textExtent(this.getTextWithOverlay());
        gc.dispose();
    }

    private void handlePaint(Event event) {
        if (this.textControl.isEnabled()) {
            String overlay;
            if (this.hyperlinkActive) {
                TextStyle style = new TextStyle(this.textControl.getFont(), null, null);
                style.underline = true;
                style.underlineColor = style.foreground = JFaceColors.getActiveHyperlinkText((Display)this.display);
                this.paintTextOverlay(event.gc, style, this.getTextWithOverlay());
            } else if (!this.textControl.isFocusControl() && this.textControl.getText().length() == 0 && (overlay = this.controller.overlay()) != null && overlay.length() > 0) {
                TextStyle style = new TextStyle(this.textControl.getFont(), null, null);
                style.foreground = this.display.getSystemColor(15);
                this.paintTextOverlay(event.gc, style, overlay);
            }
        }
    }

    private void paintTextOverlay(GC gc, TextStyle style, String text) {
        TextLayout layout = new TextLayout((Device)this.display);
        layout.setText(text);
        layout.setStyle(style, 0, text.length() - 1);
        Rectangle clientArea = this.textControl.getClientArea();
        gc.fillRectangle(clientArea);
        layout.setWidth(clientArea.width - TextOverlayPainter.TEXT_OFFSET.x * 2);
        layout.draw(gc, TextOverlayPainter.TEXT_OFFSET.x, TextOverlayPainter.TEXT_OFFSET.y);
    }

    private String getTextWithOverlay() {
        String text = this.textControl.getText();
        if (text.length() == 0 && (text = this.controller.overlay()) == null) {
            text = "";
        }
        return text;
    }

    public static abstract class Controller {
        public boolean isHyperlinkEnabled() {
            return false;
        }

        public void handleHyperlinkEvent() {
            throw new UnsupportedOperationException();
        }

        public String overlay() {
            return null;
        }
    }
}

