/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.osgi;

import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.internal.Activator;
import org.eclipse.scout.commons.osgi.BundleInspector;
import org.eclipse.scout.commons.serialization.SerializationUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class BundleListClassLoader
extends ClassLoader {
    private static final HashMap<String, Class> PRIMITIVE_TYPES = new HashMap(8, 1.0f);
    private static final ThreadLocal<Set<String>> LOOP_DETECTOR;
    private static final Enumeration<URL> EMPTY_URL_ENUMERATION;
    private static final String BUNDLE_INCLUDE_FILTER_PROPERTY = "org.eclipse.scout.commons.osgi.BundleListClassLoader#includeBundles";
    private static final String BUNDLE_EXCLUDE_FILTER_PROPERTY = "org.eclipse.scout.commons.osgi.BundleListClassLoader#excludeBundles";
    private static final String REGEX_MARKER = "regex:";
    private static ClassLoader s_myClassLoader;
    private final Bundle[] m_bundles;
    private final Bundle[] m_bundlesSortedByBundleSymbolicNameLenght;
    private String[] m_bundleOrderPrefixes = null;
    private final ClassLoader m_parentContextClassLoader;
    private final ReadWriteLock m_cacheLock = new ReentrantReadWriteLock();
    private final Map<String, WeakReference<Class<?>>> m_classCache;
    private final boolean m_useResourceFiltering;
    private final boolean m_useResourceCaching;
    private final Map<String, Vector<URL>> m_resourceCache;

    static {
        PRIMITIVE_TYPES.put("boolean", Boolean.TYPE);
        PRIMITIVE_TYPES.put("byte", Byte.TYPE);
        PRIMITIVE_TYPES.put("char", Character.TYPE);
        PRIMITIVE_TYPES.put("short", Short.TYPE);
        PRIMITIVE_TYPES.put("int", Integer.TYPE);
        PRIMITIVE_TYPES.put("long", Long.TYPE);
        PRIMITIVE_TYPES.put("float", Float.TYPE);
        PRIMITIVE_TYPES.put("double", Double.TYPE);
        PRIMITIVE_TYPES.put("void", Void.TYPE);
        PRIMITIVE_TYPES.put("Z", Boolean.TYPE);
        PRIMITIVE_TYPES.put("B", Byte.TYPE);
        PRIMITIVE_TYPES.put("C", Character.TYPE);
        PRIMITIVE_TYPES.put("S", Short.TYPE);
        PRIMITIVE_TYPES.put("I", Integer.TYPE);
        PRIMITIVE_TYPES.put("J", Long.TYPE);
        PRIMITIVE_TYPES.put("F", Float.TYPE);
        PRIMITIVE_TYPES.put("D", Double.TYPE);
        PRIMITIVE_TYPES.put("V", Void.TYPE);
        LOOP_DETECTOR = new ThreadLocal();
        EMPTY_URL_ENUMERATION = new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public URL nextElement() {
                throw new NoSuchElementException();
            }
        };
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                s_myClassLoader = BundleListClassLoader.class.getClassLoader();
                return null;
            }
        });
    }

    public BundleListClassLoader(ClassLoader parent, Bundle ... bundles) {
        super(parent);
        ClassLoader classLoader = this.m_parentContextClassLoader = parent != null ? parent : new ClassLoader(Object.class.getClassLoader()){};
        if (bundles == null || bundles.length == 0) {
            throw new IllegalArgumentException("bundle list must not be null or empty");
        }
        String bundleIncludeFilter = Activator.getDefault().getBundle().getBundleContext().getProperty(BUNDLE_INCLUDE_FILTER_PROPERTY);
        String bundleExcludeFilter = Activator.getDefault().getBundle().getBundleContext().getProperty(BUNDLE_EXCLUDE_FILTER_PROPERTY);
        Pattern[] bundleIncludePatterns = BundleListClassLoader.parseFilterPatterns(bundleIncludeFilter);
        Pattern[] bundleExcludePatterns = BundleListClassLoader.parseFilterPatterns(bundleExcludeFilter);
        ArrayList<Bundle> filteredBundleList = new ArrayList<Bundle>();
        Bundle[] bundleArray = BundleInspector.filterPluginBundles(bundles);
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (BundleListClassLoader.accept(b.getSymbolicName(), bundleIncludePatterns, bundleExcludePatterns)) {
                filteredBundleList.add(b);
            }
            ++n2;
        }
        this.m_bundles = filteredBundleList.toArray(new Bundle[filteredBundleList.size()]);
        if (this.getBundles().length == 0) {
            throw new IllegalArgumentException("filtered bundle list must not be empty. [bundles=" + Arrays.toString(bundles) + "]");
        }
        this.m_bundlesSortedByBundleSymbolicNameLenght = new Bundle[this.getBundles().length];
        System.arraycopy(this.getBundles(), 0, this.getBundlesSortedByBundleSymbolicNameLenght(), 0, this.getBundles().length);
        Arrays.sort(this.getBundlesSortedByBundleSymbolicNameLenght(), new Comparator<Bundle>(){

            @Override
            public int compare(Bundle b1, Bundle b2) {
                if (b1 == null && b2 == null) {
                    return 0;
                }
                if (b1 == null) {
                    return -1;
                }
                if (b2 == null) {
                    return 1;
                }
                return StringUtility.length(b2.getSymbolicName()) - StringUtility.length(b1.getSymbolicName());
            }
        });
        this.m_classCache = new HashMap();
        this.m_useResourceFiltering = SerializationUtility.isUseBundleOrderPrefixListAsResourceFilterEnabled();
        this.m_useResourceCaching = SerializationUtility.isResourceUrlCachingInBundleListClassLoaderEnabled();
        this.m_resourceCache = new HashMap<String, Vector<URL>>();
    }

    public Bundle[] getBundles() {
        return this.m_bundles;
    }

    public Bundle[] getBundlesSortedByBundleSymbolicNameLenght() {
        return this.m_bundlesSortedByBundleSymbolicNameLenght;
    }

    public ClassLoader getParentContextClassLoader() {
        return this.m_parentContextClassLoader;
    }

    public boolean isUseResourceFilteringEnabled() {
        return this.m_useResourceFiltering;
    }

    public boolean isUseResourceCachingEnabled() {
        return this.m_useResourceCaching;
    }

    protected Class<?> putInCache(String name, Class<?> c) {
        this.m_cacheLock.writeLock().lock();
        try {
            this.m_classCache.put(name, new WeakReference(c));
        }
        finally {
            this.m_cacheLock.writeLock().unlock();
        }
        return c;
    }

    protected URL putInCache(String name, URL resources) {
        Vector<URL> urlList = new Vector<URL>();
        urlList.add(resources);
        urlList = this.putInCache(name, urlList);
        return urlList.firstElement();
    }

    protected Vector<URL> putInCache(String name, Vector<URL> resources) {
        if (this.isUseResourceCachingEnabled()) {
            this.m_cacheLock.writeLock().lock();
            try {
                this.m_resourceCache.put(name, resources);
            }
            finally {
                this.m_cacheLock.writeLock().unlock();
            }
        }
        return resources;
    }

    protected Vector<URL> getFromCache(String name) {
        if (!this.isUseResourceCachingEnabled()) {
            return null;
        }
        this.m_cacheLock.readLock().lock();
        try {
            Vector<URL> ref;
            Vector<URL> vector = ref = this.m_resourceCache.get(name);
            return vector;
        }
        finally {
            this.m_cacheLock.readLock().unlock();
        }
    }

    protected void clearCaches() {
        this.m_cacheLock.writeLock().lock();
        try {
            this.m_classCache.clear();
            this.m_resourceCache.clear();
        }
        finally {
            this.m_cacheLock.writeLock().unlock();
        }
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        if (!this.registerLoadingItem(className)) {
            throw new ClassNotFoundException(className);
        }
        try {
            Class<?> clazz = this.doLoadClass(className);
            return clazz;
        }
        finally {
            this.unregisterLoadingItem(className);
        }
    }

    protected Class<?> doLoadClass(String className) throws ClassNotFoundException {
        Bundle bundle;
        Class c = PRIMITIVE_TYPES.get(className);
        if (c != null) {
            return c;
        }
        int arrayDim = 0;
        while (className.startsWith("[")) {
            className = className.substring(1);
            ++arrayDim;
        }
        if (className.matches("L.*;")) {
            className = className.substring(1, className.length() - 1);
        }
        if (arrayDim > 0) {
            c = this.loadClass(className);
            int[] dimensions = new int[arrayDim];
            c = Array.newInstance(c, dimensions).getClass();
            return c;
        }
        if (className.startsWith("java.")) {
            return this.getParentContextClassLoader().loadClass(className);
        }
        this.m_cacheLock.readLock().lock();
        try {
            WeakReference<Class<?>> ref = this.m_classCache.get(className);
            if (ref != null && (c = (Class)ref.get()) != null) {
                Class clazz = c;
                return clazz;
            }
            if (this.m_classCache.containsKey(className)) {
                throw new ClassNotFoundException(className);
            }
        }
        finally {
            this.m_cacheLock.readLock().unlock();
        }
        HashSet<Bundle> usedBundles = new HashSet<Bundle>();
        Bundle[] bundleArray = this.getBundlesSortedByBundleSymbolicNameLenght();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            bundle = bundleArray[n2];
            if (!usedBundles.contains(bundle) && className.startsWith(String.valueOf(bundle.getSymbolicName()) + ".")) {
                usedBundles.add(bundle);
                try {
                    c = bundle.loadClass(className);
                    return this.putInCache(className, c);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
        bundleArray = this.getBundlesSortedByBundleSymbolicNameLenght();
        n = bundleArray.length;
        n2 = 0;
        while (n2 < n) {
            bundle = bundleArray[n2];
            if (!usedBundles.contains(bundle) && bundle.getState() == 32) {
                usedBundles.add(bundle);
                try {
                    c = bundle.loadClass(className);
                    return this.putInCache(className, c);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
        bundleArray = this.getBundles();
        n = bundleArray.length;
        n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (!usedBundles.contains(b)) {
                try {
                    c = b.loadClass(className);
                    return this.putInCache(className, c);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
        try {
            c = this.getParentContextClassLoader().loadClass(className);
            return this.putInCache(className, c);
        }
        catch (Exception exception) {
            this.putInCache(className, (Class<?>)null);
            throw new ClassNotFoundException(className);
        }
    }

    @Override
    public URL getResource(String name) {
        Enumeration<URL> resources = this.getResources(name);
        if (resources != null && resources.hasMoreElements()) {
            return resources.nextElement();
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        try {
            URL u = this.getResource(name);
            if (u != null) {
                return u.openStream();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        if (!this.registerLoadingItem(name)) {
            return null;
        }
        try {
            Vector<URL> ref = this.getFromCache(name);
            if (ref != null) {
                Enumeration<URL> enumeration = ref.elements();
                return enumeration;
            }
            Vector<URL> urlList = this.searchResourcesInBundles(name);
            urlList = this.filterResources(urlList);
            Enumeration<URL> enumeration = this.putInCache(name, urlList).elements();
            return enumeration;
        }
        finally {
            this.unregisterLoadingItem(name);
        }
    }

    protected Vector<URL> searchResourcesInBundles(String name) {
        Vector<URL> urlList = new Vector<URL>();
        Bundle[] bundleArray = this.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            try {
                Enumeration resources = b.getResources(name);
                while (resources != null && resources.hasMoreElements()) {
                    URL url = (URL)resources.nextElement();
                    urlList.add(url);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return urlList;
    }

    protected Vector<URL> filterResources(Vector<URL> urlList) {
        if (this.isUseResourceFilteringEnabled()) {
            Vector<URL> newUrlList = new Vector<URL>();
            Vector<URL> customUrlList = new Vector<URL>();
            Enumeration<URL> resources = urlList.elements();
            while (resources != null && resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                newUrlList.add(resource);
                if (!this.isUrlFromBundlePrefixes(resource)) continue;
                customUrlList.add(resource);
            }
            urlList = !customUrlList.isEmpty() ? customUrlList : newUrlList;
        }
        return urlList;
    }

    protected boolean registerLoadingItem(String name) {
        Set<String> loadingItems = LOOP_DETECTOR.get();
        if (loadingItems != null && loadingItems.contains(name)) {
            return false;
        }
        if (loadingItems == null) {
            loadingItems = new HashSet<String>(3);
            LOOP_DETECTOR.set(loadingItems);
        }
        loadingItems.add(name);
        return true;
    }

    protected void unregisterLoadingItem(String name) {
        LOOP_DETECTOR.get().remove(name);
    }

    private static boolean accept(String s, Pattern[] includePatterns, Pattern[] excludePatterns) {
        Pattern p;
        int n;
        int n2;
        Pattern[] patternArray;
        if (s == null) {
            return false;
        }
        boolean included = true;
        boolean excluded = false;
        if (includePatterns != null && includePatterns.length > 0) {
            included = false;
            patternArray = includePatterns;
            n2 = includePatterns.length;
            n = 0;
            while (n < n2) {
                p = patternArray[n];
                if (p.matcher(s).matches()) {
                    included = true;
                    break;
                }
                ++n;
            }
        }
        if (included && excludePatterns != null && excludePatterns.length > 0) {
            patternArray = excludePatterns;
            n2 = excludePatterns.length;
            n = 0;
            while (n < n2) {
                p = patternArray[n];
                if (p.matcher(s).matches()) {
                    excluded = true;
                    break;
                }
                ++n;
            }
        }
        return included && !excluded;
    }

    private static Pattern[] parseFilterPatterns(String filter) {
        if (filter == null) {
            return null;
        }
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        String[] stringArray = filter.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            if ((f = f.trim()).length() > 0) {
                try {
                    f = BundleListClassLoader.toRegexPattern(f);
                    Pattern pattern = Pattern.compile(f);
                    patterns.add(pattern);
                }
                catch (Exception e) {
                    System.err.println("invalid filter pattern: " + e);
                }
            }
            ++n2;
        }
        if (patterns.isEmpty()) {
            return null;
        }
        return patterns.toArray(new Pattern[patterns.size()]);
    }

    private static String toRegexPattern(String s) {
        if (s == null) {
            return null;
        }
        String pattern = s.trim();
        if (pattern.startsWith(REGEX_MARKER)) {
            return pattern.substring(REGEX_MARKER.length());
        }
        pattern = pattern.replaceAll("[.]", "\\\\.");
        pattern = pattern.replaceAll("[*]", ".*");
        pattern = pattern.replaceAll("[?]", ".");
        return pattern;
    }

    protected boolean isUrlFromBundlePrefixes(URL resource) {
        Bundle bundle;
        long bundleID;
        if (this.m_bundleOrderPrefixes == null) {
            this.m_bundleOrderPrefixes = SerializationUtility.getBundleOrderPrefixes();
        }
        if ((bundleID = this.getBundleID(resource.getHost())) >= 0L && (bundle = this.getBundle(bundleID)) != null) {
            String[] stringArray = this.m_bundleOrderPrefixes;
            int n = this.m_bundleOrderPrefixes.length;
            int n2 = 0;
            while (n2 < n) {
                String bundlePrefix = stringArray[n2];
                if (StringUtility.contains(bundle.getSymbolicName(), bundlePrefix)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected long getBundleID(String host) {
        int dotIndex = host.indexOf(46);
        return dotIndex >= 0 && dotIndex < host.length() - 1 ? Long.parseLong(host.substring(0, dotIndex)) : -1L;
    }

    protected Bundle getBundle(long id) {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        Bundle result = null;
        Bundle[] bundleArray = bundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle candidate = bundleArray[n2];
            if (candidate.getBundleId() == id && (result == null || result.getVersion().compareTo((Object)candidate.getVersion()) < 0)) {
                result = candidate;
            }
            ++n2;
        }
        return result;
    }
}

