/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.internal.servlet;

import com.sun.xml.internal.ws.api.server.BoundEndpoint;
import com.sun.xml.internal.ws.api.server.Module;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.api.server.WebModule;
import com.sun.xml.internal.ws.transport.http.HttpAdapter;
import com.sun.xml.internal.ws.transport.http.HttpAdapterList;
import com.sun.xml.internal.ws.transport.http.WSHTTPConnection;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.WebServiceException;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.jaxws.internal.servlet.ServletConnection;

public class ServletAdapter
extends HttpAdapter
implements BoundEndpoint {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ServletAdapter.class);
    private String m_alias;

    public ServletAdapter(WSEndpoint endpoint, String alias, String urlPattern, HttpAdapterList<? extends HttpAdapter> owner) {
        super(endpoint, owner, urlPattern);
        this.m_alias = alias;
        this.registerEndpoint();
    }

    public void handle(ServletContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletConnection connection = new ServletConnection(this, context, request, response);
        super.handle((WSHTTPConnection)connection);
    }

    public URI getAddress() {
        WebModule webModule = (WebModule)this.endpoint.getContainer().getSPI(WebModule.class);
        if (webModule == null) {
            throw new WebServiceException("Container " + this.endpoint.getContainer().getClass().getName() + " does not support " + WebModule.class.getName());
        }
        return this.getAddress(webModule.getContextPath());
    }

    public URI getAddress(String baseAddress) {
        String uri = StringUtility.join((String)"", (Object[])new Object[]{baseAddress, this.getValidPath()});
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new WebServiceException("Invalid URI '" + uri + "'", (Throwable)e);
        }
    }

    public String getAlias() {
        return this.m_alias;
    }

    public String toString() {
        return StringUtility.join((String)" ", (Object[])new Object[]{super.toString(), "[endpoint=" + this.getAlias() + "]"});
    }

    private void registerEndpoint() {
        Module module = (Module)this.getEndpoint().getContainer().getSPI(Module.class);
        if (module == null) {
            LOG.warn("Container " + this.endpoint.getContainer().getClass().getName() + " does not support " + Module.class.getName());
            return;
        }
        module.getBoundEndpoints().add(this);
    }
}

