/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.transformation;

import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.mobile.transformation.IDeviceTransformationService;
import org.eclipse.scout.rt.client.mobile.transformation.IDeviceTransformer;
import org.eclipse.scout.rt.client.mobile.transformation.MobileDeviceTransformer;
import org.eclipse.scout.rt.client.mobile.transformation.TabletDeviceTransformer;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.shared.ui.UserAgentUtility;
import org.eclipse.scout.service.AbstractService;

public class DeviceTransformationService
extends AbstractService
implements IDeviceTransformationService {
    private String SESSION_DATA_KEY = "DeviceTransformationServiceData";

    @Override
    public void install() {
        this.install(null);
    }

    @Override
    public void install(IDesktop desktop) {
        if (this.getDeviceTransformer() != null) {
            return;
        }
        IClientSession session = ClientJob.getCurrentSession();
        IDeviceTransformer data = this.createDeviceTransformer(desktop);
        session.setData(this.SESSION_DATA_KEY, (Object)data);
    }

    @Override
    public void uninstall() {
        IClientSession session = ClientJob.getCurrentSession();
        session.setData(this.SESSION_DATA_KEY, null);
    }

    protected IDeviceTransformer createDeviceTransformer(IDesktop desktop) {
        if (UserAgentUtility.isTabletDevice()) {
            return new TabletDeviceTransformer(desktop);
        }
        return new MobileDeviceTransformer(desktop);
    }

    @Override
    public IDeviceTransformer getDeviceTransformer() {
        IClientSession session = ClientJob.getCurrentSession();
        return (IDeviceTransformer)session.getData(this.SESSION_DATA_KEY);
    }
}

