/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.BigDecimalColumnField;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.BigDecimalColumnFieldPropertyDelegator;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.BigIntegerColumnField;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.BooleanColumnField;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.ColumnFieldPropertyDelegator;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.DateColumnField;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.DateColumnFieldPropertyDelegator;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.DoubleColumnField;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.DoubleColumnFieldPropertyDelegator;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.IntegerColumnField;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.IntegerColumnFieldPropertyDelegator;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.LongColumnField;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.LongColumnFieldPropertyDelegator;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.ProposalColumnFieldPropertyDelegator;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.SmartColumnField;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.SmartColumnFieldPropertyDelegator;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.StringColumnField;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.StringColumnFieldPropertyDelegator;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBigDecimalColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBigIntegerColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IDateColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IDoubleColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IIntegerColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ILongColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IProposalColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ISmartColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IStringColumn;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.bigdecimalfield.IBigDecimalField;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.IDateField;
import org.eclipse.scout.rt.client.ui.form.fields.doublefield.IDoubleField;
import org.eclipse.scout.rt.client.ui.form.fields.integerfield.IIntegerField;
import org.eclipse.scout.rt.client.ui.form.fields.longfield.ILongField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IProposalField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField;

public class ColumnFieldBuilder {
    private static final String PROP_PROPERTY_DELEGATOR = "propertyDelegator";
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ColumnFieldBuilder.class);

    public Map<IColumn<?>, IFormField> build(List<IColumn<?>> columns, ITableRow row) throws ProcessingException {
        HashMap fields = new HashMap();
        if (columns == null) {
            return fields;
        }
        for (IColumn<?> column : columns) {
            IFormField field = this.createValueField(column, row);
            if (field != null) {
                fields.put(column, field);
                continue;
            }
            LOG.warn("No field mapping found for column " + column.getClass());
        }
        return fields;
    }

    protected IFormField createValueField(IColumn<?> column, ITableRow row) throws ProcessingException {
        IFormField field;
        if (column.isEditable() && (field = this.createEditableField(column, row)) != null) {
            return field;
        }
        if (column instanceof IStringColumn) {
            return new StringColumnField((IStringColumn)column);
        }
        if (column instanceof ISmartColumn) {
            return new SmartColumnField((ISmartColumn)column);
        }
        if (column instanceof IDoubleColumn) {
            return new DoubleColumnField((IDoubleColumn)column);
        }
        if (column instanceof IDateColumn) {
            return new DateColumnField((IDateColumn)column);
        }
        if (column instanceof IBooleanColumn) {
            return new BooleanColumnField((IBooleanColumn)column);
        }
        if (column instanceof ILongColumn) {
            return new LongColumnField((ILongColumn)column);
        }
        if (column instanceof IIntegerColumn) {
            return new IntegerColumnField((IIntegerColumn)column);
        }
        if (column instanceof IBigDecimalColumn) {
            return new BigDecimalColumnField((IBigDecimalColumn)column);
        }
        if (column instanceof IBigIntegerColumn) {
            return new BigIntegerColumnField((IBigIntegerColumn)column);
        }
        return null;
    }

    protected ColumnFieldPropertyDelegator<? extends IColumn<?>, ? extends IFormField> createColumnFieldPropertyDelegator(IColumn<?> column, IFormField formField) {
        if (column instanceof IStringColumn && formField instanceof IStringField) {
            return new StringColumnFieldPropertyDelegator((IStringColumn)column, (IStringField)formField);
        }
        if (column instanceof ISmartColumn && formField instanceof ISmartField) {
            return new SmartColumnFieldPropertyDelegator((ISmartColumn)column, (ISmartField)formField);
        }
        if (column instanceof IProposalColumn && formField instanceof IProposalField) {
            return new ProposalColumnFieldPropertyDelegator((IProposalColumn)column, (IProposalField)formField);
        }
        if (column instanceof IDoubleColumn && formField instanceof IDoubleField) {
            return new DoubleColumnFieldPropertyDelegator((IDoubleColumn)column, (IDoubleField)formField);
        }
        if (column instanceof IDateColumn && formField instanceof IDateField) {
            return new DateColumnFieldPropertyDelegator((IDateColumn)column, (IDateField)formField);
        }
        if (column instanceof IBooleanColumn && formField instanceof IBooleanField) {
            return new ColumnFieldPropertyDelegator(column, formField);
        }
        if (column instanceof ILongColumn && formField instanceof ILongField) {
            return new LongColumnFieldPropertyDelegator((ILongColumn)column, (ILongField)formField);
        }
        if (column instanceof IIntegerColumn && formField instanceof IIntegerField) {
            return new IntegerColumnFieldPropertyDelegator((IIntegerColumn)column, (IIntegerField)formField);
        }
        if (column instanceof IBigDecimalColumn && formField instanceof IBigDecimalField) {
            return new BigDecimalColumnFieldPropertyDelegator((IBigDecimalColumn)column, (IBigDecimalField)formField);
        }
        return new ColumnFieldPropertyDelegator(column, formField);
    }

    protected IFormField createEditableField(IColumn<?> column, ITableRow row) throws ProcessingException {
        IFormField field = column.prepareEdit(row);
        if (field != null) {
            field.setLabelVisible(true);
            GridData gd = field.getGridDataHints();
            gd.weightY = 0.0;
            field.setGridDataHints(gd);
            ColumnFieldPropertyDelegator<IColumn<?>, IFormField> propertyDelegator = this.createColumnFieldPropertyDelegator(column, field);
            if (propertyDelegator != null) {
                propertyDelegator.init();
                field.setProperty(PROP_PROPERTY_DELEGATOR, propertyDelegator);
            }
            field.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("value".equals(evt.getPropertyName())) {
                        ((IValueField)evt.getSource()).touch();
                    }
                }
            });
        }
        return field;
    }

    public void fieldDisposed(IFormField field) {
        Object value = field.getProperty(PROP_PROPERTY_DELEGATOR);
        if (value instanceof ColumnFieldPropertyDelegator) {
            ((ColumnFieldPropertyDelegator)value).dispose();
        }
    }
}

