/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.ui.form.fields.smartfield;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.mobile.transformation.DeviceTransformationConfig;
import org.eclipse.scout.rt.client.mobile.transformation.DeviceTransformationUtility;
import org.eclipse.scout.rt.client.mobile.transformation.MobileDeviceTransformation;
import org.eclipse.scout.rt.client.mobile.ui.form.fields.button.AbstractBackButton;
import org.eclipse.scout.rt.client.mobile.ui.form.fields.smartfield.CustomTextLookupRow;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeAdapter;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeListener;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ContentAssistTreeForm;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.AbstractStringField;
import org.eclipse.scout.rt.shared.TEXTS;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.service.SERVICES;

public class MobileSmartTreeForm<LOOKUP_TYPE>
extends ContentAssistTreeForm<LOOKUP_TYPE> {
    private P_SmartFieldListener m_smartFieldListener;
    private boolean m_acceptingProposal;

    public MobileSmartTreeForm(IContentAssistField<?, LOOKUP_TYPE> smartField, boolean allowCustomText) throws ProcessingException {
        super(smartField, allowCustomText);
    }

    protected void initConfig() throws ProcessingException {
        super.initConfig();
        String title = this.getContentAssistField().getLabel();
        title = StringUtility.hasText((String)title) ? TEXTS.get((String)"MobileSmartFormTitle", (String[])new String[]{title}) : TEXTS.get((String)"MobileSmartFormTitleDefault");
        this.setTitle(title);
        this.getResultTreeField().getTree().setCheckable(true);
        this.getResultTreeField().getTree().addTreeListener((TreeListener)new P_TreeListener());
        GridData treeFieldGridDataHints = this.getResultTreeField().getGridDataHints();
        treeFieldGridDataHints.useUiHeight = false;
        treeFieldGridDataHints.useUiWidth = false;
        treeFieldGridDataHints.h = 2;
        treeFieldGridDataHints.fillVertical = true;
        this.getResultTreeField().setGridDataHints(treeFieldGridDataHints);
        this.addFormListener(new P_FormListener());
        if (this.m_smartFieldListener == null) {
            this.m_smartFieldListener = new P_SmartFieldListener();
            this.getContentAssistField().addPropertyChangeListener((PropertyChangeListener)this.m_smartFieldListener);
        }
    }

    protected void execDisposeForm() throws ProcessingException {
        super.execDisposeForm();
        if (this.m_smartFieldListener != null) {
            this.getContentAssistField().removePropertyChangeListener((PropertyChangeListener)this.m_smartFieldListener);
            this.m_smartFieldListener = null;
        }
    }

    protected int getConfiguredDisplayHint() {
        return 0;
    }

    protected boolean getConfiguredModal() {
        return true;
    }

    protected boolean getConfiguredAskIfNeedSave() {
        return true;
    }

    protected void injectResultTreeMenus(List<IMenu> menuList) {
        super.injectResultTreeMenus(menuList);
        List smartFieldMenus = this.getContentAssistField().getMenus();
        menuList.addAll(smartFieldMenus);
    }

    protected void execResultTreeNodeClick(ITreeNode node) throws ProcessingException {
    }

    private void acceptProposal() throws ProcessingException {
        this.m_acceptingProposal = true;
        try {
            ILookupRow<LOOKUP_TYPE> lookupRow = this.getAcceptedProposal();
            if (lookupRow != null) {
                this.getContentAssistField().acceptProposal(lookupRow);
            }
        }
        finally {
            this.m_acceptingProposal = false;
        }
    }

    public ILookupRow<LOOKUP_TYPE> getAcceptedProposal() throws ProcessingException {
        ILookupRow row = this.getSelectedLookupRow();
        if (row != null && row.isEnabled()) {
            return row;
        }
        if (this.isAllowCustomText()) {
            return new CustomTextLookupRow((String)this.getFilterField().getValue());
        }
        return new LookupRow(null, "", null, null, null, null, null, true);
    }

    public MainBox.GroupBox.FilterField getFilterField() {
        return (MainBox.GroupBox.FilterField)this.getFieldByClass(MainBox.GroupBox.FilterField.class);
    }

    private void handleTreeNodesUpdated(Collection<ITreeNode> nodes) {
        if (CollectionUtility.hasElements(nodes)) {
            try {
                this.acceptProposal();
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }
    }

    public class MainBox
    extends ContentAssistTreeForm.MainBox {
        public MainBox() {
            super((ContentAssistTreeForm)MobileSmartTreeForm.this);
        }

        protected void execInitField() throws ProcessingException {
            super.execInitField();
            DeviceTransformationConfig config = DeviceTransformationUtility.getDeviceTransformationConfig();
            if (config != null) {
                config.excludeFieldTransformation((IFormField)this, MobileDeviceTransformation.MAKE_MAINBOX_SCROLLABLE);
            }
        }

        protected int getConfiguredHeightInPixel() {
            return 400;
        }

        @Order(value=99.0)
        public class BackButton
        extends AbstractBackButton {
        }

        @Order(value=1.0)
        public class GroupBox
        extends AbstractGroupBox {
            protected boolean getConfiguredBorderVisible() {
                return true;
            }

            @Order(value=1.0)
            public class FilterField
            extends AbstractStringField {
                protected boolean getConfiguredLabelVisible() {
                    return false;
                }

                protected boolean getConfiguredValidateOnAnyKey() {
                    return true;
                }

                protected void execChangedValue() throws ProcessingException {
                    MobileSmartTreeForm.this.getContentAssistField().doSearch((String)this.getValue(), false, false);
                }
            }
        }
    }

    private class P_FormListener
    implements FormListener {
        private P_FormListener() {
        }

        public void formChanged(FormEvent e) throws ProcessingException {
            switch (e.getType()) {
                case 3010: {
                    ILookupRow row;
                    if (e.getForm() != MobileSmartTreeForm.this) {
                        return;
                    }
                    MobileSmartTreeForm.this.removeFormListener(this);
                    if (MobileSmartTreeForm.this.getCloseSystemType() != 3 || !((row = MobileSmartTreeForm.this.getAcceptedProposal()) instanceof CustomTextLookupRow)) break;
                    MobileSmartTreeForm.this.getContentAssistField().setDisplayText(row.getText());
                }
            }
        }
    }

    private class P_SmartFieldListener
    implements PropertyChangeListener {
        private P_SmartFieldListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("value".equals(evt.getPropertyName()) && !MobileSmartTreeForm.this.m_acceptingProposal) {
                MobileSmartTreeForm.this.getFilterField().setValue(MobileSmartTreeForm.this.getContentAssistField().getDisplayText());
            }
        }
    }

    private class P_TreeListener
    extends TreeAdapter {
        private P_TreeListener() {
        }

        public void treeChanged(TreeEvent e) {
            switch (e.getType()) {
                case 20: {
                    MobileSmartTreeForm.this.handleTreeNodesUpdated(e.getNodes());
                }
            }
        }
    }
}

