/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.ui.form.outline;

import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.mobile.transformation.DeviceTransformationConfig;
import org.eclipse.scout.rt.client.mobile.transformation.DeviceTransformationUtility;
import org.eclipse.scout.rt.client.mobile.transformation.MobileDeviceTransformation;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.AbstractMobileTable;
import org.eclipse.scout.rt.client.mobile.ui.desktop.MobileDesktopUtility;
import org.eclipse.scout.rt.client.mobile.ui.form.AbstractMobileForm;
import org.eclipse.scout.rt.client.mobile.ui.form.outline.IOutlineChooserForm;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.AbstractTableField;
import org.eclipse.scout.rt.shared.TEXTS;

public class DefaultOutlineChooserForm
extends AbstractMobileForm
implements IOutlineChooserForm {
    protected boolean getConfiguredAskIfNeedSave() {
        return false;
    }

    protected int getConfiguredDisplayHint() {
        return 20;
    }

    protected String getConfiguredDisplayViewId() {
        return "C";
    }

    protected String getConfiguredTitle() {
        return TEXTS.get((String)"MobileOutlineChooserTitle");
    }

    public void startView() throws ProcessingException {
        this.startInternal((IFormHandler)new ViewHandler());
    }

    public MainBox getMainBox() {
        return (MainBox)this.getRootGroupBox();
    }

    public MainBox.OutlinesTableField getOutlinesTableField() {
        return (MainBox.OutlinesTableField)this.getFieldByClass(MainBox.OutlinesTableField.class);
    }

    @Override
    protected boolean getConfiguredHeaderVisible() {
        return true;
    }

    @Override
    protected boolean getConfiguredFooterVisible() {
        return true;
    }

    @Order(value=10.0)
    public class MainBox
    extends AbstractGroupBox {
        protected boolean getConfiguredBorderVisible() {
            return false;
        }

        protected void execInitField() throws ProcessingException {
            DeviceTransformationConfig config = DeviceTransformationUtility.getDeviceTransformationConfig();
            if (config != null) {
                config.excludeFieldTransformation((IFormField)this, MobileDeviceTransformation.MAKE_MAINBOX_SCROLLABLE);
            }
        }

        @Order(value=10.0)
        public class OutlinesTableField
        extends AbstractTableField<Table> {
            protected boolean getConfiguredLabelVisible() {
                return false;
            }

            protected int getConfiguredGridH() {
                return 2;
            }

            @Order(value=10.0)
            public class Table
            extends AbstractMobileTable {
                @Override
                protected boolean execIsAutoCreateTableRowForm() {
                    return false;
                }

                protected boolean getConfiguredAutoDiscardOnDelete() {
                    return true;
                }

                protected String getConfiguredDefaultIconId() {
                    return "tree_node";
                }

                protected boolean getConfiguredAutoResizeColumns() {
                    return true;
                }

                protected boolean getConfiguredSortEnabled() {
                    return false;
                }

                public LabelColumn getLableColumn() {
                    return (LabelColumn)this.getColumnSet().getColumnByClass(LabelColumn.class);
                }

                public OutlineColumn getOutlineColumn() {
                    return (OutlineColumn)this.getColumnSet().getColumnByClass(OutlineColumn.class);
                }

                protected void execDecorateRow(ITableRow row) throws ProcessingException {
                    String outlineIcon = ((IOutline)this.getOutlineColumn().getValue(row)).getIconId();
                    if (outlineIcon != null) {
                        row.setIconId(outlineIcon);
                    }
                }

                protected void execRowsSelected(List<? extends ITableRow> rows) throws ProcessingException {
                    if (CollectionUtility.hasElements(rows)) {
                        IOutline outline = (IOutline)this.getOutlineColumn().getValue((ITableRow)CollectionUtility.firstElement(rows));
                        MobileDesktopUtility.activateOutline(outline);
                        DefaultOutlineChooserForm.this.getDesktop().removeForm((IForm)DefaultOutlineChooserForm.this);
                        this.clearSelectionDelayed();
                    }
                }

                @Order(value=20.0)
                public class LabelColumn
                extends AbstractStringColumn {
                }

                @Order(value=10.0)
                public class OutlineColumn
                extends AbstractColumn<IOutline> {
                    protected boolean getConfiguredDisplayable() {
                        return false;
                    }
                }
            }
        }
    }

    @Order(value=10.0)
    public class ViewHandler
    extends AbstractFormHandler {
        protected void execLoad() throws ProcessingException {
            MainBox.OutlinesTableField.Table table = (MainBox.OutlinesTableField.Table)DefaultOutlineChooserForm.this.getOutlinesTableField().getTable();
            for (IOutline outline : DefaultOutlineChooserForm.this.getDesktop().getAvailableOutlines()) {
                if (!outline.isVisible() || outline.getRootNode() == null) continue;
                ITableRow row = table.createRow(new Object[]{outline, outline.getTitle()});
                row.setEnabled(outline.isEnabled());
                table.addRow(row);
            }
        }

        protected void execFinally() throws ProcessingException {
            MainBox.OutlinesTableField.Table table = (MainBox.OutlinesTableField.Table)DefaultOutlineChooserForm.this.getOutlinesTableField().getTable();
            table.discardAllRows();
        }
    }
}

