/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.FileUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.server.commons.servletfilter.HttpServletEx;
import org.osgi.framework.Bundle;

public class ResourceServlet
extends HttpServletEx {
    private static final long serialVersionUID = 1L;
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String IF_NONE_MATCH = "If-None-Match";
    private static final String ETAG = "ETag";
    private String m_warPath;
    private String m_bundleName;
    private String m_bundlePath;

    public ResourceServlet() {
    }

    public ResourceServlet(String internalName) {
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.m_warPath = config.getInitParameter("base-name");
        if (this.m_warPath == null) {
            this.m_warPath = config.getInitParameter("war-path");
        }
        if (!StringUtility.hasText((String)this.m_warPath)) {
            this.m_warPath = null;
        }
        if (this.m_warPath != null && this.m_warPath.endsWith("/")) {
            this.m_warPath = this.m_warPath.substring(0, this.m_warPath.length() - 1);
        }
        this.m_bundleName = config.getInitParameter("bundle-name");
        if (!StringUtility.hasText((String)this.m_bundleName)) {
            this.m_bundleName = null;
        }
        this.m_bundlePath = config.getInitParameter("bundle-path");
        if (!StringUtility.hasText((String)this.m_bundlePath)) {
            this.m_bundlePath = null;
        }
        if (this.m_bundlePath != null && this.m_bundlePath.endsWith("/")) {
            this.m_bundlePath = this.m_bundlePath.substring(0, this.m_bundlePath.length() - 1);
        }
        if (this.m_warPath == null && (this.m_bundleName == null || this.m_bundlePath == null)) {
            throw new ServletException("Missing init parameters. Set either 'war-path' or 'bundle-name','bundle-path'");
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Path p = new Path(req.getRequestURI());
        String lastSegment = p.lastSegment();
        if (lastSegment != null && lastSegment.contains(".") || req.getRequestURI().endsWith("/")) {
            if (!this.writeStaticResource(req, res)) {
                res.setStatus(404);
            }
        } else {
            res.sendRedirect(String.valueOf(req.getRequestURI()) + "/");
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!this.writeStaticResource(req, res)) {
            res.setStatus(404);
        }
    }

    private boolean writeStaticResource(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String pathInfo = req.getPathInfo();
        if (pathInfo == null || pathInfo.endsWith("/") || pathInfo.equals("")) {
            pathInfo = "/index.html";
        }
        URL url = null;
        String contentType = null;
        if (this.m_warPath != null) {
            ServletContext servletContext = this.getServletContext();
            String resourcePath = String.valueOf(this.m_warPath) + pathInfo;
            url = servletContext.getResource(resourcePath);
            contentType = servletContext.getMimeType(resourcePath);
        } else if (this.m_bundleName != null && this.m_bundlePath != null) {
            String resourcePath = String.valueOf(this.m_bundlePath) + pathInfo;
            Bundle bundle = Platform.getBundle((String)this.m_bundleName);
            if (bundle != null) {
                url = bundle.getResource(resourcePath);
            }
        }
        if (url == null) {
            return false;
        }
        URLConnection connection = url.openConnection();
        long lastModified = connection.getLastModified();
        int contentLength = connection.getContentLength();
        if (contentType == null) {
            String[] a = pathInfo.split("[.]");
            contentType = FileUtility.getContentTypeForExtension((String)a[a.length - 1]);
        }
        InputStream is = null;
        try {
            if (this.setResponseParameters(req, resp, contentType, lastModified, contentLength) == 304) {
                return true;
            }
            is = connection.getInputStream();
            ServletOutputStream os = resp.getOutputStream();
            byte[] buffer = new byte[8192];
            int bytesRead = is.read(buffer);
            int writtenContentLength = 0;
            while (bytesRead != -1) {
                os.write(buffer, 0, bytesRead);
                writtenContentLength += bytesRead;
                bytesRead = is.read(buffer);
            }
            if (contentLength == -1 || contentLength != writtenContentLength) {
                resp.setContentLength(writtenContentLength);
            }
            return true;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    protected int setResponseParameters(HttpServletRequest req, HttpServletResponse resp, String contentType, long lastModified, int contentLength) {
        String ifNoneMatch;
        String etag = null;
        if (lastModified != -1L && contentLength != -1) {
            etag = "W/\"" + contentLength + "-" + lastModified + "\"";
        }
        if ((ifNoneMatch = req.getHeader(IF_NONE_MATCH)) != null && etag != null && ifNoneMatch.indexOf(etag) != -1) {
            resp.setStatus(304);
            return 304;
        }
        long ifModifiedSince = req.getDateHeader(IF_MODIFIED_SINCE);
        if (ifModifiedSince > -1L && lastModified > 0L && lastModified <= ifModifiedSince + 999L) {
            resp.setStatus(304);
            return 304;
        }
        if (contentLength != -1) {
            resp.setContentLength(contentLength);
        }
        if (contentType != null) {
            resp.setContentType(contentType);
        }
        if (lastModified > 0L) {
            resp.setDateHeader(LAST_MODIFIED, lastModified);
        }
        if (etag != null) {
            resp.setHeader(ETAG, etag);
        }
        return 202;
    }
}

