/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.admin.html.view;

import java.io.Serializable;
import org.eclipse.scout.rt.server.admin.html.AbstractHtmlAction;
import org.eclipse.scout.rt.server.admin.html.AdminSession;
import org.eclipse.scout.rt.server.admin.html.IView;
import org.eclipse.scout.rt.server.admin.html.view.CallsView;
import org.eclipse.scout.rt.server.admin.html.view.DefaultView;
import org.eclipse.scout.rt.server.admin.html.view.GeneralView;
import org.eclipse.scout.rt.server.admin.html.view.MessagesView;
import org.eclipse.scout.rt.server.admin.html.view.ServicesView;
import org.eclipse.scout.rt.server.admin.html.view.SessionsView;
import org.eclipse.scout.rt.server.admin.html.widget.table.HtmlComponent;

public class TopView
extends DefaultView
implements Serializable {
    private static final long serialVersionUID = -4145097068331865304L;
    private MessagesView m_messagesView;
    private GeneralView m_generalView;
    private ServicesView m_servicesView;
    private SessionsView m_sessionsView;
    private CallsView m_callsView;
    private IView m_activeView;

    public TopView(AdminSession as) {
        super(as);
        this.m_messagesView = new MessagesView(as);
        this.m_generalView = new GeneralView(as);
        this.m_servicesView = new ServicesView(as);
        this.m_sessionsView = new SessionsView(as);
        this.m_callsView = new CallsView(as);
        this.m_activeView = this.m_generalView;
    }

    public IView getActiveView() {
        return this.m_activeView;
    }

    public void showGeneral() {
        this.m_activeView = this.m_generalView;
    }

    public void showServices() {
        this.m_activeView = this.m_servicesView;
    }

    public void showUsers() {
        this.m_activeView = this.m_sessionsView;
    }

    public void showSessions() {
        this.m_activeView = this.m_sessionsView;
    }

    public void showCalls() {
        this.m_activeView = this.m_callsView;
    }

    public GeneralView getGeneralView() {
        return this.m_generalView;
    }

    public ServicesView getServicesView() {
        return this.m_servicesView;
    }

    public SessionsView getSessionsView() {
        return this.m_sessionsView;
    }

    public CallsView getCallsView() {
        return this.m_callsView;
    }

    @Override
    public void produceBody(HtmlComponent p) {
        this.m_messagesView.produceBody(p);
        p.raw("[ ");
        IView[] iViewArray = new IView[]{this.m_generalView, this.m_servicesView, this.m_sessionsView, this.m_callsView};
        int n = iViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            IView v = iViewArray[n2];
            if (v.isVisible()) {
                p.raw("&nbsp;");
                if (v == this.m_activeView) {
                    p.raw("<b>");
                    v.produceTitle(p);
                    p.raw("</b>");
                } else {
                    final IView finalV = v;
                    p.startLinkAction(new AbstractHtmlAction("tab." + v.getClass().getSimpleName()){
                        private static final long serialVersionUID = 2904441773328750585L;

                        @Override
                        public void run() {
                            TopView.this.m_activeView = finalV;
                            if (TopView.this.m_activeView != null) {
                                TopView.this.m_activeView.activated();
                            }
                        }
                    });
                    v.produceTitle(p);
                    p.endLinkAction();
                }
                p.raw("&nbsp;");
                p.raw("&nbsp;");
            }
            ++n2;
        }
        p.raw(" ]");
        p.p();
        if (this.m_activeView != null) {
            this.m_activeView.produceBody(p);
        }
    }
}

