/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.admin.inspector;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.commons.TTLCache;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.admin.inspector.SessionInspector;
import org.eclipse.scout.rt.server.internal.Activator;

public class ProcessInspector {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ProcessInspector.class);
    private boolean m_servletInspectorEnabled = false;
    private TTLCache<IServerSession, SessionInspector> m_sessionToInspectorMap;
    private Object m_sessionToInspectorMapLock = new Object();
    private Set<String> m_ignoredCallSet;

    public static synchronized ProcessInspector getDefault() {
        return Activator.getDefault().getProcessInspector();
    }

    public ProcessInspector() {
        this.m_sessionToInspectorMap = new TTLCache(120000L);
        this.m_ignoredCallSet = new HashSet<String>();
    }

    public boolean isEnabled() {
        return this.m_servletInspectorEnabled;
    }

    public void setEnabled(boolean b) {
        this.m_servletInspectorEnabled = b;
        if (!b) {
            this.clearSessionInspectors();
        }
    }

    public Set<String> getIgnoredCallSet() {
        return this.m_ignoredCallSet;
    }

    public boolean acceptCall(String serviceClassName, String operation) {
        String callId = String.valueOf(serviceClassName) + "." + operation;
        for (String s : this.m_ignoredCallSet) {
            if (!callId.matches(s)) continue;
            return false;
        }
        return true;
    }

    public void update() {
        SessionInspector[] sessionInspectorArray = this.getSessionInspectors();
        int n = sessionInspectorArray.length;
        int n2 = 0;
        while (n2 < n) {
            SessionInspector i = sessionInspectorArray[n2];
            i.doHousekeeping(this.getTimeout());
            ++n2;
        }
    }

    public long getTimeout() {
        return this.m_sessionToInspectorMap.getTTL();
    }

    public void setTimeout(long timeoutMillis) {
        this.m_sessionToInspectorMap.setTTL(timeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionInspector[] getSessionInspectors(String user) {
        Object object = this.m_sessionToInspectorMapLock;
        synchronized (object) {
            ArrayList<SessionInspector> a = new ArrayList<SessionInspector>();
            for (SessionInspector si : this.m_sessionToInspectorMap.values()) {
                if (!user.equalsIgnoreCase(si.getInfo().getUserId())) continue;
                a.add(si);
            }
            return a.toArray(new SessionInspector[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionInspector[] getSessionInspectors() {
        Object object = this.m_sessionToInspectorMapLock;
        synchronized (object) {
            return this.m_sessionToInspectorMap.values().toArray(new SessionInspector[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionInspector getSessionInspector(IServerSession session, boolean autoCreate) {
        Object object = this.m_sessionToInspectorMapLock;
        synchronized (object) {
            SessionInspector insp = (SessionInspector)this.m_sessionToInspectorMap.get((Object)session);
            if (insp == null && this.isEnabled() && autoCreate) {
                insp = new SessionInspector(this, session);
                this.m_sessionToInspectorMap.put((Object)session, (Object)insp);
            }
            return insp;
        }
    }

    public void clearSessionInspectors(String user) {
        for (IServerSession key : this.m_sessionToInspectorMap.keySet()) {
            SessionInspector session = (SessionInspector)this.m_sessionToInspectorMap.get((Object)key);
            if (!user.equalsIgnoreCase(session.getInfo().getUserId())) continue;
            this.m_sessionToInspectorMap.remove((Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSessionInspectors() {
        Object object = this.m_sessionToInspectorMapLock;
        synchronized (object) {
            for (IServerSession session : this.m_sessionToInspectorMap.keySet()) {
                this.m_sessionToInspectorMap.remove((Object)session);
            }
        }
    }
}

