/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ServerJob;
import org.eclipse.scout.rt.shared.OfflineState;
import org.eclipse.scout.rt.shared.TierState;
import org.eclipse.scout.service.CreateServiceImmediatelySchedulingRule;
import org.eclipse.scout.service.IService;
import org.eclipse.scout.service.IServiceFactory;
import org.eclipse.scout.service.ServiceUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;

public class ServerServiceFactory
implements IServiceFactory {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ServerServiceFactory.class);
    private Bundle m_bundle;
    private Class<?> m_serviceClass;
    private String m_sessionType;
    private Class<? extends IServerSession> m_sessionClass;
    private Object m_service;
    private Object m_serviceLock = new Object();

    public ServerServiceFactory(Class<?> serviceClass) {
        if (serviceClass == null) {
            throw new IllegalArgumentException("service type must not be null");
        }
        if (serviceClass.isInterface()) {
            throw new IllegalArgumentException("service type must not be an interface: " + serviceClass);
        }
        this.m_serviceClass = serviceClass;
    }

    public void serviceRegistered(final ServiceRegistration registration) throws Throwable {
        Boolean createImmediately = (Boolean)registration.getReference().getProperty("service.createImmediately");
        if (createImmediately != null && createImmediately.booleanValue()) {
            Job job = new Job("create service " + this.m_serviceClass.getSimpleName()){

                protected IStatus run(IProgressMonitor monitor) {
                    ServerServiceFactory.this.updateClassCache(registration);
                    ServerServiceFactory.this.updateInstanceCache(registration);
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)new CreateServiceImmediatelySchedulingRule());
            job.schedule();
        }
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        this.updateClassCache(registration);
        IServerSession session = ServerJob.getCurrentSession(this.m_sessionClass);
        if (session != null && (TierState.get() == TierState.Tier.BackEnd || TierState.get() == TierState.Tier.Undefined || OfflineState.isOfflineInCurrentThread())) {
            this.updateInstanceCache(registration);
            return this.m_service;
        }
        return ServiceUtility.NULL_SERVICE;
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClassCache(ServiceRegistration registration) {
        Object object = this.m_serviceLock;
        synchronized (object) {
            if (this.m_bundle == null) {
                this.m_bundle = registration.getReference().getBundle();
            }
            if (this.m_sessionType == null) {
                this.m_sessionType = (String)registration.getReference().getProperty("service.sessionScope");
            }
            try {
                if (this.m_sessionClass == null) {
                    if (this.m_sessionType == null) {
                        this.m_sessionClass = IServerSession.class;
                    } else {
                        this.m_sessionClass = this.m_bundle.loadClass(this.m_sessionType);
                        if (!IServerSession.class.isAssignableFrom(this.m_sessionClass)) {
                            throw new IllegalArgumentException("session type must be a subtype of " + IServerSession.class + ": " + this.m_sessionType);
                        }
                    }
                }
            }
            catch (Throwable t) {
                LOG.error("Failed creating class of " + this.m_serviceClass, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInstanceCache(ServiceRegistration registration) {
        Object object = this.m_serviceLock;
        synchronized (object) {
            if (this.m_service == null) {
                try {
                    this.m_service = this.m_serviceClass.newInstance();
                    if (this.m_service instanceof IService) {
                        ((IService)this.m_service).initializeService(registration);
                    }
                }
                catch (Throwable t) {
                    LOG.error("Failed creating instance of " + this.m_serviceClass, t);
                }
            }
        }
    }
}

