/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.calendar;

import java.util.Date;
import java.util.Set;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.TTLCache;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.services.common.calendar.HolidayCalendarItemParser;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarItem;
import org.eclipse.scout.rt.shared.services.common.calendar.IHolidayCalendarService;
import org.eclipse.scout.rt.shared.services.common.file.IRemoteFileService;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.scout.service.SERVICES;

@Priority(value=-1.0f)
public class HolidayCalendarService
extends AbstractService
implements IHolidayCalendarService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(HolidayCalendarService.class);
    private TTLCache<String, HolidayCalendarItemParser> m_holidayXmlCache = new TTLCache(300000L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<? extends ICalendarItem> getItems(RemoteFile spec, Date minDate, Date maxDate) throws ProcessingException {
        HolidayCalendarItemParser p = null;
        String key = spec.getPath();
        TTLCache<String, HolidayCalendarItemParser> tTLCache = this.m_holidayXmlCache;
        synchronized (tTLCache) {
            if (this.m_holidayXmlCache.containsKey((Object)key)) {
                p = (HolidayCalendarItemParser)this.m_holidayXmlCache.get((Object)key);
            } else {
                RemoteFile f = null;
                try {
                    f = ((IRemoteFileService)SERVICES.getService(IRemoteFileService.class)).getRemoteFile(spec);
                    if (f != null) {
                        p = new HolidayCalendarItemParser(f.getDecompressedInputStream(), spec.getPath());
                        this.m_holidayXmlCache.put((Object)key, (Object)p);
                    }
                }
                catch (Exception e) {
                    LOG.warn("parsing remote file:" + spec, (Throwable)e);
                }
            }
        }
        Set result = p != null ? p.getItems(LocaleThreadLocal.get(), minDate, maxDate) : CollectionUtility.hashSet((Object[])new ICalendarItem[0]);
        return result;
    }
}

