/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.clustersync;

import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNodeStatusInfo;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotificationMessage;

public class ClusterNodeStatusInfo
implements IClusterNodeStatusInfo {
    private AtomicLong m_sentMessageCount = new AtomicLong();
    private AtomicLong m_receivedMessageCount = new AtomicLong();
    private volatile Date m_lastChangedDate;
    private volatile String m_lastChangedUserId;
    private volatile String m_lastReceivedOriginNode;

    @Override
    public long getSentMessageCount() {
        return this.m_sentMessageCount.get();
    }

    @Override
    public long getReceivedMessageCount() {
        return this.m_receivedMessageCount.get();
    }

    public long incrementSentMessageCount() {
        return this.m_sentMessageCount.incrementAndGet();
    }

    public long incrementReceivedMessageCount() {
        return this.m_receivedMessageCount.incrementAndGet();
    }

    @Override
    public Date getLastReceivedDate() {
        return this.m_lastChangedDate;
    }

    @Override
    public String getLastReceivedOriginUser() {
        return this.m_lastChangedUserId;
    }

    @Override
    public String getLastReceivedOriginNode() {
        return this.m_lastReceivedOriginNode;
    }

    public void updateReceiveStatus(IClusterNotificationMessage message) {
        this.incrementReceivedMessageCount();
        this.setLastChangedDate(new Date());
        this.setLastReceivedOriginUser(message.getProperties().getOriginUser());
        this.setLastReceivedOriginNode(message.getProperties().getOriginNode());
    }

    public void setLastChangedDate(Date lastChangedDate) {
        this.m_lastChangedDate = lastChangedDate;
    }

    public void setLastReceivedOriginUser(String lastChangedUserId) {
        this.m_lastChangedUserId = lastChangedUserId;
    }

    public void setLastReceivedOriginNode(String lastReceivedOriginNode) {
        this.m_lastReceivedOriginNode = lastReceivedOriginNode;
    }
}

