/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jms;

import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.ThreadContext;
import org.eclipse.scout.rt.server.services.common.jms.IJmsConsumerService;
import org.eclipse.scout.rt.server.services.common.jms.JmsJndiConfig;
import org.eclipse.scout.rt.server.services.common.jms.internal.JmsTransactionMember;
import org.eclipse.scout.rt.server.transaction.ITransaction;
import org.eclipse.scout.service.AbstractService;

public abstract class AbstractJmsConsumerService
extends AbstractService
implements IJmsConsumerService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractJmsConsumerService.class);
    private JmsJndiConfig m_config = new JmsJndiConfig();

    public AbstractJmsConsumerService() {
        this.initConfig();
    }

    @ConfigProperty(value="STRING")
    @Order(value=10.0)
    protected String getConfiguredContextFactory() {
        return null;
    }

    public String getContextFactory() {
        return this.m_config.getInitialContextFactory();
    }

    public void setContextFactory(String s) {
        this.m_config.setInitialContextFactory(s);
    }

    @ConfigProperty(value="STRING")
    @Order(value=20.0)
    protected String getConfiguredProviderUrl() {
        return null;
    }

    public String getProviderUrl() {
        return this.m_config.getProviderUrl();
    }

    public void setProviderUrl(String s) {
        this.m_config.setProviderUrl(s);
    }

    @ConfigProperty(value="STRING")
    @Order(value=30.0)
    protected String getConfiguredConnectionFactoryJndiName() {
        return null;
    }

    public String getConnectionFactoryJndiName() {
        return this.m_config.getConnectionFactoryJndiName();
    }

    public void setConnectionFactoryJndiName(String s) {
        this.m_config.setConnectionFactoryJndiName(s);
    }

    @ConfigProperty(value="STRING")
    @Order(value=40.0)
    protected String getConfiguredJndiName() {
        return null;
    }

    public String getJndiName() {
        return this.m_config.getJndiName();
    }

    public void setJndiName(String s) {
        this.m_config.setJndiName(s);
    }

    @ConfigProperty(value="STRING")
    @Order(value=50.0)
    protected String getConfiguredJmsUsername() {
        return null;
    }

    public String getJmsUsername() {
        return this.m_config.getUserName();
    }

    public void setJmsUsername(String s) {
        this.m_config.setUserName(s);
    }

    @ConfigProperty(value="STRING")
    @Order(value=60.0)
    protected String getConfiguredJmsPassword() {
        return null;
    }

    public String getJmsPassword() {
        return this.m_config.getPassword();
    }

    public void setJmsPassword(String s) {
        this.m_config.setPassword(s);
    }

    protected void initConfig() {
        this.setConnectionFactoryJndiName(this.getConfiguredConnectionFactoryJndiName());
        this.setContextFactory(this.getConfiguredContextFactory());
        this.setJmsPassword(this.getConfiguredJmsPassword());
        this.setJmsUsername(this.getConfiguredJmsUsername());
        this.setJndiName(this.getConfiguredJndiName());
        this.setProviderUrl(this.getConfiguredProviderUrl());
    }

    @Override
    public void putObject(Object object) throws ProcessingException {
        if (LOG.isInfoEnabled()) {
            LOG.info("obj=" + object);
        }
        this.getJmsXAResource().putObject(object, true);
    }

    @Override
    public Object getObject() throws ProcessingException {
        return this.getObject(-1L);
    }

    @Override
    public Object getObject(long timeoutMillis) throws ProcessingException {
        return this.getJmsXAResource().getObject(timeoutMillis, true);
    }

    private JmsTransactionMember getJmsXAResource() throws ProcessingException {
        String resId = new Long(this.m_config.getCrc()).toString();
        ITransaction reg = ThreadContext.getTransaction();
        if (reg == null) {
            throw new ProcessingException("no ITransaction available, use ServerJob to run truncactions");
        }
        JmsTransactionMember res = (JmsTransactionMember)reg.getMember(resId);
        if (res == null) {
            res = new JmsTransactionMember(this.m_config);
            reg.registerMember(res);
        }
        return res;
    }
}

