/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.data.model.AttributePath;
import org.eclipse.scout.rt.shared.data.model.EntityPath;
import org.eclipse.scout.rt.shared.data.model.IDataModel;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;

public final class DataModelUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DataModelUtility.class);
    private static final Pattern PAT_EXTERNAL_ID = Pattern.compile("((.+)/)?([^/;]+)(;(.+))?");
    private static final Pattern PAT_SEMI_COLON = Pattern.compile("[;]");
    private static final Pattern PAT_NVPAIR = Pattern.compile("([^=]+)=(.*)");

    private DataModelUtility() {
    }

    public static String entityPathToExternalId(IDataModel f, EntityPath entityPath) {
        if (entityPath == null || entityPath.size() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (IDataModelEntity e : entityPath.elements()) {
            if (buf.length() > 0) {
                buf.append("/");
            }
            buf.append(e.getClass().getSimpleName());
            buf.append(DataModelUtility.exportMetaData(e.getMetaDataOfEntity()));
        }
        String externalId = buf.toString();
        if (LOG.isInfoEnabled()) {
            EntityPath verify = DataModelUtility.externalIdToEntityPath(f, externalId);
            if (verify == null) {
                LOG.info("entity externalId " + externalId + " resolves to null");
            } else if (!verify.equals(entityPath)) {
                LOG.info("entity externalId " + externalId + " is not valid for " + entityPath);
            }
        }
        return externalId;
    }

    public static String attributePathToExternalId(IDataModel f, AttributePath attributePath) {
        if (attributePath == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(DataModelUtility.entityPathToExternalId(f, attributePath.getEntityPath()));
        if (buf.length() > 0) {
            buf.append("/");
        }
        IDataModelAttribute a = attributePath.getAttribute();
        buf.append(a.getClass().getSimpleName());
        buf.append(DataModelUtility.exportMetaData(a.getMetaDataOfAttribute()));
        String externalId = buf.toString();
        if (LOG.isInfoEnabled()) {
            AttributePath verify = DataModelUtility.externalIdToAttributePath(f, externalId);
            if (verify == null) {
                LOG.info("attribute externalId " + externalId + " resolves to null");
            } else if (!verify.equals(attributePath)) {
                LOG.info("attribute externalId " + externalId + " is not valid for " + attributePath);
            }
        }
        return externalId;
    }

    public static EntityPath externalIdToEntityPath(IDataModel f, String externalId) {
        if (externalId == null || externalId.length() == 0) {
            return EntityPath.EMPTY;
        }
        return DataModelUtility.resolveEntityPathRec(f, externalId, EntityPath.EMPTY);
    }

    public static AttributePath externalIdToAttributePath(IDataModel f, String externalId) {
        if (externalId == null || externalId.length() == 0) {
            return null;
        }
        return DataModelUtility.resolveAttributePath(f, externalId);
    }

    private static EntityPath resolveEntityPathRec(IDataModel f, String externalId, EntityPath inputPath) {
        IDataModelEntity parentEntity;
        IDataModelEntity e;
        EntityPath resolvedPath;
        Matcher m = PAT_EXTERNAL_ID.matcher(externalId);
        if (!m.matches()) {
            throw new IllegalArgumentException("externalId is invalid: " + externalId);
        }
        String folderName = m.group(2);
        String elemName = m.group(3);
        Map<String, String> meta = DataModelUtility.importMetaData(m.group(5));
        if (folderName != null) {
            resolvedPath = DataModelUtility.resolveEntityPathRec(f, folderName, inputPath);
            if (resolvedPath == null) {
                return null;
            }
        } else {
            resolvedPath = inputPath;
        }
        if ((e = (parentEntity = resolvedPath.lastElement()) != null ? DataModelUtility.findEntity(parentEntity.getEntities(), elemName, meta) : DataModelUtility.findEntity(f.getEntities(), elemName, meta)) == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("entity externalId " + externalId + " resolves to null");
            }
            return null;
        }
        return resolvedPath.addToEnd(e);
    }

    private static AttributePath resolveAttributePath(IDataModel f, String externalId) {
        IDataModelEntity parentEntity;
        IDataModelAttribute a;
        EntityPath entityPath;
        Matcher m = PAT_EXTERNAL_ID.matcher(externalId);
        if (!m.matches()) {
            throw new IllegalArgumentException("externalId is invalid: " + externalId);
        }
        String folderName = m.group(2);
        String elemName = m.group(3);
        Map<String, String> meta = DataModelUtility.importMetaData(m.group(5));
        if (folderName != null) {
            entityPath = DataModelUtility.resolveEntityPathRec(f, folderName, EntityPath.EMPTY);
            if (entityPath == null) {
                return null;
            }
        } else {
            entityPath = EntityPath.EMPTY;
        }
        if ((a = (parentEntity = entityPath.lastElement()) != null ? DataModelUtility.findAttribute(parentEntity.getAttributes(), elemName, meta) : DataModelUtility.findAttribute(f.getAttributes(), elemName, meta)) == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("attribute externalId " + externalId + " resolves to null");
            }
            return null;
        }
        return entityPath.addToEnd(a);
    }

    public static IDataModelEntity findEntity(List<? extends IDataModelEntity> entities, String simpleName, Map<String, String> metaData) {
        if (entities != null) {
            for (IDataModelEntity iDataModelEntity : entities) {
                if (!iDataModelEntity.getClass().getSimpleName().equals(simpleName) || !CompareUtility.equals(iDataModelEntity.getMetaDataOfEntity(), metaData)) continue;
                return iDataModelEntity;
            }
        }
        return null;
    }

    public static IDataModelAttribute findAttribute(List<? extends IDataModelAttribute> attributes, String simpleName, Map<String, String> metaData) {
        if (attributes != null) {
            for (IDataModelAttribute iDataModelAttribute : attributes) {
                if (!iDataModelAttribute.getClass().getSimpleName().equals(simpleName) || !CompareUtility.equals(iDataModelAttribute.getMetaDataOfAttribute(), metaData)) continue;
                return iDataModelAttribute;
            }
        }
        return null;
    }

    public static Map<String, String> importMetaData(String s) {
        if (s == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        String[] stringArray = PAT_SEMI_COLON.split(s);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            Matcher m = PAT_NVPAIR.matcher(e);
            if (m.matches()) {
                map.put(m.group(1), m.group(2));
            }
            ++n2;
        }
        return map.size() > 0 ? map : null;
    }

    public static String exportMetaData(Map<String, String> map) {
        if (map == null || map.size() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(16);
        for (Map.Entry<String, String> e : map.entrySet()) {
            buf.append(";");
            buf.append(e.getKey());
            buf.append('=');
            if (e.getValue() == null) continue;
            buf.append(e.getValue());
        }
        return buf.toString();
    }

    public static List<? extends IDataModelEntity> sortEntities(List<? extends IDataModelEntity> entities) {
        if (CollectionUtility.isEmpty(entities)) {
            return CollectionUtility.emptyArrayList();
        }
        entities = new ArrayList<IDataModelEntity>(entities);
        Collections.sort(entities, new Comparator<IDataModelEntity>(){

            @Override
            public int compare(IDataModelEntity o1, IDataModelEntity o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return StringUtility.compareIgnoreCase((String)o1.getText(), (String)o2.getText());
            }
        });
        return entities;
    }

    public static List<? extends IDataModelAttribute> sortAttributes(List<? extends IDataModelAttribute> attributes) {
        if (CollectionUtility.isEmpty(attributes)) {
            return CollectionUtility.emptyArrayList();
        }
        attributes = new ArrayList<IDataModelAttribute>(attributes);
        Collections.sort(attributes, new Comparator<IDataModelAttribute>(){

            @Override
            public int compare(IDataModelAttribute o1, IDataModelAttribute o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                if (o1.getType() == 17 && o2.getType() != 17) {
                    return -1;
                }
                if (o2.getType() == 17 && o1.getType() != 17) {
                    return 1;
                }
                return StringUtility.compareIgnoreCase((String)o1.getText(), (String)o2.getText());
            }
        });
        return attributes;
    }
}

