/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.session.IClientSessionRegistryService;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.shared.ui.IUiDeviceType;
import org.eclipse.scout.rt.shared.ui.IUiLayer;
import org.eclipse.scout.rt.shared.ui.UiDeviceType;
import org.eclipse.scout.rt.shared.ui.UiLayer;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.rt.spec.client.HtmlFilePostProcessor;
import org.eclipse.scout.rt.spec.client.ISpecProcessor;
import org.eclipse.scout.rt.spec.client.LinearOutputPostProcessor;
import org.eclipse.scout.rt.spec.client.MediawikiAnchorPostProcessor;
import org.eclipse.scout.rt.spec.client.MediawikiPostProcessor;
import org.eclipse.scout.rt.testing.shared.ScoutJUnitPluginTestExecutor;
import org.eclipse.scout.rt.testing.shared.TestingUtility;
import org.eclipse.scout.rt.testing.shared.WaitCondition;
import org.eclipse.scout.service.SERVICES;

public class SpecJob
extends Job {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(SpecJob.class);
    private static final long STARTUP_TIMEOUT_IN_MS = 60000L;
    private final long m_startupTimeout;
    protected final Class<? extends IClientSession> m_clientSessionClass;
    private final ISpecProcessor[] m_postProcessors;

    public SpecJob(Class<? extends IClientSession> clientSessionClass, String pluginName) throws ProcessingException {
        this(clientSessionClass, 60000L, new LinearOutputPostProcessor("SpecComplete.config"), new MediawikiAnchorPostProcessor(), new MediawikiPostProcessor(), new HtmlFilePostProcessor("SpecComplete.html"));
    }

    public SpecJob(Class<? extends IClientSession> clientSessionClass, long startupTimeout, ISpecProcessor ... postProcessors) {
        super("Specification");
        this.setSystem(true);
        this.m_clientSessionClass = clientSessionClass;
        this.m_startupTimeout = startupTimeout;
        this.m_postProcessors = postProcessors;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.tryStartup();
        int code = this.runTests();
        this.postProcess();
        System.exit(code);
        return Status.OK_STATUS;
    }

    private void tryStartup() {
        try {
            this.waitForStartup();
        }
        catch (Throwable t) {
            System.err.println("Timeout waiting for SwingApplication to start: " + t);
            System.exit(0);
        }
    }

    protected void waitForStartup() throws Throwable {
        TestingUtility.waitUntil((long)this.getStartupTimeout(), (WaitCondition)new WaitCondition<Object>(){

            public Object run() {
                try {
                    IClientSession session = SpecJob.this.createClientSession();
                    return SpecJob.this.isApplicationReady(session) ? Boolean.valueOf(true) : null;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    System.exit(0);
                    return null;
                }
            }
        });
    }

    protected IClientSession createClientSession() {
        UserAgent ua = UserAgent.create((IUiLayer)UiLayer.SWING, (IUiDeviceType)UiDeviceType.DESKTOP);
        return ((IClientSessionRegistryService)SERVICES.getService(IClientSessionRegistryService.class)).newClientSession(this.m_clientSessionClass, ua);
    }

    protected boolean isApplicationReady(IClientSession session) {
        IDesktop desktop;
        return session != null && (desktop = session.getDesktop()) != null && desktop.isGuiAvailable() && desktop.isOpened();
    }

    public long getStartupTimeout() {
        return this.m_startupTimeout;
    }

    private int runTests() {
        ScoutJUnitPluginTestExecutor e = new ScoutJUnitPluginTestExecutor();
        return e.runAllTests();
    }

    private void postProcess() {
        ISpecProcessor[] iSpecProcessorArray = this.getPostProcessor();
        int n = iSpecProcessorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISpecProcessor processor = iSpecProcessorArray[n2];
            try {
                processor.process();
            }
            catch (ProcessingException e) {
                LOG.error("Error during post Processing ", (Throwable)e);
            }
            ++n2;
        }
    }

    public ISpecProcessor[] getPostProcessor() {
        return this.m_postProcessors;
    }
}

