/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.gen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.commons.ArrayComparator;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.MatrixUtility;
import org.eclipse.scout.commons.annotations.Doc;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.osgi.BundleInspector;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.spec.client.SpecUtility;
import org.eclipse.scout.rt.spec.client.config.entity.IDocEntityConfig;
import org.eclipse.scout.rt.spec.client.config.entity.IDocEntityTableConfig;
import org.eclipse.scout.rt.spec.client.gen.extract.IDocTextExtractor;
import org.eclipse.scout.rt.spec.client.gen.filter.IDocFilter;
import org.eclipse.scout.rt.spec.client.out.IDocSection;
import org.eclipse.scout.rt.spec.client.out.IDocTable;
import org.eclipse.scout.rt.spec.client.out.internal.DocTable;
import org.eclipse.scout.rt.spec.client.out.internal.Section;

public final class DocGenUtility {
    private DocGenUtility() {
    }

    public static String[] getHeaders(List<? extends IDocTextExtractor<?>> properties) {
        ArrayList<String> headers = new ArrayList<String>();
        if (properties != null) {
            for (IDocTextExtractor<?> p : properties) {
                headers.add(p.getHeader());
            }
        }
        return (String[])CollectionUtility.toArray(headers, String.class);
    }

    public static <T> String[] getTexts(T object, List<IDocTextExtractor<T>> properties) {
        if (properties != null) {
            String[] row = new String[properties.size()];
            int i = 0;
            while (i < properties.size()) {
                IDocTextExtractor<T> p = properties.get(i);
                row[i] = p.getText(object);
                ++i;
            }
            return row;
        }
        return null;
    }

    public static <T> IDocTable createDocTable(T entity, IDocEntityConfig<T> config, boolean transposedLayout) {
        List<IDocTextExtractor<T>> textExtractors = config.getPropertyTextExtractors();
        ArrayList<String[]> rows = new ArrayList<String[]>();
        String[] texts = DocGenUtility.getTexts(entity, textExtractors);
        if (texts != null && texts.length > 0) {
            rows.add(texts);
            String[][] rowArray = (String[][])CollectionUtility.toArray(rows, String[].class);
            String[] headers = DocGenUtility.getHeaders(textExtractors);
            return new DocTable(headers, rowArray, transposedLayout);
        }
        return null;
    }

    public static <T> IDocSection createDocSection(Collection<T> entities, IDocEntityTableConfig<T> config, boolean transposedLayout) {
        List<IDocTextExtractor<T>> textExtractors = config.getTextExtractors();
        ArrayList<String[]> rows = new ArrayList<String[]>();
        for (T e : entities) {
            if (!DocGenUtility.isAccepted(e, config.getFilters())) continue;
            String[] row = DocGenUtility.getTexts(e, textExtractors);
            rows.add(row);
        }
        if (rows.size() > 0) {
            Object[][] rowArray = (String[][])CollectionUtility.toArray(rows, String[].class);
            MatrixUtility.sortWithComparators((Object[][])rowArray, (ArrayComparator.ColumnComparator[])config.getSortColumns());
            String[] headers = DocGenUtility.getHeaders(textExtractors);
            DocTable table = new DocTable(headers, (String[][])rowArray, transposedLayout);
            return new Section(config.getTitle(), table, new IDocSection[0]);
        }
        return null;
    }

    public static <T> boolean isAccepted(T scoutObject, List<IDocFilter<T>> filters) {
        if (filters == null) {
            return true;
        }
        if (!DocGenUtility.isAccepted(scoutObject, filters, Doc.Filtering.REJECT, Doc.Filtering.TRANSPARENT)) {
            return false;
        }
        if (scoutObject instanceof IFormField) {
            ICompositeField superField = ((IFormField)scoutObject).getParentField();
            while (superField != null) {
                ArrayList<IDocFilter<T>> fieldFilters = new ArrayList<IDocFilter<T>>();
                for (IDocFilter<T> f : filters) {
                    fieldFilters.add(f);
                }
                if (!DocGenUtility.isAccepted(superField, fieldFilters, Doc.Filtering.REJECT, Doc.Filtering.ACCEPT_REJECT_CHILDREN)) {
                    return false;
                }
                superField = superField.getParentField();
            }
        }
        return true;
    }

    private static <T> boolean isAccepted(T scoutObject, List<IDocFilter<T>> filters, Doc.Filtering ... notAccepted) {
        for (IDocFilter<T> filter : filters) {
            Doc.Filtering filterResult = filter.accept(scoutObject);
            if (!Arrays.asList(notAccepted).contains(filterResult)) continue;
            return false;
        }
        return true;
    }

    public static Set<Class<?>> getAllDocEntityClasses() throws ProcessingException {
        return SpecUtility.getAllClasses(new BundleInspector.IClassFilter(){

            public boolean accept(Class c) {
                return IForm.class.isAssignableFrom(c) || IPage.class.isAssignableFrom(c);
            }
        });
    }
}

