/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.screenshot;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.ITypeWithClassId;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.PrintDevice;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;
import org.eclipse.scout.rt.spec.client.screenshot.PrintScreenshotsFormListener;

public class FormScreenshotPrinter {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(PrintScreenshotsFormListener.class);
    private final File m_destinationFolder;
    private final String m_contentType;
    private IForm m_form;

    public FormScreenshotPrinter(File destinationFolder) {
        this(destinationFolder, "image/jpg");
    }

    public FormScreenshotPrinter(File destinationFolder, String contentType) {
        this.m_destinationFolder = destinationFolder;
        this.m_contentType = contentType;
    }

    public String getContentType() {
        return this.m_contentType;
    }

    public File getDestinationFolder() {
        return this.m_destinationFolder;
    }

    public List<ITypeWithClassId> getPrintObjects(IForm form) {
        ArrayList<ITypeWithClassId> printMap = new ArrayList<ITypeWithClassId>();
        printMap.add((ITypeWithClassId)form);
        for (IFormField field : form.getAllFields()) {
            if (!(field instanceof ITabBox) || !field.isVisible()) continue;
            ITabBox tabBox = (ITabBox)field;
            IGroupBox selectedTab = null;
            if (tabBox.isVisible()) {
                selectedTab = tabBox.getSelectedTab();
            }
            if (!tabBox.isVisible()) continue;
            for (IGroupBox g : tabBox.getGroupBoxes()) {
                if (g == selectedTab) continue;
                printMap.add((ITypeWithClassId)g);
            }
        }
        return printMap;
    }

    protected File getPrintFile(ITypeWithClassId o) {
        return this.getPrintFile(o.classId());
    }

    protected File getPrintFile(String baseName) {
        String ext = this.getContentType().substring(this.getContentType().lastIndexOf(47) + 1);
        return new File(this.getDestinationFolder(), String.valueOf(baseName) + "." + ext);
    }

    protected void printGroupBox(IGroupBox g, File file) {
        LOG.info("Printing: {}", (Object)file.getPath());
        ICompositeField parentTab = g.getParentField();
        if (!g.isVisible()) {
            g.setVisible(true);
        }
        if (parentTab instanceof ITabBox) {
            ((ITabBox)parentTab).setSelectedTab(g);
        }
        Map<String, Object> parameters = this.createPrintParams(file);
        parentTab.printField(PrintDevice.File, parameters);
    }

    protected void printForm(IForm form, File file) {
        LOG.info("Printing: {}", (Object)file.getPath());
        Map<String, Object> parameters = this.createPrintParams(file);
        form.printForm(PrintDevice.File, parameters);
    }

    protected void print(ITypeWithClassId o) {
        File file = this.getPrintFile(o);
        this.getDestinationFolder().mkdirs();
        if (o instanceof IForm) {
            this.printForm((IForm)o, file);
        } else if (o instanceof IGroupBox) {
            this.printGroupBox((IGroupBox)o, file);
        } else {
            LOG.error("Could not print object {}", (Object)o);
        }
    }

    private Map<String, Object> createPrintParams(File out) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("file", out);
        parameters.put("contentType", this.getContentType());
        return parameters;
    }

    public void setForm(IForm form) {
        this.m_form = form;
    }
}

