/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.basic;

import java.io.File;
import java.util.Map;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.PrintDevice;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

@Deprecated
public class WidgetPrinter {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(WidgetPrinter.class);
    private Control m_widget;
    private File m_printedFile;

    public WidgetPrinter(Control w) {
        this.m_widget = w;
    }

    public void print(PrintDevice device, Map<String, Object> parameters) throws Throwable {
        block0: {
            if (device != PrintDevice.File) break block0;
            this.printToFile(this.createImage(), parameters);
        }
    }

    public File getOutputFile() {
        return this.m_printedFile;
    }

    private void printToFile(Image image, Map<String, Object> parameters) throws Throwable {
        this.m_printedFile = (File)parameters.remove("file");
        if (this.m_printedFile == null) {
            throw new IllegalArgumentException("parameter \"file\" must not be null");
        }
        String contentType = (String)parameters.remove("contentType");
        if (contentType == null) {
            contentType = "image/jpg";
        }
        if (!contentType.startsWith("image/")) {
            throw new IllegalArgumentException("only supporting contentTypes image/*");
        }
        for (String n : parameters.keySet()) {
            LOG.warn("Unknown parameter: " + n + "=" + parameters.get(n));
        }
        File tmpFile = new File(String.valueOf(this.m_printedFile.getAbsolutePath()) + ".tmp");
        tmpFile.getParentFile().mkdirs();
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{image.getImageData()};
        imageLoader.save(tmpFile.getAbsolutePath(), 4);
        image.dispose();
        this.m_printedFile.delete();
        tmpFile.renameTo(this.m_printedFile);
    }

    private Image createImage() {
        Rectangle bounds = this.m_widget.getBounds();
        int x = 0;
        int y = 0;
        if (this.m_widget instanceof Shell) {
            Rectangle ca = ((Shell)this.m_widget).getClientArea();
            x = (bounds.width - ca.width) / 2;
            y = bounds.height - ca.height - x;
        }
        GC gc = new GC((Drawable)this.m_widget);
        Image image = new Image((Device)this.m_widget.getDisplay(), bounds.width, bounds.height);
        gc.drawImage(image, -x, -y);
        gc.dispose();
        return image;
    }
}

