/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.basic.table.celleditor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.keystroke.AbstractKeyStroke;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.basic.RwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.basic.table.celleditor.FormFieldPopupEvent;
import org.eclipse.scout.rt.ui.rap.basic.table.celleditor.IFormFieldPopupEventListener;
import org.eclipse.scout.rt.ui.rap.form.IRwtScoutForm;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.scout.rt.ui.rap.window.RwtScoutPartEvent;
import org.eclipse.scout.rt.ui.rap.window.RwtScoutPartListener;
import org.eclipse.scout.rt.ui.rap.window.popup.RwtScoutDropDownPopup;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class RwtScoutFormFieldPopup
extends RwtScoutComposite<IFormField> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutFormFieldPopup.class);
    private P_RwtScoutDropDownPopup m_uiScoutPopup;
    private Composite m_owner;
    private int m_minWidth;
    private int m_prefWidth;
    private int m_minHeight;
    private int m_prefHeight;
    private int m_style;
    private RwtScoutPartListener m_popupEventListener;
    private P_TraverseTabKeyListener m_traverseTabKeyListener;
    private P_FocusLostListener m_focusLostListener;
    private List<IFormFieldPopupEventListener> m_eventListeners = new ArrayList<IFormFieldPopupEventListener>();
    private Object m_eventListenerLock = new Object();

    public RwtScoutFormFieldPopup(Composite owner) {
        this.m_owner = owner;
        this.m_style = 8;
        this.m_popupEventListener = new P_PopupEventListener();
        this.m_traverseTabKeyListener = new P_TraverseTabKeyListener();
        this.m_focusLostListener = new P_FocusLostListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initializeUi(Composite parent) {
        super.initializeUi(parent);
        final AtomicReference formRef = new AtomicReference();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    P_Form form = new P_Form();
                    form.setAutoAddRemoveOnDesktop(false);
                    form.startForm();
                    formRef.set(form);
                }
                catch (Throwable t) {
                    LOG.error("failed to start popup form", t);
                }
                AtomicReference atomicReference = formRef;
                synchronized (atomicReference) {
                    formRef.notifyAll();
                }
            }
        };
        AtomicReference atomicReference = formRef;
        synchronized (atomicReference) {
            this.getUiEnvironment().invokeScoutLater(runnable, 2345L);
            try {
                formRef.wait(2350L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        IForm form = (IForm)formRef.get();
        if (form == null) {
            LOG.error("No popup form available");
            return;
        }
        this.m_uiScoutPopup = new P_RwtScoutDropDownPopup();
        this.m_uiScoutPopup.createPart(form, this.m_owner, this.m_style, this.getUiEnvironment());
        this.m_uiScoutPopup.setPopupOnField(true);
        this.m_uiScoutPopup.setHeightHint(this.m_prefHeight);
        this.m_uiScoutPopup.setWidthHint(this.m_prefWidth);
        this.m_uiScoutPopup.getShell().setMinimumSize(this.m_minWidth, this.m_minHeight);
        this.m_uiScoutPopup.addRwtScoutPartListener(this.m_popupEventListener);
        try {
            this.m_uiScoutPopup.showPart();
            this.installTraverseKeyStrokes((Control)this.m_uiScoutPopup.getUiContentPane());
            this.installFocusOutListeners((Control)this.m_uiScoutPopup.getUiContentPane());
        }
        catch (Throwable t) {
            LOG.error("failed to show popup form", t);
        }
        this.m_owner.addControlListener((ControlListener)new ControlAdapter(){
            private static final long serialVersionUID = 1L;

            public void controlResized(ControlEvent e) {
                RwtScoutFormFieldPopup.this.getUiContainer().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (RwtScoutFormFieldPopup.this.m_uiScoutPopup != null) {
                            RwtScoutFormFieldPopup.this.m_uiScoutPopup.autoAdjustBounds();
                        }
                    }
                });
            }
        });
        this.setUiContainer(this.m_owner);
    }

    public void touch() {
        if (this.m_uiScoutPopup != null) {
            this.touch((Control)this.m_uiScoutPopup.getUiContentPane());
        }
    }

    private void touch(int type) {
        if ((type & 2) == 0) {
            this.touch();
        }
    }

    private void touch(Control control) {
        if (control == null || control.isDisposed()) {
            return;
        }
        this.fireFocusLostEvent(control);
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.touch(child);
                ++n2;
            }
        }
    }

    private void fireFocusLostEvent(Control control) {
        Event focusEvent = new Event();
        focusEvent.widget = control;
        control.notifyListeners(16, focusEvent);
    }

    private void installTraverseKeyStrokes(Control control) {
        control.addTraverseListener((TraverseListener)this.m_traverseTabKeyListener);
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.installTraverseKeyStrokes(child);
                ++n2;
            }
        }
    }

    private void uninstallTraverseKeyStrokes(Control control) {
        control.removeTraverseListener((TraverseListener)this.m_traverseTabKeyListener);
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.uninstallTraverseKeyStrokes(child);
                ++n2;
            }
        }
    }

    private void installFocusOutListeners(Control control) {
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.installFocusOutListeners(child);
                ++n2;
            }
        } else {
            control.addFocusListener((FocusListener)this.m_focusLostListener);
        }
    }

    private void uninstallFocusOutListeners(Control control) {
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.uninstallFocusOutListeners(child);
                ++n2;
            }
        } else {
            control.removeFocusListener((FocusListener)this.m_focusLostListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(IFormFieldPopupEventListener eventListener) {
        Object object = this.m_eventListenerLock;
        synchronized (object) {
            this.m_eventListeners.add(eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(IFormFieldPopupEventListener eventListener) {
        Object object = this.m_eventListenerLock;
        synchronized (object) {
            this.m_eventListeners.remove(eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyEventListeners(FormFieldPopupEvent event) {
        IFormFieldPopupEventListener[] eventListeners;
        Object object = this.m_eventListenerLock;
        synchronized (object) {
            eventListeners = this.m_eventListeners.toArray(new IFormFieldPopupEventListener[this.m_eventListeners.size()]);
        }
        IFormFieldPopupEventListener[] iFormFieldPopupEventListenerArray = eventListeners;
        int n = eventListeners.length;
        int n2 = 0;
        while (n2 < n) {
            IFormFieldPopupEventListener eventListener = iFormFieldPopupEventListenerArray[n2];
            eventListener.handleEvent(event);
            ++n2;
        }
    }

    public void closePopup(int type) {
        this.touch(type);
        this.m_uiScoutPopup.removeRwtScoutPartListener(this.m_popupEventListener);
        this.m_uiScoutPopup.closePart();
        this.m_uiScoutPopup = null;
        this.notifyEventListeners(new FormFieldPopupEvent((IFormField)this.getScoutObject(), type));
    }

    public RwtScoutDropDownPopup getPopup() {
        return this.m_uiScoutPopup;
    }

    public boolean isClosed() {
        return this.m_uiScoutPopup == null || this.m_uiScoutPopup.getUiContentPane() == null || this.m_uiScoutPopup.getUiContentPane().isDisposed();
    }

    public IRwtScoutForm getInnerRwtScoutForm() {
        return this.m_uiScoutPopup.getRwtScoutForm();
    }

    public int getMinWidth() {
        return this.m_minWidth;
    }

    public void setMinWidth(int minWidth) {
        this.m_minWidth = minWidth;
    }

    public int getPrefWidth() {
        return this.m_prefWidth;
    }

    public void setPrefWidth(int prefWidth) {
        this.m_prefWidth = prefWidth;
    }

    public int getMinHeight() {
        return this.m_minHeight;
    }

    public void setMinHeight(int minHeight) {
        this.m_minHeight = minHeight;
    }

    public int getPrefHeight() {
        return this.m_prefHeight;
    }

    public void setPrefHeight(int prefHeight) {
        this.m_prefHeight = prefHeight;
    }

    public int getStyle() {
        return this.m_style;
    }

    public void setStyle(int style) {
        this.m_style = style;
    }

    private class P_FocusLostListener
    extends FocusAdapter {
        private static final long serialVersionUID = 1L;

        private P_FocusLostListener() {
        }

        public void focusLost(FocusEvent event) {
            if (event.widget instanceof Control) {
                Control focusLostControl = (Control)event.widget;
                RwtUtility.runUiInputVerifier(focusLostControl);
            }
        }
    }

    private class P_Form
    extends AbstractForm {
        protected boolean getConfiguredModal() {
            return false;
        }

        protected int getConfiguredDisplayHint() {
            return 20;
        }

        public String getDisplayViewId() {
            return "C";
        }

        protected boolean getConfiguredAskIfNeedSave() {
            return false;
        }

        public void startForm() throws ProcessingException {
            this.startInternal((IFormHandler)new FormHandler());
        }

        public MainBox getMainBox() {
            return (MainBox)this.getRootGroupBox();
        }

        private class FormHandler
        extends AbstractFormHandler {
            private FormHandler() {
            }
        }

        @Order(value=10.0)
        public class MainBox
        extends AbstractGroupBox {
            protected void injectFieldsInternal(List<IFormField> fieldList) {
                fieldList.add((IFormField)RwtScoutFormFieldPopup.this.getScoutObject());
            }

            protected boolean getConfiguredBorderVisible() {
                return false;
            }

            protected int getConfiguredGridColumnCount() {
                return 1;
            }

            protected boolean getConfiguredGridUseUiWidth() {
                return true;
            }

            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }

            @Order(value=10.0)
            public class EnterKeyStroke
            extends AbstractKeyStroke {
                protected void execAction() throws ProcessingException {
                    RwtScoutFormFieldPopup.this.getUiContainer().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            RwtScoutFormFieldPopup.this.closePopup(1);
                        }
                    });
                }

                protected String getConfiguredKeyStroke() {
                    return "ctrl-enter";
                }
            }
        }
    }

    private class P_PopupEventListener
    implements RwtScoutPartListener {
        private P_PopupEventListener() {
        }

        @Override
        public void partChanged(RwtScoutPartEvent e) {
            if (e.getType() == 50) {
                RwtScoutFormFieldPopup.this.closePopup(1);
            } else if (e.getType() == 60) {
                RwtScoutFormFieldPopup.this.closePopup(2);
            }
        }
    }

    private class P_RwtScoutDropDownPopup
    extends RwtScoutDropDownPopup {
        private ShellAdapter m_shellListener;

        private P_RwtScoutDropDownPopup() {
        }

        public void createPart(IForm scoutForm, Composite ownerComponent, int style, IRwtEnvironment uiEnvironment) {
            super.createPart(scoutForm, (Control)ownerComponent, (Control)null, style, uiEnvironment);
        }

        @Override
        protected void handleUiWindowClosed() {
            super.handleUiWindowClosed();
            RwtScoutFormFieldPopup.this.uninstallFocusOutListeners((Control)this.getUiContentPane());
            RwtScoutFormFieldPopup.this.uninstallTraverseKeyStrokes((Control)this.getUiContentPane());
        }

        @Override
        protected void installFocusListener() {
            if (this.m_shellListener == null) {
                this.m_shellListener = new ShellAdapter(){
                    private static final long serialVersionUID = 1L;

                    public void shellDeactivated(ShellEvent e) {
                        P_RwtScoutDropDownPopup.this.closePart();
                        P_RwtScoutDropDownPopup.this.fireRwtScoutPartEvent(new RwtScoutPartEvent(P_RwtScoutDropDownPopup.this, 50));
                    }

                    public void shellClosed(ShellEvent e) {
                        RwtScoutFormFieldPopup.this.uninstallFocusOutListeners((Control)RwtScoutFormFieldPopup.this.m_uiScoutPopup.getUiContentPane());
                        P_RwtScoutDropDownPopup.this.fireRwtScoutPartEvent(new RwtScoutPartEvent(P_RwtScoutDropDownPopup.this, 60));
                    }
                };
                this.getShell().addShellListener((ShellListener)this.m_shellListener);
            }
        }

        @Override
        protected void uninstallFocusLostListener() {
            if (this.m_shellListener != null) {
                this.getShell().removeShellListener((ShellListener)this.m_shellListener);
                this.m_shellListener = null;
            }
        }
    }

    private class P_TraverseTabKeyListener
    implements TraverseListener {
        private static final long serialVersionUID = 1L;

        private P_TraverseTabKeyListener() {
        }

        public void keyTraversed(TraverseEvent e) {
            switch (e.detail) {
                case 16: {
                    e.doit = false;
                    RwtScoutFormFieldPopup.this.closePopup(9);
                    break;
                }
                case 8: {
                    e.doit = false;
                    RwtScoutFormFieldPopup.this.closePopup(17);
                }
            }
        }
    }
}

