/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields;

import java.util.ArrayList;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.ui.rap.LogicalGridData;
import org.eclipse.scout.rt.ui.rap.basic.RwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.ext.ILabelComposite;
import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.rap.form.fields.IRwtScoutFormField;
import org.eclipse.scout.rt.ui.rap.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.rap.keystroke.IRwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.util.RwtLayoutUtility;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public abstract class RwtScoutFieldComposite<T extends IFormField>
extends RwtScoutComposite<T>
implements IRwtScoutFormField<T> {
    protected static final String CLIENT_PROP_INITIAL_LABEL_FONT = "scoutInitialLabelFont";
    protected static final String CLIENT_PROP_INITIAL_LABEL_BACKGROUND = "scoutInitialLabelBackground";
    protected static final String CLIENT_PROP_INITIAL_LABEL_FOREGROUND = "scoutInitialLabelForeground";
    private ILabelComposite m_label;
    private IRwtKeyStroke[] m_keyStrokes;
    private Color m_mandatoryFieldBackgroundColor;

    @Override
    public ILabelComposite getUiLabel() {
        return this.m_label;
    }

    protected void setUiLabel(ILabelComposite label) {
        this.m_label = label;
        if (this.m_label != null && label.getLayoutData() == null) {
            LogicalGridData statusLabelGridData = null;
            statusLabelGridData = ((IFormField)this.getScoutObject()).getLabelPosition() == 4 ? LogicalGridDataBuilder.createLabelOnTop(((IFormField)this.getScoutObject()).getGridData()) : LogicalGridDataBuilder.createLabel(((IFormField)this.getScoutObject()).getGridData());
            this.m_label.setLayoutData(statusLabelGridData);
        }
    }

    public Color getMandatoryFieldBackgroundColor() {
        return this.m_mandatoryFieldBackgroundColor;
    }

    protected void setErrorStatusFromScout(IProcessingStatus s) {
        if (this.getUiLabel() != null) {
            this.getUiLabel().setStatus(s);
            this.getUiContainer().layout(true, true);
        }
    }

    public void setMandatoryFieldBackgroundColor(Color mandatoryFieldBackgroundColor) {
        this.m_mandatoryFieldBackgroundColor = mandatoryFieldBackgroundColor;
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        if (this.getScoutObject() != null) {
            this.setBackgroundFromScout(((IFormField)this.getScoutObject()).getBackgroundColor());
            this.setForegroundFromScout(((IFormField)this.getScoutObject()).getForegroundColor());
            this.setLabelBackgroundFromScout(((IFormField)this.getScoutObject()).getLabelBackgroundColor());
            this.setLabelForegroundFromScout(((IFormField)this.getScoutObject()).getLabelForegroundColor());
            this.setVisibleFromScout(((IFormField)this.getScoutObject()).isVisible());
            this.setEnabledFromScout(((IFormField)this.getScoutObject()).isEnabled());
            if (!(this.getScoutObject() instanceof ISequenceBox)) {
                this.setMandatoryFromScout(((IFormField)this.getScoutObject()).isMandatory());
            }
            this.setErrorStatusFromScout(((IFormField)this.getScoutObject()).getErrorStatus());
            this.setLabelFromScout(((IFormField)this.getScoutObject()).getLabel());
            this.setLabelWidthInPixelFromScout();
            this.setLabelVisibleFromScout();
            this.setLabelHorizontalAlignmentFromScout();
            this.setTooltipTextFromScout(((IFormField)this.getScoutObject()).getTooltipText());
            if (((IFormField)this.getScoutObject()).getLabelPosition() == 2 && ((IFormField)this.getScoutObject()).getLabel() != null && ((IFormField)this.getScoutObject()).getTooltipText() == null) {
                this.setTooltipTextFromScout(((IFormField)this.getScoutObject()).getLabel());
            }
            this.setFontFromScout(((IFormField)this.getScoutObject()).getFont());
            this.setLabelFontFromScout(((IFormField)this.getScoutObject()).getLabelFont());
            this.setSaveNeededFromScout(((IFormField)this.getScoutObject()).isSaveNeeded());
            this.setFocusableFromScout(((IFormField)this.getScoutObject()).isFocusable());
            this.updateKeyStrokesFromScout();
        }
    }

    protected void setVisibleFromScout(boolean b) {
        boolean updateLayout = false;
        if (this.getUiContainer() != null) {
            if (this.getUiContainer().getVisible() != b) {
                boolean wasVisible = this.getUiContainer().isVisible();
                this.getUiContainer().setVisible(b);
                updateLayout = wasVisible ^ this.getUiContainer().isVisible();
            }
        } else if (this.getUiField() != null && this.getUiField().getVisible() != b) {
            updateLayout = true;
            this.getUiField().setVisible(b);
        }
        if (updateLayout && this.isCreated()) {
            RwtLayoutUtility.invalidateLayout(this.getUiEnvironment(), (Control)this.getUiContainer());
        }
    }

    protected void setEnabledFromScout(boolean b) {
        Control field = this.getUiField();
        if (field != null) {
            this.setFieldEnabled(field, b);
            if (b) {
                this.setForegroundFromScout(((IFormField)this.getScoutObject()).getForegroundColor());
            } else {
                this.setForegroundFromScout(UiDecorationExtensionPoint.getLookAndFeel().getColorForegroundDisabled());
            }
        }
        if (this.getUiLabel() != null && this.getUiLabel().getEnabled() != b) {
            this.getUiLabel().setEnabled(b);
        }
    }

    protected void setFieldEnabled(Control field, boolean enabled) {
        field.setEnabled(enabled);
    }

    protected void setMandatoryFromScout(boolean b) {
        String fieldBackgroundColorString = UiDecorationExtensionPoint.getLookAndFeel().getMandatoryFieldBackgroundColor();
        if (fieldBackgroundColorString != null) {
            Color color = null;
            color = b ? this.getUiEnvironment().getColor(fieldBackgroundColorString) : null;
            if (this.getMandatoryFieldBackgroundColor() != color) {
                this.setMandatoryFieldBackgroundColor(color);
                this.setBackgroundFromScout(((IFormField)this.getScoutObject()).getBackgroundColor());
            }
        }
        if (this.getUiLabel() != null) {
            if (this.getUiLabel().setMandatory(b) && this.isCreated()) {
                RwtLayoutUtility.invalidateLayout(this.getUiEnvironment(), (Control)this.getUiContainer());
            }
            if (((IFormField)this.getScoutObject()).getLabelPosition() == 2) {
                this.setLabelVisibleFromScout();
            }
        }
    }

    protected void setLabelWidthInPixelFromScout() {
        if (this.getUiLabel() == null) {
            return;
        }
        int w = ((IFormField)this.getScoutObject()).getLabelWidthInPixel();
        if (w > 0) {
            this.getUiLabel().setLayoutWidthHint(w);
        } else if (w == 0) {
            this.getUiLabel().setLayoutWidthHint(UiDecorationExtensionPoint.getLookAndFeel().getFormFieldLabelWidth());
        } else if (w == -1) {
            this.getUiLabel().setLayoutWidthHint(0);
        }
    }

    protected void setLabelHorizontalAlignmentFromScout() {
    }

    protected void setLabelFromScout(String s) {
        if (this.m_label == null || s == null) {
            return;
        }
        if (((IFormField)this.getScoutObject()).getLabelPosition() == 2) {
            this.setLabelOnField(s);
        } else {
            this.m_label.setText(s);
        }
    }

    protected void setLabelOnField(String label) {
        if (this.getUiField() == null) {
            return;
        }
        if (label == null) {
            label = "";
        }
        if (this.getUiField() instanceof Text) {
            Text textField = (Text)this.getUiField();
            textField.setMessage(label);
        }
    }

    protected void setLabelVisibleFromScout() {
        if (this.m_label == null) {
            return;
        }
        boolean visible = ((IFormField)this.getScoutObject()).isLabelVisible();
        if (((IFormField)this.getScoutObject()).getLabelPosition() == 2) {
            this.m_label.setText(null);
            this.m_label.setLayoutWidthHint(0);
            if (!((IFormField)this.getScoutObject()).isMandatory()) {
                visible = false;
            }
        }
        this.m_label.setVisible(visible);
        if (this.getUiContainer() != null) {
            this.getUiContainer().layout(true, true);
        }
    }

    protected void setTooltipTextFromScout(String s) {
        if (this.getUiField() != null) {
            this.getUiField().setToolTipText(s);
        }
    }

    protected void setBackgroundFromScout(String scoutColor) {
        this.setBackgroundFromScout(scoutColor, this.getUiField());
    }

    protected void setBackgroundFromScout(String scoutColor, Control field) {
        Color color;
        if (field == null) {
            return;
        }
        if (field.getData("scoutInitialBackground") == null) {
            field.setData("scoutInitialBackground", (Object)field.getBackground());
        }
        if ((color = this.getMandatoryFieldBackgroundColor()) != null) {
            field.setBackground(color);
            return;
        }
        Color initCol = (Color)field.getData("scoutInitialBackground");
        color = this.getUiEnvironment().getColor(scoutColor);
        if (color == null) {
            color = initCol;
        }
        if (!CompareUtility.equals((Object)color, (Object)field.getBackground())) {
            field.setBackground(color);
        }
    }

    protected void setForegroundFromScout(String scoutColor) {
        this.setForegroundFromScout(scoutColor, this.getUiField());
    }

    protected void setForegroundFromScout(String scoutColor, Control field) {
        if (field == null) {
            return;
        }
        if (field.getData("scoutInitialForeground") == null) {
            field.setData("scoutInitialForeground", (Object)field.getForeground());
        }
        Color initCol = (Color)field.getData("scoutInitialForeground");
        Color color = this.getUiEnvironment().getColor(scoutColor);
        if (color == null) {
            color = initCol;
        }
        if (!CompareUtility.equals((Object)color, (Object)field.getForeground())) {
            field.setForeground(color);
        }
    }

    protected void setFontFromScout(FontSpec scoutFont) {
        if (this.getUiField() != null) {
            Control fld = this.getUiField();
            Font currentFont = fld.getFont();
            if (fld.getData("scoutInitialFont") == null) {
                fld.setData("scoutInitialFont", (Object)currentFont);
            }
            Font initFont = (Font)fld.getData("scoutInitialFont");
            Font f = this.getUiEnvironment().getFont(scoutFont, initFont);
            if (f == null) {
                f = initFont;
            }
            if (currentFont == null || !currentFont.equals((Object)f)) {
                fld.setFont(f);
            }
        }
        if (this.isCreated()) {
            RwtLayoutUtility.invalidateLayout(this.getUiEnvironment(), (Control)this.getUiContainer());
        }
    }

    protected void setLabelBackgroundFromScout(String scoutColor) {
        this.setLabelBackgroundFromScout(scoutColor, this.getUiLabel());
    }

    protected void setLabelBackgroundFromScout(String scoutColor, ILabelComposite label) {
        if (label == null) {
            return;
        }
        if (label.getData(CLIENT_PROP_INITIAL_LABEL_BACKGROUND) == null) {
            label.setData(CLIENT_PROP_INITIAL_LABEL_BACKGROUND, label.getBackground());
        }
        Color color = this.getMandatoryFieldBackgroundColor();
        Color initCol = (Color)label.getData(CLIENT_PROP_INITIAL_LABEL_BACKGROUND);
        color = this.getUiEnvironment().getColor(scoutColor);
        if (color == null) {
            color = initCol;
        }
        if (!CompareUtility.equals((Object)color, (Object)label.getBackground())) {
            label.setBackground(color);
        }
    }

    protected void setLabelForegroundFromScout(String scoutColor) {
        this.setLabelForegroundFromScout(scoutColor, this.getUiLabel());
    }

    protected void setLabelForegroundFromScout(String scoutColor, ILabelComposite label) {
        if (label == null) {
            return;
        }
        if (label.getData(CLIENT_PROP_INITIAL_LABEL_FOREGROUND) == null) {
            label.setData(CLIENT_PROP_INITIAL_LABEL_FOREGROUND, label.getForeground());
        }
        Color initCol = (Color)label.getData(CLIENT_PROP_INITIAL_LABEL_FOREGROUND);
        Color color = this.getUiEnvironment().getColor(scoutColor);
        if (color == null) {
            color = initCol;
        }
        if (!CompareUtility.equals((Object)color, (Object)label.getForeground())) {
            label.setForeground(color);
        }
    }

    protected void setLabelFontFromScout(FontSpec scoutFont) {
        if (this.getUiLabel() != null) {
            ILabelComposite fld = this.getUiLabel();
            Font currentFont = fld.getFont();
            if (fld.getData(CLIENT_PROP_INITIAL_LABEL_FONT) == null) {
                fld.setData(CLIENT_PROP_INITIAL_LABEL_FONT, currentFont);
            }
            Font initFont = (Font)fld.getData(CLIENT_PROP_INITIAL_LABEL_FONT);
            Font f = this.getUiEnvironment().getFont(scoutFont, initFont);
            if (f == null) {
                f = initFont;
            }
            if (currentFont == null || !currentFont.equals((Object)f)) {
                fld.setFont(f);
            }
        }
        if (this.isCreated()) {
            RwtLayoutUtility.invalidateLayout(this.getUiEnvironment(), (Control)this.getUiContainer());
        }
    }

    protected boolean isSelectAllOnFocusEnabled() {
        return UiDecorationExtensionPoint.getLookAndFeel().isFormFieldSelectAllOnFocusEnabled();
    }

    protected void setSaveNeededFromScout(boolean b) {
    }

    protected void setFocusableFromScout(boolean b) {
    }

    protected void updateEmptyFromScout() {
    }

    protected void updateKeyStrokesFromScout() {
        this.unregisterKeyStrokes((Control)this.getUiContainer());
        this.unregisterKeyStrokes(this.getUiField());
        ArrayList<IRwtKeyStroke> newUiKeyStrokes = new ArrayList<IRwtKeyStroke>();
        ArrayList scoutKeyStrokes = new ArrayList();
        Object formField = (IFormField)this.getScoutObject();
        while (formField != null) {
            scoutKeyStrokes.addAll(formField.getKeyStrokes());
            formField = formField.getParentField() == null && formField.getForm() != null && formField.getForm().getOuterFormField() != null ? formField.getForm().getOuterFormField() : formField.getParentField();
        }
        for (IKeyStroke scoutKeyStroke : scoutKeyStrokes) {
            IRwtKeyStroke[] uiStrokes;
            IRwtKeyStroke[] iRwtKeyStrokeArray = uiStrokes = RwtUtility.getKeyStrokes(scoutKeyStroke, this.getUiEnvironment());
            int n = uiStrokes.length;
            int n2 = 0;
            while (n2 < n) {
                IRwtKeyStroke uiStroke = iRwtKeyStrokeArray[n2];
                newUiKeyStrokes.add(uiStroke);
                ++n2;
            }
        }
        this.m_keyStrokes = newUiKeyStrokes.toArray(new IRwtKeyStroke[newUiKeyStrokes.size()]);
        this.registerKeyStrokes((Control)this.getUiContainer());
        this.registerKeyStrokes(this.getUiField());
    }

    protected void registerKeyStrokes(Control control) {
        if (this.m_keyStrokes == null || control == null || control.isDisposed()) {
            return;
        }
        IRwtKeyStroke[] iRwtKeyStrokeArray = this.m_keyStrokes;
        int n = this.m_keyStrokes.length;
        int n2 = 0;
        while (n2 < n) {
            IRwtKeyStroke uiStroke = iRwtKeyStrokeArray[n2];
            this.getUiEnvironment().addKeyStroke(control, uiStroke, false);
            ++n2;
        }
    }

    protected void unregisterKeyStrokes(Control control) {
        if (this.m_keyStrokes == null || control == null || control.isDisposed()) {
            return;
        }
        IRwtKeyStroke[] iRwtKeyStrokeArray = this.m_keyStrokes;
        int n = this.m_keyStrokes.length;
        int n2 = 0;
        while (n2 < n) {
            IRwtKeyStroke uiKeyStroke = iRwtKeyStrokeArray[n2];
            this.getUiEnvironment().removeKeyStroke(control, uiKeyStroke);
            ++n2;
        }
    }

    @Override
    protected void setUiContainer(Composite uiContainer) {
        this.unregisterKeyStrokes((Control)this.getUiContainer());
        super.setUiContainer(uiContainer);
        this.registerKeyStrokes((Control)uiContainer);
    }

    @Override
    protected void setUiField(Control uiField) {
        this.unregisterKeyStrokes(this.getUiField());
        super.setUiField(uiField);
        this.registerKeyStrokes(uiField);
    }

    @Override
    protected boolean isHandleScoutPropertyChange(final String name, final Object newValue) {
        if (name.equals("enabled") || name.equals("visible")) {
            this.getUiEnvironment().postImmediateUiJob(new Runnable(){

                @Override
                public void run() {
                    RwtScoutFieldComposite.this.handleScoutPropertyChange(name, newValue);
                }
            });
        }
        return super.isHandleScoutPropertyChange(name, newValue);
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("enabled")) {
            this.setEnabledFromScout((Boolean)newValue);
        } else if (name.equals("focusable")) {
            this.setFocusableFromScout((Boolean)newValue);
        } else if (name.equals("label")) {
            this.setLabelFromScout((String)newValue);
        } else if (name.equals("labelVisible")) {
            this.setLabelVisibleFromScout();
        } else if (name.equals("tooltipText")) {
            this.setTooltipTextFromScout((String)newValue);
        } else if (name.equals("visible")) {
            this.setVisibleFromScout((Boolean)newValue);
        } else if (name.equals("mandatory")) {
            this.setMandatoryFromScout((Boolean)newValue);
        } else if (name.equals("errorStatus")) {
            this.setErrorStatusFromScout((IProcessingStatus)newValue);
        } else if (name.equals("foregroundColor")) {
            this.setForegroundFromScout((String)newValue);
        } else if (name.equals("backgroundColor")) {
            this.setBackgroundFromScout((String)newValue);
        } else if (name.equals("font")) {
            this.setFontFromScout((FontSpec)newValue);
        } else if (name.equals("labelForegroundColor")) {
            this.setLabelForegroundFromScout((String)newValue);
        } else if (name.equals("labelBackgroundColor")) {
            this.setLabelBackgroundFromScout((String)newValue);
        } else if (name.equals("labelFont")) {
            this.setLabelFontFromScout((FontSpec)newValue);
        } else if (name.equals("saveNeeded")) {
            this.setSaveNeededFromScout((Boolean)newValue);
        } else if (name.equals("empty")) {
            this.updateEmptyFromScout();
        } else if (name.equals("keyStrokes")) {
            this.updateKeyStrokesFromScout();
        }
    }
}

