/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.datefield;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.IDateField;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.RwtMenuUtility;
import org.eclipse.scout.rt.ui.rap.action.menu.RwtContextMenuMarkerComposite;
import org.eclipse.scout.rt.ui.rap.action.menu.RwtScoutContextMenu;
import org.eclipse.scout.rt.ui.rap.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.rap.ext.StyledTextEx;
import org.eclipse.scout.rt.ui.rap.form.fields.IPopupSupport;
import org.eclipse.scout.rt.ui.rap.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutBasicFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.datefield.AbstractShiftKeyStroke;
import org.eclipse.scout.rt.ui.rap.form.fields.datefield.IRwtScoutTimeField;
import org.eclipse.scout.rt.ui.rap.form.fields.datefield.chooser.TimeChooserDialog;
import org.eclipse.scout.rt.ui.rap.internal.TextFieldEditableSupport;
import org.eclipse.scout.rt.ui.rap.keystroke.RwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.util.RwtLayoutUtility;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class RwtScoutTimeField
extends RwtScoutBasicFieldComposite<IDateField>
implements IRwtScoutTimeField,
IPopupSupport {
    private Button m_dropDownButton;
    private TextFieldEditableSupport m_editableSupport;
    private Set<IPopupSupport.IPopupSupportListener> m_popupEventListeners;
    private Object m_popupEventListenerLock;
    private boolean m_ignoreLabel = false;
    private Composite m_timeContainer;
    private boolean m_dateTimeCompositeMember;
    private String m_displayTextToVerify;
    private TimeChooserDialog m_timeChooserDialog = null;
    private FocusAdapter m_textFieldFocusAdapter = null;
    private RwtContextMenuMarkerComposite m_menuMarkerComposite;
    private RwtScoutContextMenu m_uiContextMenu;
    private P_ContextMenuPropertyListener m_contextMenuPropertyListener;

    @Override
    public void setIgnoreLabel(boolean ignoreLabel) {
        this.m_ignoreLabel = ignoreLabel;
        if (ignoreLabel) {
            this.getUiLabel().setVisible(false);
        } else {
            this.getUiLabel().setVisible(((IDateField)this.getScoutObject()).isLabelVisible());
        }
    }

    public boolean isIgnoreLabel() {
        return this.m_ignoreLabel;
    }

    public boolean isDateTimeCompositeMember() {
        return this.m_dateTimeCompositeMember;
    }

    @Override
    public void setDateTimeCompositeMember(boolean dateTimeCompositeMember) {
        this.m_dateTimeCompositeMember = dateTimeCompositeMember;
    }

    @Override
    protected void initializeUi(Composite parent) {
        this.m_popupEventListeners = new HashSet<IPopupSupport.IPopupSupportListener>();
        this.m_popupEventListenerLock = new Object();
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getUiEnvironment().getFormToolkit().createStatusLabel(container, (IFormField)this.getScoutObject());
        this.m_timeContainer = this.getUiEnvironment().getFormToolkit().createComposite(container, 2048);
        this.m_timeContainer.setData("org.eclipse.rap.rwt.customVariant", (Object)"inputField");
        this.m_menuMarkerComposite = new RwtContextMenuMarkerComposite(this.m_timeContainer, this.getUiEnvironment(), 0);
        this.getUiEnvironment().getFormToolkit().adapt(this.m_menuMarkerComposite);
        this.m_menuMarkerComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                if (RwtScoutTimeField.this.getUiContextMenu() != null) {
                    Menu uiMenu = RwtScoutTimeField.this.getUiContextMenu().getUiMenu();
                    if (e.widget instanceof Control) {
                        Point loc = ((Control)e.widget).toDisplay(e.x, e.y);
                        uiMenu.setLocation(RwtMenuUtility.getMenuLocation(((IDateField)RwtScoutTimeField.this.getScoutObject()).getContextMenu().getChildActions(), uiMenu, loc, RwtScoutTimeField.this.getUiEnvironment()));
                    }
                    uiMenu.setVisible(true);
                }
            }
        });
        StyledTextEx textField = new StyledTextEx(this.m_menuMarkerComposite, 4);
        this.getUiEnvironment().getFormToolkit().adapt((Control)textField, false, false);
        textField.setData("org.eclipse.rap.rwt.customVariant", "timefield");
        Button timeChooserButton = this.getUiEnvironment().getFormToolkit().createButton(this.m_timeContainer, "", 524296);
        timeChooserButton.setData("org.eclipse.rap.rwt.customVariant", (Object)"timefield");
        container.setTabList(new Control[]{this.m_timeContainer});
        this.getUiEnvironment().addKeyStroke((Control)textField, new P_TimeChooserOpenKeyStroke(), false);
        this.getUiEnvironment().addKeyStroke((Control)textField, new P_TimeChooserCloseKeyStroke(), true);
        this.getUiEnvironment().addKeyStroke((Control)textField, new P_ShiftNextQuarterHourKeyStroke(), false);
        this.getUiEnvironment().addKeyStroke((Control)textField, new P_ShiftPreviousQuarterHourKeyStroke(), false);
        this.getUiEnvironment().addKeyStroke((Control)textField, new P_ShiftNextHourKeyStroke(), false);
        this.getUiEnvironment().addKeyStroke((Control)textField, new P_ShiftPreviousHourKeyStroke(), false);
        timeChooserButton.addSelectionListener((SelectionListener)new P_RwtBrowseButtonListener());
        this.attachFocusListener((Control)textField, true);
        textField.addMouseListener((MouseListener)new MouseAdapter(){
            private static final long serialVersionUID = 1L;

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    RwtScoutTimeField.this.handleUiTimeChooserAction();
                }
            }
        });
        this.setUiContainer(container);
        this.setUiLabel(label);
        this.setDropDownButton(timeChooserButton);
        this.setUiField((Control)textField);
        container.setLayout((Layout)new LogicalGridLayout(1, 0));
        this.m_timeContainer.setLayoutData((Object)LogicalGridDataBuilder.createField(((IFormField)this.getScoutObject()).getGridData()));
        this.m_timeContainer.setLayout((Layout)RwtLayoutUtility.createGridLayoutNoSpacing(2, false));
        GridData textLayoutData = new GridData(4, 4, true, true);
        this.m_menuMarkerComposite.setLayoutData(textLayoutData);
        GridData buttonLayoutData = new GridData(0x1000000, 0x1000000, false, false);
        buttonLayoutData.heightHint = 20;
        buttonLayoutData.widthHint = 20;
        timeChooserButton.setLayoutData((Object)buttonLayoutData);
    }

    @Override
    public Button getDropDownButton() {
        return this.m_dropDownButton;
    }

    public void setDropDownButton(Button b) {
        this.m_dropDownButton = b;
    }

    @Override
    public StyledTextEx getUiField() {
        return (StyledTextEx)super.getUiField();
    }

    public RwtScoutContextMenu getUiContextMenu() {
        return this.m_uiContextMenu;
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.updateContextMenuVisibilityFromScout();
        if (((IDateField)this.getScoutObject()).getContextMenu() != null && this.m_contextMenuPropertyListener == null) {
            this.m_contextMenuPropertyListener = new P_ContextMenuPropertyListener();
            ((IDateField)this.getScoutObject()).getContextMenu().addPropertyChangeListener("visible", (PropertyChangeListener)this.m_contextMenuPropertyListener);
        }
    }

    @Override
    protected void detachScout() {
        if (this.m_contextMenuPropertyListener != null) {
            ((IDateField)this.getScoutObject()).getContextMenu().removePropertyChangeListener("visible", (PropertyChangeListener)this.m_contextMenuPropertyListener);
            this.m_contextMenuPropertyListener = null;
        }
        super.detachScout();
    }

    public boolean isFocusInTimePicker() {
        Control focusControl = this.getUiEnvironment().getDisplay().getFocusControl();
        boolean isFocusInDatePicker = RwtUtility.isAncestorOf((Control)this.m_timeChooserDialog.getShell(), focusControl);
        return isFocusInDatePicker;
    }

    private void installFocusListenerOnTextField() {
        if (this.getUiField().isDisposed()) {
            return;
        }
        this.getUiField().setFocus();
        if (this.m_textFieldFocusAdapter == null) {
            this.m_textFieldFocusAdapter = new FocusAdapter(){
                private static final long serialVersionUID = 1L;

                public void focusLost(FocusEvent e) {
                    RwtScoutTimeField.this.handleUiFocusLostOnDatePickerPopup(e);
                }
            };
        }
        this.getUiField().addFocusListener((FocusListener)this.m_textFieldFocusAdapter);
    }

    protected void handleUiFocusLostOnDatePickerPopup(FocusEvent event) {
        if (this.isFocusInTimePicker()) {
            this.getUiEnvironment().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    RwtScoutTimeField.this.getUiField().setFocus();
                }
            });
        } else {
            this.getUiEnvironment().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    RwtScoutTimeField.this.makeSureTimeChooserIsClosed();
                }
            });
        }
    }

    private void uninstallFocusListenerOnTextField() {
        if (!this.getUiField().isDisposed() && this.m_textFieldFocusAdapter != null) {
            this.getUiField().removeFocusListener((FocusListener)this.m_textFieldFocusAdapter);
        }
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        super.setEnabledFromScout(b);
        this.m_dropDownButton.setEnabled(b);
        this.getUiField().setEnabled(b);
        if (b) {
            this.m_timeContainer.setData("org.eclipse.rap.rwt.customVariant", (Object)"inputField");
        } else {
            this.m_timeContainer.setData("org.eclipse.rap.rwt.customVariant", (Object)"inputField-readOnly");
        }
    }

    @Override
    protected void setLabelVisibleFromScout() {
        if (!this.isIgnoreLabel()) {
            super.setLabelVisibleFromScout();
        }
    }

    @Override
    protected void setFieldEnabled(Control rwtField, boolean enabled) {
        if (this.m_editableSupport == null) {
            this.m_editableSupport = new TextFieldEditableSupport(this.getUiField());
        }
        this.m_editableSupport.setEditable(enabled);
    }

    @Override
    protected void setDisplayTextFromScout(String s) {
        DateFormat format;
        IDateField scoutField = (IDateField)this.getScoutObject();
        if (s == null) {
            s = "";
        }
        this.m_displayTextToVerify = s;
        Date value = (Date)scoutField.getValue();
        if (value != null && (format = scoutField.getIsolatedTimeFormat()) != null) {
            this.m_displayTextToVerify = format.format(value);
        }
        this.getUiField().setText(this.m_displayTextToVerify);
        this.getUiField().setCaretOffset(0);
    }

    @Override
    protected void setBackgroundFromScout(String scoutColor) {
        this.setBackgroundFromScout(scoutColor, (Control)this.m_timeContainer);
    }

    protected void updateContextMenuVisibilityFromScout() {
        this.m_menuMarkerComposite.setMarkerVisible(((IDateField)this.getScoutObject()).getContextMenu().isVisible());
        if (((IDateField)this.getScoutObject()).getContextMenu().isVisible()) {
            if (this.m_uiContextMenu == null) {
                this.m_uiContextMenu = new RwtScoutContextMenu(this.getUiField().getShell(), (IContextMenu)((IDateField)this.getScoutObject()).getContextMenu(), this.getUiEnvironment());
                if (this.getDropDownButton() != null) {
                    this.getDropDownButton().setMenu(this.m_uiContextMenu.getUiMenu());
                }
            }
        } else {
            if (this.getDropDownButton() != null) {
                this.getDropDownButton().setMenu(null);
            }
            if (this.m_uiContextMenu != null) {
                this.m_uiContextMenu.dispose();
            }
            this.m_uiContextMenu = null;
        }
    }

    @Override
    protected void handleUiInputVerifier(boolean doit) {
        if (!doit) {
            return;
        }
        final String text = this.getUiField().getText();
        if (CompareUtility.equals((Object)text, (Object)this.m_displayTextToVerify) && (this.isDateTimeCompositeMember() || ((IDateField)this.getScoutObject()).getErrorStatus() == null)) {
            return;
        }
        this.m_displayTextToVerify = text;
        final Holder result = new Holder(Boolean.class, (Object)false);
        Runnable t = new Runnable(){

            @Override
            public void run() {
                boolean b = ((IDateField)RwtScoutTimeField.this.getScoutObject()).getUIFacade().setTimeTextFromUI(text);
                result.setValue((Object)b);
            }
        };
        JobEx job = this.getUiEnvironment().invokeScoutLater(t, 0L);
        try {
            job.join(2345L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getUiEnvironment().dispatchImmediateUiJobs();
    }

    @Override
    protected void handleUiFocusGained() {
        if (this.isSelectAllOnFocusEnabled()) {
            this.getUiField().setSelection(0, this.getUiField().getText().length());
        }
    }

    protected void makeSureTimeChooserIsClosed() {
        if (this.m_timeChooserDialog != null) {
            this.m_timeChooserDialog.close();
        }
        this.uninstallFocusListenerOnTextField();
    }

    private void handleUiTimeChooserAction() {
        if (!this.getDropDownButton().isVisible() || !this.getDropDownButton().isEnabled()) {
            return;
        }
        Date oldTime = (Date)((IDateField)this.getScoutObject()).getValue();
        if (oldTime == null) {
            oldTime = new Date();
        }
        this.notifyPopupEventListeners(2);
        this.makeSureTimeChooserIsClosed();
        this.m_timeChooserDialog = this.createTimeChooserDialog(oldTime);
        if (this.m_timeChooserDialog != null) {
            this.m_timeChooserDialog.getShell().addDisposeListener((DisposeListener)new P_TimeChooserDisposeListener());
            this.m_timeChooserDialog.open();
            this.installFocusListenerOnTextField();
        }
    }

    protected TimeChooserDialog createTimeChooserDialog(Date currentTime) {
        return new TimeChooserDialog(this.getUiField().getShell(), (Control)this.getUiField(), currentTime);
    }

    private void getTimeFromClosedDateChooserDialog() {
        boolean setFocusToUiField = false;
        try {
            final Date newDate = this.m_timeChooserDialog.getReturnTime();
            if (newDate != null) {
                setFocusToUiField = true;
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        ((IDateField)RwtScoutTimeField.this.getScoutObject()).getUIFacade().setTimeFromUI(newDate);
                    }
                };
                this.getUiEnvironment().invokeScoutLater(t, 0L);
            }
        }
        finally {
            this.notifyPopupEventListeners(4);
            this.uninstallFocusListenerOnTextField();
            if (setFocusToUiField && !this.getUiField().isDisposed()) {
                this.getUiField().setFocus();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPopupEventListeners(int eventType) {
        IPopupSupport.IPopupSupportListener[] listeners;
        Object object = this.m_popupEventListenerLock;
        synchronized (object) {
            listeners = this.m_popupEventListeners.toArray(new IPopupSupport.IPopupSupportListener[this.m_popupEventListeners.size()]);
        }
        IPopupSupport.IPopupSupportListener[] iPopupSupportListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IPopupSupport.IPopupSupportListener listener = iPopupSupportListenerArray[n2];
            listener.handleEvent(eventType);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPopupEventListener(IPopupSupport.IPopupSupportListener listener) {
        Object object = this.m_popupEventListenerLock;
        synchronized (object) {
            this.m_popupEventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePopupEventListener(IPopupSupport.IPopupSupportListener listener) {
        Object object = this.m_popupEventListenerLock;
        synchronized (object) {
            this.m_popupEventListeners.remove(listener);
        }
    }

    private void shiftTime(final int level, final int value) {
        if (this.getUiField().isDisposed()) {
            return;
        }
        if (this.getUiField().isEnabled() && this.getUiField().getEditable() && this.getUiField().isVisible() && level >= 0) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((IDateField)RwtScoutTimeField.this.getScoutObject()).getUIFacade().fireTimeShiftActionFromUI(level, value);
                }
            };
            this.getUiEnvironment().invokeScoutLater(t, 0L);
        }
    }

    private abstract class P_AbstractShiftTimeKeyStroke
    extends AbstractShiftKeyStroke {
        public P_AbstractShiftTimeKeyStroke(int keyCode, int level, int value) {
            super(keyCode, 0, level, value);
        }

        public P_AbstractShiftTimeKeyStroke(int keyCode, int stateMask, int level, int value) {
            super(keyCode, stateMask, level, value);
        }

        @Override
        protected void shift(int level, int value) {
            RwtScoutTimeField.this.shiftTime(level, value);
        }
    }

    private class P_ContextMenuPropertyListener
    implements PropertyChangeListener {
        private P_ContextMenuPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("visible".equals(evt.getPropertyName())) {
                RwtScoutTimeField.this.getUiEnvironment().invokeUiLater(new Runnable(){

                    @Override
                    public void run() {
                        RwtScoutTimeField.this.updateContextMenuVisibilityFromScout();
                    }
                });
            }
        }
    }

    private class P_RwtBrowseButtonListener
    extends SelectionAdapter {
        private static final long serialVersionUID = 1L;

        private P_RwtBrowseButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            RwtScoutTimeField.this.getUiField().forceFocus();
            RwtScoutTimeField.this.handleUiTimeChooserAction();
        }
    }

    private class P_ShiftNextHourKeyStroke
    extends P_AbstractShiftTimeKeyStroke {
        public P_ShiftNextHourKeyStroke() {
            super(0x1000001, 131072, 1, 1);
        }
    }

    private class P_ShiftNextQuarterHourKeyStroke
    extends P_AbstractShiftTimeKeyStroke {
        public P_ShiftNextQuarterHourKeyStroke() {
            super(0x1000001, 0, 1);
        }
    }

    private class P_ShiftPreviousHourKeyStroke
    extends P_AbstractShiftTimeKeyStroke {
        public P_ShiftPreviousHourKeyStroke() {
            super(0x1000002, 131072, 1, -1);
        }
    }

    private class P_ShiftPreviousQuarterHourKeyStroke
    extends P_AbstractShiftTimeKeyStroke {
        public P_ShiftPreviousQuarterHourKeyStroke() {
            super(0x1000002, 0, -1);
        }
    }

    private class P_TimeChooserCloseKeyStroke
    extends RwtKeyStroke {
        public P_TimeChooserCloseKeyStroke() {
            super(27);
        }

        @Override
        public void handleUiAction(Event e) {
            if (RwtScoutTimeField.this.m_timeChooserDialog != null) {
                RwtScoutTimeField.this.makeSureTimeChooserIsClosed();
                e.doit = false;
            }
        }
    }

    private final class P_TimeChooserDisposeListener
    implements DisposeListener {
        private static final long serialVersionUID = 1L;

        private P_TimeChooserDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent event) {
            RwtScoutTimeField.this.getTimeFromClosedDateChooserDialog();
            RwtScoutTimeField.this.m_timeChooserDialog = null;
        }
    }

    private class P_TimeChooserOpenKeyStroke
    extends RwtKeyStroke {
        public P_TimeChooserOpenKeyStroke() {
            super(0x100000B);
        }

        @Override
        public void handleUiAction(Event e) {
            RwtScoutTimeField.this.handleUiTimeChooserAction();
        }
    }
}

