/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.datefield.chooser;

import java.text.DateFormatSymbols;
import java.util.Date;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.scout.commons.DateUtility;
import org.eclipse.scout.rt.ui.rap.ext.table.util.TableCellRolloverSupport;
import org.eclipse.scout.rt.ui.rap.form.fields.datefield.chooser.DateRow;
import org.eclipse.scout.rt.ui.rap.form.fields.datefield.chooser.DatefieldTableModel;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class DateChooserDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private static final String NEXT_YEAR_CUSTOM_VARIANT = "datechooser-dialog-next-year";
    private static final String NEXT_MONTH_CUSTOM_VARIANT = "datechooser-dialog-next-month";
    private static final String LAST_MONTH_CUSTOM_VARIANT = "datechooser-dialog-last-month";
    private static final String LAST_YEAR_CUSTOM_VARIANT = "datechooser-dialog-last-year";
    private static final String DATECHOOSER_DIALOG_CUSTOM_VARIANT = "datechooser-dialog";
    public static final int TYPE_BACK_YEAR = 1;
    public static final int TYPE_BACK_MONTH = 2;
    public static final int TYPE_FOREWARD_MONTH = 4;
    public static final int TYPE_FOREWARD_YEAR = 8;
    private static final int DATE_CELL_WIDTH = 35;
    private static final int DATE_CELL_HEIGHT = -1;
    private static final int CONTROL_BUTTON_WIDTH = 15;
    private static final int CONTROL_BUTTON_HEIGHT = 15;
    private TableViewer m_viewer;
    private Label m_monthLabel;
    private DatefieldTableModel m_model;
    private Date m_returnDate = null;
    private Control m_field;

    protected int getShellStyle() {
        return 0;
    }

    public DateChooserDialog(Shell parentShell, Control field, Date date) {
        super(parentShell);
        this.m_model = new DatefieldTableModel(RwtUtility.getClientSessionLocale(parentShell.getDisplay()));
        this.m_field = field;
        this.setDisplayDate(date);
        this.setBlockOnOpen(false);
        this.create();
    }

    private void setDisplayDate(Date date) {
        this.m_model.setHighLightDate(date);
        this.m_model.setNavigationDate(date);
    }

    public Date getReturnDate() {
        return this.m_returnDate;
    }

    protected Control getField() {
        return this.m_field;
    }

    protected Point getInitialLocation(Point initialSize, Control field) {
        Rectangle appBounds = field.getDisplay().getBounds();
        Point absPrefPos = field.toDisplay(0, field.getSize().y);
        Rectangle prefBounds = new Rectangle(absPrefPos.x, absPrefPos.y, initialSize.x, initialSize.y);
        if (prefBounds.x + prefBounds.width > appBounds.width) {
            prefBounds.x = appBounds.width - prefBounds.width;
        }
        if (prefBounds.y + prefBounds.height > appBounds.height) {
            prefBounds.y = this.dialogFitsAboveField(absPrefPos, prefBounds, field) ? this.getYCoordinateForDialogAboveField(absPrefPos, prefBounds, field) : appBounds.height - prefBounds.height;
        }
        return new Point(prefBounds.x, prefBounds.y);
    }

    private boolean dialogFitsAboveField(Point absPrefPos, Rectangle dialogPrefBounds, Control field) {
        return this.getYCoordinateForDialogAboveField(absPrefPos, dialogPrefBounds, field) >= 0;
    }

    private int getYCoordinateForDialogAboveField(Point absPrefPos, Rectangle dialogPrefBounds, Control field) {
        return absPrefPos.y - field.getBounds().height - dialogPrefBounds.height;
    }

    protected Point getInitialLocation(Point initialSize) {
        Point initialLocation = this.getInitialLocation(initialSize, this.getField());
        if (initialLocation != null) {
            return initialLocation;
        }
        return super.getInitialLocation(initialSize);
    }

    protected Control createContents(Composite parent) {
        parent.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getDialogVariant());
        Composite rootArea = new Composite(parent, 524288);
        rootArea.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getDialogVariant());
        GridData gridData = new GridData(0x1000000, 0x1000000, true, true);
        rootArea.setLayoutData((Object)gridData);
        Control navigationArea = this.createControlArea(rootArea);
        Control calendarArea = this.createPickDateArea(rootArea);
        rootArea.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        navigationArea.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(navigationArea, 2);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, -5);
        calendarArea.setLayoutData((Object)data);
        return rootArea;
    }

    protected String getDialogVariant() {
        return DATECHOOSER_DIALOG_CUSTOM_VARIANT;
    }

    private Control createPickDateArea(Composite parent) {
        final Table table = new Table(parent, 32788);
        table.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getDialogVariant());
        if (this.getDateCellHeight() != -1) {
            table.setData("org.eclipse.rap.rwt.customItemHeight", (Object)this.getDateCellHeight());
        }
        table.setLinesVisible(true);
        TableViewer viewer = new TableViewer(table);
        new TableCellRolloverSupport(viewer);
        table.setHeaderVisible(true);
        table.addListener(3, new Listener(){
            private static final long serialVersionUID = 1L;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 3: {
                        TableColumn columnAt = RwtUtility.getRwtColumnAt(table, new Point(event.x, event.y));
                        TableItem item = table.getItem(new Point(event.x, event.y));
                        if (item == null) break;
                        item.setData("org.eclipse.rap.rwt.customVariant", (Object)DateChooserDialog.this.getDialogVariant());
                        if (columnAt == null) break;
                        Date date = ((DateRow)item.getData()).getDate(table.indexOf(columnAt) - 1);
                        DateChooserDialog.this.m_returnDate = date;
                        DateChooserDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                DateChooserDialog.this.close();
                            }
                        });
                    }
                }
            }
        });
        TableColumn dummyColumn = new TableColumn(table, 131072);
        dummyColumn.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getDialogVariant());
        dummyColumn.setWidth(0);
        dummyColumn.setResizable(false);
        dummyColumn.setMoveable(false);
        String[] wd = new DateFormatSymbols(RwtUtility.getClientSessionLocale(parent.getDisplay())).getShortWeekdays();
        int i = 2;
        while (i < 8) {
            TableColumn col = new TableColumn(table, 0x1000000);
            col.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getDialogVariant());
            col.setWidth(this.getDateCellWidth());
            col.setResizable(false);
            col.setMoveable(false);
            col.setText(wd[i]);
            ++i;
        }
        TableColumn col = new TableColumn(table, 0x1000000);
        col.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getDialogVariant());
        col.setWidth(this.getDateCellWidth());
        col.setResizable(false);
        col.setMoveable(false);
        col.setText(wd[1]);
        this.m_viewer = viewer;
        this.m_viewer.setLabelProvider((IBaseLabelProvider)this.m_model);
        this.m_viewer.setContentProvider((IContentProvider)this.m_model);
        this.m_viewer.setInput((Object)this.m_model);
        return table;
    }

    protected int getDateCellWidth() {
        return 35;
    }

    protected int getDateCellHeight() {
        return -1;
    }

    private Control createControlArea(Composite parent) {
        Composite rootArea = RwtUtility.getUiEnvironment(parent.getDisplay()).getFormToolkit().createComposite(parent, 524288);
        rootArea.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getDialogVariant());
        this.createButton(rootArea, 1);
        this.createButton(rootArea, 2);
        this.m_monthLabel = new Label(rootArea, 0x1000000);
        this.m_monthLabel.setText(this.m_model.getMonthYearLabel());
        this.m_monthLabel.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getDialogVariant());
        this.createButton(rootArea, 4);
        this.createButton(rootArea, 8);
        rootArea.setLayout((Layout)new GridLayout(5, false));
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.m_monthLabel.setLayoutData((Object)data);
        return rootArea;
    }

    private Button createButton(Composite parent, int type) {
        String variant = this.getControlButtonVariant(type);
        Button b = new Button(parent, 8);
        b.setData("org.eclipse.rap.rwt.customVariant", (Object)variant);
        b.addMouseListener((MouseListener)new P_NavigationMouseListener(type));
        GridData data = new GridData(this.getControlButtonWidth(), this.getControlButtonHeight());
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = false;
        b.setLayoutData((Object)data);
        return b;
    }

    protected String getControlButtonVariant(int type) {
        switch (type) {
            case 1: {
                return LAST_YEAR_CUSTOM_VARIANT;
            }
            case 2: {
                return LAST_MONTH_CUSTOM_VARIANT;
            }
            case 4: {
                return NEXT_MONTH_CUSTOM_VARIANT;
            }
            case 8: {
                return NEXT_YEAR_CUSTOM_VARIANT;
            }
        }
        return null;
    }

    protected int getControlButtonWidth() {
        return 15;
    }

    protected int getControlButtonHeight() {
        return 15;
    }

    private class P_NavigationMouseListener
    extends MouseAdapter {
        private static final long serialVersionUID = 1L;
        private int m_type;

        P_NavigationMouseListener(int type) {
            this.m_type = type;
        }

        public void mouseDown(MouseEvent e) {
            switch (this.m_type) {
                case 1: {
                    DateChooserDialog.this.m_model.setNavigationDate(DateUtility.addYears((Date)DateChooserDialog.this.m_model.getNavigationDate(), (int)-1));
                    break;
                }
                case 2: {
                    DateChooserDialog.this.m_model.setNavigationDate(DateUtility.addMonths((Date)DateChooserDialog.this.m_model.getNavigationDate(), (int)-1));
                    break;
                }
                case 4: {
                    DateChooserDialog.this.m_model.setNavigationDate(DateUtility.addMonths((Date)DateChooserDialog.this.m_model.getNavigationDate(), (int)1));
                    break;
                }
                case 8: {
                    DateChooserDialog.this.m_model.setNavigationDate(DateUtility.addYears((Date)DateChooserDialog.this.m_model.getNavigationDate(), (int)1));
                }
            }
            DateChooserDialog.this.m_viewer.refresh();
            DateChooserDialog.this.m_monthLabel.setText(DateChooserDialog.this.m_model.getMonthYearLabel());
        }
    }
}

