/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.htmlfield;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.htmlfield.IHtmlField;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.eclipse.scout.rt.ui.rap.LogicalGridData;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.rap.ext.browser.BrowserExtension;
import org.eclipse.scout.rt.ui.rap.ext.browser.IHyperlinkCallback;
import org.eclipse.scout.rt.ui.rap.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.htmlfield.IRwtScoutHtmlField;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RwtScoutHtmlField
extends RwtScoutValueFieldComposite<IHtmlField>
implements IRwtScoutHtmlField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutHtmlField.class);
    private static final String VARIANT_HTMLFIELD = "htmlfield";
    private BrowserExtension m_browserExtension;

    @Override
    protected void initializeUi(Composite parent) {
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        container.setBackgroundMode(1);
        StatusLabelEx label = this.getUiEnvironment().getFormToolkit().createStatusLabel(container, (IFormField)this.getScoutObject());
        Composite browserContainer = this.getUiEnvironment().getFormToolkit().createComposite(container);
        browserContainer.setLayout((Layout)new FillLayout());
        LogicalGridData layoutData = LogicalGridDataBuilder.createField(((IFormField)this.getScoutObject()).getGridData());
        browserContainer.setLayoutData((Object)layoutData);
        browserContainer.setData("org.eclipse.rap.rwt.customVariant", (Object)VARIANT_HTMLFIELD);
        Browser browser = this.getUiEnvironment().getFormToolkit().createBrowser(browserContainer, 0);
        this.setUiField((Control)browser);
        this.attachBrowserExtension(browser);
        browser.addLocationListener((LocationListener)new LocationAdapter(){
            private static final long serialVersionUID = 1L;

            public void changing(LocationEvent event) {
                URL url = null;
                try {
                    url = new URL(event.location);
                }
                catch (MalformedURLException e) {
                    try {
                        url = new File(event.location).toURI().toURL();
                    }
                    catch (MalformedURLException e1) {
                        LOG.error("", (Throwable)e1);
                    }
                }
                if (url != null) {
                    event.doit = url.getProtocol().equals("file");
                    if (!event.doit) {
                        RwtScoutHtmlField.this.handleUiLinkAction(url);
                    }
                }
            }
        });
        this.setUiContainer(container);
        this.setUiLabel(label);
        this.getUiContainer().setLayout((Layout)new LogicalGridLayout(1, 0));
    }

    protected void attachBrowserExtension(Browser browser) {
        this.detachBrowserExtension();
        BrowserExtension browserExtension = new BrowserExtension(browser, this.getUiEnvironment(), new IHyperlinkCallback(){

            @Override
            public void execute(String url) {
                RwtScoutHtmlField.this.getUiField().setUrl(url);
            }
        });
        browserExtension.attach();
        browser.addDisposeListener(new DisposeListener(){
            private static final long serialVersionUID = 1L;

            public void widgetDisposed(DisposeEvent e) {
                RwtScoutHtmlField.this.detachBrowserExtension();
            }
        });
        this.adaptBrowserExtension(browserExtension);
        this.m_browserExtension = browserExtension;
    }

    protected void adaptBrowserExtension(BrowserExtension browserExtension) {
        browserExtension.setDefaultHyperlinkTarget("_top");
    }

    protected void detachBrowserExtension() {
        if (this.m_browserExtension != null) {
            this.m_browserExtension.detach();
            this.m_browserExtension = null;
        }
    }

    @Override
    protected boolean isAutoSetLayoutData() {
        return false;
    }

    public Browser getUiField() {
        return (Browser)super.getUiField();
    }

    protected void handleUiLinkAction(final URL url) {
        Runnable job = new Runnable(){

            @Override
            public void run() {
                ((IHtmlField)RwtScoutHtmlField.this.getScoutObject()).getUIFacade().fireHyperlinkActionFromUI(url);
            }
        };
        this.getUiEnvironment().invokeScoutLater(job, 0L);
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
    }

    @Override
    protected void setDisplayTextFromScout(String rawHtml) {
        this.m_browserExtension.clearResourceCache();
        this.m_browserExtension.clearLocalHyperlinkCache();
        if (rawHtml == null) {
            rawHtml = "";
        }
        for (RemoteFile f : ((IHtmlField)this.getScoutObject()).getAttachments()) {
            if (f == null || !f.exists()) continue;
            try {
                this.m_browserExtension.addResource(f.getPath(), f.getDecompressedInputStream());
            }
            catch (IOException e1) {
                LOG.warn("could not read remote file '" + f.getName() + "'", (Throwable)e1);
            }
        }
        String cleanHtml = this.getUiEnvironment().styleHtmlText(this, rawHtml);
        cleanHtml = this.m_browserExtension.adaptHyperlinks(cleanHtml);
        if (CollectionUtility.isEmpty((Collection)((IHtmlField)this.getScoutObject()).getAttachments())) {
            this.getUiField().setText(cleanHtml);
        } else {
            try {
                String indexFile = this.m_browserExtension.addResource("index.html", new ByteArrayInputStream(cleanHtml.getBytes("UTF-8")));
                if (indexFile != null) {
                    indexFile = String.valueOf(indexFile) + "?nocache=" + System.currentTimeMillis();
                }
                this.getUiField().setUrl(indexFile);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    protected void setScrollToAnchorFromScout(String anchorName) {
        if (!StringUtility.isNullOrEmpty((String)anchorName)) {
            this.getUiField().setUrl(String.valueOf(this.getUiField().getUrl()) + "#" + anchorName);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("scrollToEnd")) {
            this.getUiField().execute("window.scrollTo(0, document.body.scrollHeight)");
        } else if (name.equals("scrollToPosition")) {
            this.setScrollToAnchorFromScout((String)TypeCastUtility.castValue((Object)newValue, String.class));
        }
    }
}

