/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window.desktop.toolbar;

import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.ui.rap.basic.RwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.window.desktop.toolbar.IRwtScoutToolButton;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class RwtScoutToolButton
extends RwtScoutComposite<IAction>
implements IRwtScoutToolButton {
    private final boolean m_iconVisible;
    private final boolean m_textVisible;
    private String m_variantInActive;
    private String m_variantActive;

    public RwtScoutToolButton(boolean textVisible, boolean iconVisible, String variantInActive, String variantActive) {
        this.m_textVisible = textVisible;
        this.m_iconVisible = iconVisible;
        this.m_variantInActive = variantInActive;
        this.m_variantActive = variantActive;
    }

    @Override
    protected void initializeUi(Composite parent) {
        Button tabButton = this.getUiEnvironment().getFormToolkit().createButton(parent, "", 2);
        tabButton.setData("org.eclipse.rap.rwt.customVariant", (Object)this.m_variantInActive);
        this.setUiField((Control)tabButton);
        tabButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                RwtScoutToolButton.this.handleUiSelection();
            }
        });
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.updateIconFromScout();
        this.updateSelectionFromScout();
        this.updateTextFromScout();
        this.updateEnabledFormScout();
        this.updateVisibleFromScout();
        this.updateTooltipTextFromScout();
    }

    @Override
    public Button getUiField() {
        return (Button)super.getUiField();
    }

    protected void handleUiSelection() {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((IAction)RwtScoutToolButton.this.getScoutObject()).getUIFacade().fireActionFromUI();
            }
        };
        this.getUiEnvironment().invokeScoutLater(t, 0L);
    }

    protected void updateIconFromScout() {
    }

    protected void updateTextFromScout() {
        if (this.m_textVisible) {
            this.getUiField().setText(((IAction)this.getScoutObject()).getText());
        }
    }

    protected void updateSelectionFromScout() {
        Button uiField = this.getUiField();
        boolean isSelected = ((IAction)this.getScoutObject()).isSelected();
        this.setCustomVariants(uiField, isSelected);
        uiField.setSelection(isSelected);
    }

    private void setCustomVariants(Button uiField, boolean isSelected) {
        if (isSelected) {
            uiField.setData("org.eclipse.rap.rwt.customVariant", (Object)this.m_variantActive);
        } else {
            uiField.setData("org.eclipse.rap.rwt.customVariant", (Object)this.m_variantInActive);
        }
    }

    protected void updateEnabledFormScout() {
        this.getUiField().setEnabled(((IAction)this.getScoutObject()).isEnabled());
    }

    protected void updateVisibleFromScout() {
        this.getUiField().setVisible(((IAction)this.getScoutObject()).isVisible());
        RowData data = new RowData();
        Object o = this.getUiField().getLayoutData();
        if (o instanceof RowData) {
            data = (RowData)o;
        }
        data.exclude = !((IAction)this.getScoutObject()).isVisible();
        this.getUiField().setLayoutData((Object)data);
    }

    protected void updateTooltipTextFromScout() {
        this.getUiField().setToolTipText(((IAction)this.getScoutObject()).getTooltipText());
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        if ("iconId".equals(name)) {
            this.updateIconFromScout();
        } else if ("selected".equals(name)) {
            this.updateSelectionFromScout();
        } else if ("text".equals(name)) {
            this.updateTextFromScout();
        } else if ("enabled".equals(name)) {
            this.updateEnabledFormScout();
        } else if ("visible".equals(name)) {
            this.updateVisibleFromScout();
        } else if ("tooltipText".equals(name)) {
            this.updateTooltipTextFromScout();
        }
    }
}

