/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.svg.calendar.comp;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarComponent;
import org.eclipse.scout.rt.ui.svg.calendar.comp.AbstractComponentElementFactory;
import org.w3c.dom.Element;

public class LinearFillComponentElementFactory
extends AbstractComponentElementFactory {
    private static final float PADDING = 1.0f;

    @Override
    public Map<CalendarComponent, Element> create(Element container, Date day, CalendarComponent[] components) {
        HashMap<CalendarComponent, Element> ret = new HashMap<CalendarComponent, Element>(components.length);
        AbstractComponentElementFactory.SvgRect containerDimension = LinearFillComponentElementFactory.getElementDimensions(container);
        int i = 0;
        while (i < components.length) {
            Element e = this.createComponentRectangle(container, containerDimension, components[i], i, components.length, day);
            ret.put(components[i], e);
            ++i;
        }
        return ret;
    }

    private Element createComponentRectangle(Element container, AbstractComponentElementFactory.SvgRect containerDimension, CalendarComponent c, int index, int numComponents, Date day) {
        Element newEl = this.createNewComponentElement(container, c, day);
        AbstractComponentElementFactory.SvgRect elDimension = new AbstractComponentElementFactory.SvgRect();
        elDimension.height = containerDimension.height / (float)numComponents;
        elDimension.width = containerDimension.width;
        elDimension.y = containerDimension.y + elDimension.height * (float)index;
        elDimension.x = containerDimension.x;
        LinearFillComponentElementFactory.setElementDimensions(newEl, LinearFillComponentElementFactory.getCopyWithPadding(elDimension, 1.0f));
        return newEl;
    }
}

