/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.TreeSet;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;

public class LogicalGridLayoutInfo {
    private static final Dimension ZERO_DIMENSION = new Dimension(0, 0);
    private ISwingEnvironment m_env;
    LogicalGridData[] gridDatas;
    Component[] m_components;
    int cols;
    int rows;
    int[][] width;
    int[][] height;
    double[] weightX;
    double[] weightY;
    private int m_hgap;
    private int m_vgap;
    private Rectangle[][] m_cellBounds;
    private boolean m_useLogicalPrefSize;
    private Dimension m_sizePref;
    private Dimension m_sizeMin;
    private Dimension m_sizeMax;

    LogicalGridLayoutInfo(ISwingEnvironment env, Component[] components, LogicalGridData[] cons, int hgap, int vgap, boolean useLogicalPrefSize) {
        int maxRow;
        int n;
        int maxCol;
        this.m_env = env;
        this.m_components = components;
        this.m_hgap = hgap;
        this.m_vgap = vgap;
        this.m_useLogicalPrefSize = useLogicalPrefSize;
        this.gridDatas = new LogicalGridData[cons.length];
        int i = 0;
        while (i < cons.length) {
            this.gridDatas[i] = new LogicalGridData(cons[i]);
            ++i;
        }
        if (components.length == 0) {
            this.cols = 0;
            this.rows = 0;
            this.width = new int[0][0];
            this.height = new int[0][0];
            this.weightX = new double[0];
            this.weightY = new double[0];
            return;
        }
        TreeSet<Integer> usedCols = new TreeSet<Integer>();
        TreeSet<Integer> usedRows = new TreeSet<Integer>();
        LogicalGridData[] logicalGridDataArray = this.gridDatas;
        int n2 = this.gridDatas.length;
        int n3 = 0;
        while (n3 < n2) {
            LogicalGridData gd = logicalGridDataArray[n3];
            if (gd.gridx < 0) {
                gd.gridx = 0;
            }
            if (gd.gridy < 0) {
                gd.gridy = 0;
            }
            if (gd.gridw < 1) {
                gd.gridw = 1;
            }
            if (gd.gridh < 1) {
                gd.gridh = 1;
            }
            int x = gd.gridx;
            while (x < gd.gridx + gd.gridw) {
                usedCols.add(x);
                ++x;
            }
            int y = gd.gridy;
            while (y < gd.gridy + gd.gridh) {
                usedRows.add(y);
                ++y;
            }
            ++n3;
        }
        int x = maxCol = ((Integer)usedCols.last()).intValue();
        while (x >= 0) {
            if (!usedCols.contains(x)) {
                LogicalGridData[] logicalGridDataArray2 = this.gridDatas;
                n = this.gridDatas.length;
                int n4 = 0;
                while (n4 < n) {
                    LogicalGridData gd = logicalGridDataArray2[n4];
                    if (gd.gridx > x) {
                        --gd.gridx;
                    }
                    ++n4;
                }
            }
            --x;
        }
        int y = maxRow = ((Integer)usedRows.last()).intValue();
        while (y >= 0) {
            if (!usedRows.contains(y)) {
                LogicalGridData[] logicalGridDataArray3 = this.gridDatas;
                int n5 = this.gridDatas.length;
                n = 0;
                while (n < n5) {
                    LogicalGridData gd = logicalGridDataArray3[n];
                    if (gd.gridy > y) {
                        --gd.gridy;
                    }
                    ++n;
                }
            }
            --y;
        }
        this.cols = usedCols.size();
        this.rows = usedRows.size();
        this.width = new int[this.cols][3];
        this.height = new int[this.rows][3];
        this.weightX = new double[this.cols];
        this.weightY = new double[this.rows];
        this.initializeInfo();
    }

    private void initializeInfo() {
        int compCount = this.m_components.length;
        Dimension[] compSize = new Dimension[compCount];
        int i = 0;
        while (i < compCount) {
            Component comp = this.m_components[i];
            LogicalGridData cons = this.gridDatas[i];
            Dimension d = LogicalGridLayoutInfo.uiSizeInPixel(comp);
            if (cons.widthHint > 0) {
                d.width = cons.widthHint;
            }
            if (cons.heightHint > 0) {
                d.height = cons.heightHint;
            }
            compSize[i] = d;
            if (cons.gridx < 0) {
                cons.gridx = 0;
            }
            if (cons.gridy < 0) {
                cons.gridy = 0;
            }
            if (cons.gridw < 1) {
                cons.gridw = 1;
            }
            if (cons.gridh < 1) {
                cons.gridh = 1;
            }
            if (cons.gridx >= this.cols) {
                cons.gridx = this.cols - 1;
            }
            if (cons.gridy >= this.rows) {
                cons.gridy = this.rows - 1;
            }
            if (cons.gridx + cons.gridw - 1 >= this.cols) {
                cons.gridw = this.cols - cons.gridx;
            }
            if (cons.gridy + cons.gridh >= this.rows) {
                cons.gridh = this.rows - cons.gridy;
            }
            ++i;
        }
        this.initializeColumns(compSize);
        this.initializeRows(compSize);
    }

    private void initializeColumns(Dimension[] compSize) {
        LogicalGridData cons;
        int compCount = compSize.length;
        int[] prefWidths = new int[this.cols];
        boolean[] fixedWidths = new boolean[this.cols];
        int i = 0;
        while (i < compCount) {
            cons = this.gridDatas[i];
            if (cons.gridw == 1) {
                int prefw = cons.widthHint > 0 ? cons.widthHint : (cons.useUiWidth ? compSize[i].width : LogicalGridLayoutInfo.logicalWidthInPixel(this.m_env, cons));
                int j = cons.gridx;
                while (j < cons.gridx + cons.gridw && j < this.cols) {
                    prefWidths[j] = Math.max(prefWidths[j], prefw);
                    if (cons.weightx == 0.0) {
                        fixedWidths[j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < compCount) {
            cons = this.gridDatas[i];
            if (cons.gridw > 1) {
                int hSpan = cons.gridw;
                int spanWidth = 0;
                int j = cons.gridx;
                while (j < cons.gridx + cons.gridw && j < this.cols) {
                    if (!fixedWidths[j]) {
                        spanWidth += prefWidths[j];
                    }
                    ++j;
                }
                int distWidth = cons.widthHint > 0 ? cons.widthHint - spanWidth - (hSpan - 1) * this.m_hgap : (cons.useUiWidth ? compSize[i].width - spanWidth - (hSpan - 1) * this.m_hgap : LogicalGridLayoutInfo.logicalWidthInPixel(this.m_env, cons) - spanWidth - (hSpan - 1) * this.m_hgap);
                if (distWidth > 0) {
                    int equalWidth = (distWidth + spanWidth) / hSpan;
                    int remainder = (distWidth + spanWidth) % hSpan;
                    int last = -1;
                    int j2 = cons.gridx;
                    while (j2 < cons.gridx + cons.gridw && j2 < this.cols) {
                        if (fixedWidths[j2]) {
                            last = j2;
                            prefWidths[last] = prefWidths[j2];
                        } else {
                            last = j2;
                            prefWidths[last] = Math.max(equalWidth, prefWidths[j2]);
                        }
                        if (cons.weightx == 0.0) {
                            fixedWidths[j2] = true;
                        }
                        ++j2;
                    }
                    if (last > -1) {
                        int n = last;
                        prefWidths[n] = prefWidths[n] + remainder;
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.cols) {
            if (fixedWidths[i]) {
                this.width[i][0] = prefWidths[i];
                this.width[i][1] = prefWidths[i];
                this.width[i][2] = prefWidths[i];
            } else {
                this.width[i][0] = 0;
                this.width[i][1] = prefWidths[i];
                this.width[i][2] = 10240;
            }
            ++i;
        }
        i = 0;
        while (i < this.cols) {
            if (fixedWidths[i]) {
                this.weightX[i] = 0.0;
            } else {
                double weightSum = 0.0;
                int weightCount = 0;
                int k = 0;
                while (k < compCount) {
                    LogicalGridData cons2 = this.gridDatas[k];
                    if (cons2.weightx > 0.0 && cons2.gridx <= i && i <= cons2.gridx + cons2.gridw - 1) {
                        weightSum += cons2.weightx / (double)cons2.gridw;
                        ++weightCount;
                    }
                    ++k;
                }
                this.weightX[i] = weightCount > 0 ? weightSum / (double)weightCount : 0.0;
            }
            ++i;
        }
        double sumWeightX = 0.0;
        int i2 = 0;
        while (i2 < this.cols) {
            sumWeightX += this.weightX[i2];
            ++i2;
        }
        if (sumWeightX >= 1.0E-6) {
            double f = 1.0 / sumWeightX;
            int i3 = 0;
            while (i3 < this.cols) {
                this.weightX[i3] = this.weightX[i3] * f;
                ++i3;
            }
        }
    }

    private void initializeRows(Dimension[] compSize) {
        LogicalGridData cons;
        int compCount = compSize.length;
        int[] prefHeights = new int[this.rows];
        boolean[] fixedHeights = new boolean[this.rows];
        int i = 0;
        while (i < compCount) {
            cons = this.gridDatas[i];
            if (cons.gridh == 1) {
                int prefh = cons.heightHint > 0 ? cons.heightHint : (cons.useUiHeight ? compSize[i].height : LogicalGridLayoutInfo.logicalHeightInPixel(this.m_env, cons));
                int j = cons.gridy;
                while (j < cons.gridy + cons.gridh && j < this.rows) {
                    prefHeights[j] = Math.max(prefHeights[j], prefh);
                    if (cons.weighty == 0.0) {
                        fixedHeights[j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < compCount) {
            cons = this.gridDatas[i];
            if (cons.gridh > 1) {
                int vspan = cons.gridh;
                int spanHeight = 0;
                int j = cons.gridy;
                while (j < cons.gridy + cons.gridh && j < this.rows) {
                    spanHeight += prefHeights[j];
                    ++j;
                }
                int distHeight = cons.heightHint > 0 ? cons.heightHint - spanHeight - (vspan - 1) * this.m_vgap : (cons.useUiHeight ? compSize[i].height - spanHeight - (vspan - 1) * this.m_vgap : LogicalGridLayoutInfo.logicalHeightInPixel(this.m_env, cons) - spanHeight - (vspan - 1) * this.m_vgap);
                if (distHeight > 0) {
                    int equalHeight = (distHeight + spanHeight) / vspan;
                    int remainder = (distHeight + spanHeight) % vspan;
                    int last = -1;
                    int j2 = cons.gridy;
                    while (j2 < cons.gridy + cons.gridh && j2 < this.rows) {
                        last = j2;
                        prefHeights[last] = Math.max(equalHeight, prefHeights[j2]);
                        if (cons.weighty == 0.0) {
                            fixedHeights[j2] = true;
                        }
                        ++j2;
                    }
                    if (last > -1) {
                        int n = last;
                        prefHeights[n] = prefHeights[n] + remainder;
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.rows) {
            if (fixedHeights[i]) {
                this.height[i][0] = prefHeights[i];
                this.height[i][1] = prefHeights[i];
                this.height[i][2] = prefHeights[i];
            } else {
                this.height[i][0] = 0;
                this.height[i][1] = prefHeights[i];
                this.height[i][2] = 10240;
            }
            ++i;
        }
        i = 0;
        while (i < this.rows) {
            if (fixedHeights[i]) {
                this.weightY[i] = 0.0;
            } else {
                double weightSum = 0.0;
                int weightCount = 0;
                int k = 0;
                while (k < compCount) {
                    LogicalGridData cons2 = this.gridDatas[k];
                    if (cons2.weighty > 0.0 && cons2.gridy <= i && i <= cons2.gridy + cons2.gridh - 1) {
                        weightSum += cons2.weighty / (double)cons2.gridh;
                        ++weightCount;
                    }
                    ++k;
                }
                this.weightY[i] = weightCount > 0 ? weightSum / (double)weightCount : 0.0;
            }
            ++i;
        }
        double sumWeightY = 0.0;
        int i2 = 0;
        while (i2 < this.rows) {
            sumWeightY += this.weightY[i2];
            ++i2;
        }
        if (sumWeightY >= 1.0E-6) {
            double f = 1.0 / sumWeightY;
            int i3 = 0;
            while (i3 < this.rows) {
                this.weightY[i3] = this.weightY[i3] * f;
                ++i3;
            }
        }
    }

    Rectangle[][] layoutCellBounds(Dimension parentSize, Insets insets, boolean rootShowing) {
        int[] h;
        int[] w;
        boolean initialization;
        boolean bl = initialization = !rootShowing && ZERO_DIMENSION.equals(parentSize);
        if (initialization) {
            w = new int[this.width.length];
            h = new int[this.height.length];
        } else {
            w = this.layoutSizes(parentSize.width - insets.left - insets.right - Math.max(0, (this.cols - 1) * this.m_hgap), this.width, this.weightX);
            h = this.layoutSizes(parentSize.height - insets.top - insets.bottom - Math.max(0, (this.rows - 1) * this.m_vgap), this.height, this.weightY);
        }
        this.m_cellBounds = new Rectangle[this.rows][this.cols];
        int y = insets.top;
        int r = 0;
        while (r < this.m_cellBounds.length) {
            int x = insets.left;
            int c = 0;
            while (c < this.m_cellBounds[r].length) {
                this.m_cellBounds[r][c] = new Rectangle(x, y, w[c], h[r]);
                x += w[c];
                x += this.m_hgap;
                ++c;
            }
            y += h[r];
            y += this.m_vgap;
            ++r;
        }
        this.m_useLogicalPrefSize = true;
        if (initialization || this.m_useLogicalPrefSize) {
            int[] logicalColWidths = LogicalGridLayoutInfo.extractSizes(this.width, 1);
            int[] logicalRowHeights = LogicalGridLayoutInfo.extractSizes(this.height, 1);
            this.m_sizePref = LogicalGridLayoutInfo.calculateGridDimension(logicalColWidths, logicalRowHeights, insets, this.m_hgap, this.m_vgap);
        } else {
            int[] logicalRowheights = LogicalGridLayoutInfo.extractSizes(this.height, 1);
            this.m_sizePref = LogicalGridLayoutInfo.calculateGridDimension(w, logicalRowheights, insets, this.m_hgap, this.m_vgap);
        }
        this.m_sizeMin = LogicalGridLayoutInfo.calculateGridDimension(LogicalGridLayoutInfo.extractSizes(this.width, 1), LogicalGridLayoutInfo.extractSizes(this.height, 1), insets, this.m_hgap, this.m_vgap);
        this.m_sizeMax = LogicalGridLayoutInfo.calculateGridDimension(LogicalGridLayoutInfo.extractSizes(this.width, 2), LogicalGridLayoutInfo.extractSizes(this.height, 2), insets, this.m_hgap, this.m_vgap);
        return this.m_cellBounds;
    }

    private static int[] extractSizes(int[][] sizes, int sizeFlag) {
        int[] result = new int[sizes.length];
        int i = 0;
        while (i < sizes.length) {
            result[i] = sizes[i][sizeFlag];
            ++i;
        }
        return result;
    }

    private static Dimension calculateGridDimension(int[] colWidths, int[] rowHeights, Insets insets, int hgap, int vgap) {
        int n;
        int n2;
        int[] nArray;
        int width = 0;
        int height = 0;
        if (colWidths.length > 0) {
            nArray = colWidths;
            n2 = colWidths.length;
            n = 0;
            while (n < n2) {
                int colWidth = nArray[n];
                width += colWidth;
                ++n;
            }
            width += (colWidths.length - 1) * hgap;
            width += insets.left + insets.right;
        }
        if (rowHeights.length > 0) {
            nArray = rowHeights;
            n2 = rowHeights.length;
            n = 0;
            while (n < n2) {
                int rowHeight = nArray[n];
                height += rowHeight;
                ++n;
            }
            height += (rowHeights.length - 1) * vgap;
            height += insets.top + insets.bottom;
        }
        return new Dimension(width, height);
    }

    public Rectangle[][] getCellBounds() {
        return this.m_cellBounds;
    }

    public Dimension getGridDimension(int sizeFlag) {
        switch (sizeFlag) {
            case 1: {
                return this.m_sizePref;
            }
            case 0: {
                return this.m_sizeMin;
            }
            case 2: {
                return this.m_sizeMax;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported size flag: %s", sizeFlag));
    }

    private int[] layoutSizes(int targetSize, int[][] sizes, double[] weights) {
        int[] outSizes;
        block15: {
            int deltaInt;
            outSizes = new int[sizes.length];
            if (targetSize <= 0) {
                return new int[sizes.length];
            }
            int sumSize = 0;
            float[] tmpWeight = new float[weights.length];
            float sumWeight = 0.0f;
            int i = 0;
            while (i < sizes.length) {
                outSizes[i] = sizes[i][1];
                sumSize += outSizes[i];
                tmpWeight[i] = (float)weights[i];
                if (tmpWeight[i] < 1.0E-6f) {
                    tmpWeight[i] = sizes[i][2] > sizes[i][0] ? 1.0f : 0.0f;
                }
                sumWeight += tmpWeight[i];
                ++i;
            }
            if (sumWeight > 0.0f) {
                i = 0;
                while (i < tmpWeight.length) {
                    tmpWeight[i] = tmpWeight[i] / sumWeight;
                    ++i;
                }
            }
            if (Math.abs(deltaInt = targetSize - sumSize) <= 0) break block15;
            float[] accWeight = new float[tmpWeight.length];
            if (deltaInt > 0) {
                boolean hasTargets = true;
                while (deltaInt > 0 && hasTargets) {
                    hasTargets = false;
                    int i2 = 0;
                    while (i2 < outSizes.length && deltaInt > 0) {
                        if (tmpWeight[i2] > 0.0f && outSizes[i2] < sizes[i2][2]) {
                            hasTargets = true;
                            int n = i2;
                            accWeight[n] = accWeight[n] + tmpWeight[i2];
                            if (accWeight[i2] > 0.0f) {
                                int n2 = i2;
                                accWeight[n2] = accWeight[n2] - 1.0f;
                                int n3 = i2;
                                outSizes[n3] = outSizes[n3] + 1;
                                --deltaInt;
                            }
                        }
                        ++i2;
                    }
                }
            } else {
                boolean hasTargets = true;
                while (deltaInt < 0 && hasTargets) {
                    hasTargets = false;
                    int i3 = 0;
                    while (i3 < outSizes.length && deltaInt < 0) {
                        if (tmpWeight[i3] > 0.0f && outSizes[i3] > sizes[i3][0]) {
                            hasTargets = true;
                            int n = i3;
                            accWeight[n] = accWeight[n] + tmpWeight[i3];
                            if (accWeight[i3] > 0.0f) {
                                int n4 = i3;
                                accWeight[n4] = accWeight[n4] - 1.0f;
                                int n5 = i3;
                                outSizes[n5] = outSizes[n5] - 1;
                                ++deltaInt;
                            }
                        }
                        ++i3;
                    }
                }
            }
        }
        return outSizes;
    }

    private static int logicalWidthInPixel(ISwingEnvironment env, LogicalGridData cons) {
        int gridW = cons.gridw;
        return env.getFormColumnWidth() * gridW + env.getFormColumnGap() * Math.max(0, gridW - 1);
    }

    private static int logicalHeightInPixel(ISwingEnvironment env, LogicalGridData cons) {
        int gridH = cons.gridh;
        return env.getFormRowHeight() * gridH + env.getFormRowGap() * Math.max(0, gridH - 1);
    }

    private static Dimension uiSizeInPixel(Component comp) {
        return new Dimension(comp.getPreferredSize());
    }
}

