/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicHTML;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.BundleContextUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.dnd.FileListTransferObject;
import org.eclipse.scout.commons.dnd.ImageTransferObject;
import org.eclipse.scout.commons.dnd.JavaTransferObject;
import org.eclipse.scout.commons.dnd.TextTransferObject;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.MouseButton;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.basic.BoundsSpec;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.ui.swing.basic.ColorUtility;
import org.eclipse.scout.rt.ui.swing.dnd.AwtImageTransferable;
import org.eclipse.scout.rt.ui.swing.dnd.FileListTransferable;
import org.eclipse.scout.rt.ui.swing.dnd.JVMLocalObjectTransferable;
import org.eclipse.scout.rt.ui.swing.dnd.TextTransferable;
import org.eclipse.scout.rt.ui.swing.simulator.SimulatorAction;
import org.eclipse.scout.rt.ui.swing.simulator.SwingScoutSimulator;

public final class SwingUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingUtility.class);
    public static final boolean IS_JAVA_7_OR_GREATER = CompareUtility.compareTo((Comparable)((Object)System.getProperty("java.version")), (Comparable)((Object)"1.7")) >= 0;
    public static final boolean IS_JAVA_7_OR_LESS = CompareUtility.compareTo((Comparable)((Object)System.getProperty("java.version")), (Comparable)((Object)"1.7")) <= 0;
    public static final boolean DO_RESET_COMPONENT_BOUNDS = BundleContextUtility.parseBooleanProperty((String)"scout.ui.layout.resetBoundsOnInvalidate", (boolean)true);
    public static final boolean VERIFY_INPUT_ON_WINDOW_CLOSED = BundleContextUtility.parseBooleanProperty((String)"scout.ui.verifyInputOnWindowClosed", (boolean)false);
    private static Integer topMarginForField = null;
    private static ScoutTexts globalTextProvider;

    private SwingUtility() {
    }

    public static boolean isSynth() {
        return "SynthLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getSimpleName());
    }

    public static boolean isPasteAction() {
        KeyEvent k;
        AWTEvent e = EventQueue.getCurrentEvent();
        return e != null && e.getID() == 401 && (k = (KeyEvent)e).getKeyCode() == 86 && k.getModifiers() == 2;
    }

    public static boolean isSunDropAction() {
        AWTEvent e = EventQueue.getCurrentEvent();
        return e != null && e.getID() == 502 && e.getClass().getName().equals("sun.awt.dnd.SunDropTargetEvent");
    }

    public static Window getOwnerForChildWindow() {
        Window cand;
        Window w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (w != null) {
            return w;
        }
        w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (w != null) {
            return w;
        }
        TreeMap<Integer, Window> prioMap = new TreeMap<Integer, Window>();
        Window[] windowArray = Window.getWindows();
        int n = windowArray.length;
        int n2 = 0;
        while (n2 < n) {
            cand = windowArray[n2];
            if (cand != null && cand.isVisible() && cand.isShowing()) {
                int prio = 0;
                Window[] children = cand.getOwnedWindows();
                if (children == null || children.length == 0) {
                    prio += 10;
                }
                if (cand instanceof Dialog) {
                    Dialog dlg = (Dialog)cand;
                    prio = dlg.isModal() ? (prio += 200) : (prio += 100);
                    prioMap.put(prio, cand);
                } else if (cand instanceof Frame && !prioMap.containsKey(prio)) {
                    prioMap.put(prio, cand);
                }
            }
            ++n2;
        }
        if (prioMap.size() > 0) {
            return (Window)prioMap.get(prioMap.lastKey());
        }
        if (prioMap.size() == 0) {
            windowArray = Window.getWindows();
            n = windowArray.length;
            n2 = 0;
            while (n2 < n) {
                cand = windowArray[n2];
                if (cand != null && cand.isVisible()) {
                    return cand;
                }
                ++n2;
            }
        }
        return null;
    }

    public static void showMessageDialogSynthCapable(Component parentComponent, Object message, String title, int messageType) {
        JOptionPane pane = new JOptionPane(message, messageType);
        JDialog dlg = pane.createDialog(parentComponent, title);
        dlg.getRootPane().setName("Synth.Dialog");
        dlg.pack();
        dlg.setVisible(true);
    }

    public static MouseButton swingToScoutMouseButton(int swingButton) {
        switch (swingButton) {
            case 1: {
                return MouseButton.Left;
            }
            case 3: {
                return MouseButton.Right;
            }
        }
        return MouseButton.Unknown;
    }

    public static String getKeyStrokeText(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 16: 
            case 17: 
            case 18: 
            case 65406: {
                break;
            }
            default: {
                StringBuffer buf = new StringBuffer();
                if ((e.getModifiers() & 1) != 0) {
                    buf.append("shift-");
                }
                if ((e.getModifiers() & 2) != 0) {
                    buf.append("ctrl-");
                }
                if ((e.getModifiers() & 0x28) != 0) {
                    buf.append("alt-");
                }
                buf.append(SwingUtility.getKeyText(e).toLowerCase());
                return buf.toString();
            }
        }
        return null;
    }

    public static String getKeyText(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            return "delete";
        }
        String s = "" + e.getKeyChar();
        if (e.getKeyCode() > 0) {
            int flags = 25;
            Field[] fieldArray = KeyEvent.class.getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if ((f.getModifiers() & flags) == flags) {
                    try {
                        if (f.getName().startsWith("VK_") && ((Integer)f.get(null)).intValue() == e.getKeyCode()) {
                            s = f.getName().substring(3).toLowerCase();
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        if (s.length() != 1 && e.getKeyChar() >= ' ' && e.getKeyChar() < '\u0080') {
            s = "" + e.getKeyChar();
        }
        return s.toLowerCase();
    }

    public static void setNlsTexts(ScoutTexts textProvider) {
        globalTextProvider = textProvider;
    }

    public static String getNlsText(String key, String ... messageArguments) {
        if (globalTextProvider != null) {
            return globalTextProvider.getText(key, messageArguments);
        }
        return ScoutTexts.get((String)key, (String[])messageArguments);
    }

    public static String inspectUIResourceType(Object scoutUIResource) {
        if (scoutUIResource == null) {
            return "String";
        }
        if (scoutUIResource instanceof Boolean) {
            return "Boolean";
        }
        if (scoutUIResource instanceof Integer) {
            return "Integer";
        }
        if (scoutUIResource instanceof String) {
            return "String";
        }
        if (scoutUIResource instanceof Color) {
            return "Color";
        }
        if (scoutUIResource instanceof Dimension) {
            return "Dimension";
        }
        if (scoutUIResource instanceof Font) {
            return "Font";
        }
        if (scoutUIResource instanceof Insets) {
            return "Insets";
        }
        if (scoutUIResource instanceof Icon) {
            return "Icon";
        }
        return "String";
    }

    public static Rectangle createRectangle(BoundsSpec r) {
        if (r == null) {
            return null;
        }
        return new Rectangle(r.x, r.y, r.width, r.height);
    }

    @Deprecated
    public static Color createColor(String c) {
        return ColorUtility.createColor(c);
    }

    public static Font createFont(FontSpec scoutFont) {
        return SwingUtility.createFont(scoutFont, null);
    }

    public static Font createFont(FontSpec scoutFont, Font templateFont) {
        int size;
        if (scoutFont == null) {
            return null;
        }
        String name = scoutFont.getName();
        if (name == null) {
            name = templateFont != null ? templateFont.getName() : "Dialog";
        }
        int style = 0;
        if (scoutFont.isBold()) {
            style |= 1;
        }
        if (scoutFont.isItalic()) {
            style |= 2;
        }
        if ((size = scoutFont.getSize()) <= 0) {
            size = templateFont != null ? templateFont.getSize() : 11;
        }
        return new Font(name, style, size);
    }

    public static KeyStroke createKeystroke(IKeyStroke key) {
        return SwingUtility.createKeystroke(key.getKeyStroke());
    }

    public static KeyStroke createKeystroke(String pattern) {
        String[] a = pattern.split("[- ]");
        String shift = "";
        String ctrl = "";
        String alt = "";
        String kind = "";
        String key = "";
        boolean hasMeta = false;
        String[] stringArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equalsIgnoreCase("shift")) {
                shift = "shift ";
                hasMeta = true;
            } else if (s.equalsIgnoreCase("control")) {
                ctrl = "control ";
                hasMeta = true;
            } else if (s.equalsIgnoreCase("ctrl")) {
                ctrl = "control ";
                hasMeta = true;
            } else if (s.equalsIgnoreCase("alternate")) {
                alt = "alt ";
                hasMeta = true;
            } else if (s.equalsIgnoreCase("alt")) {
                alt = "alt ";
                hasMeta = true;
            } else if ("TAB".equalsIgnoreCase(s)) {
                kind = "pressed ";
                key = s;
            } else if (!hasMeta && s.length() == 1) {
                kind = "typed ";
                key = s;
            } else {
                kind = "pressed ";
                key = s.toUpperCase();
            }
            ++n2;
        }
        String javaKey = String.valueOf(shift) + ctrl + alt + kind + key;
        KeyStroke stroke = KeyStroke.getKeyStroke(javaKey);
        if (stroke == null) {
            LOG.warn("could not create swing keystroke for '" + javaKey + "'. No java key found for scout pattern '" + pattern + "'");
        }
        return stroke;
    }

    public static Transferable createSwingTransferable(TransferObject scoutT) {
        if (scoutT == null) {
            return null;
        }
        if (scoutT instanceof FileListTransferObject) {
            return new FileListTransferable(((FileListTransferObject)scoutT).getFiles());
        }
        if (scoutT instanceof TextTransferObject) {
            TextTransferObject textTransferObject = (TextTransferObject)scoutT;
            return new TextTransferable(textTransferObject.getPlainText(), textTransferObject.getHtmlText());
        }
        if (scoutT instanceof ImageTransferObject) {
            ImageTransferObject imgTransferObject = (ImageTransferObject)scoutT;
            Image img = null;
            Object image = imgTransferObject.getImage();
            if (image == null) {
                return null;
            }
            if (image instanceof Image) {
                img = (Image)image;
            } else if (image instanceof byte[]) {
                img = Toolkit.getDefaultToolkit().createImage((byte[])image);
            }
            if (img != null) {
                return new AwtImageTransferable(img);
            }
        } else if (scoutT instanceof JavaTransferObject) {
            return new JVMLocalObjectTransferable(((JavaTransferObject)scoutT).getLocalObject());
        }
        return null;
    }

    public static boolean isSupportedTransfer(int scoutTransferTypes, DataFlavor[] flavors) {
        if (scoutTransferTypes == 0 || flavors == null) {
            return false;
        }
        int binaryScoutTypes = 0;
        if ((scoutTransferTypes & 1) != 0) {
            binaryScoutTypes |= 1;
        }
        if ((scoutTransferTypes & 8) != 0) {
            binaryScoutTypes |= 2;
        }
        if ((scoutTransferTypes & 2) != 0) {
            binaryScoutTypes |= 4;
        }
        if ((scoutTransferTypes & 4) != 0) {
            binaryScoutTypes |= 8;
        }
        int binarySwingTypes = 0;
        DataFlavor[] dataFlavorArray = flavors;
        int n = flavors.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlavor flavor = dataFlavorArray[n2];
            if (flavor.isFlavorJavaFileListType()) {
                binarySwingTypes |= 1;
            } else if (flavor.isFlavorTextType()) {
                binarySwingTypes |= 8;
            } else if (flavor.isMimeTypeEqual(DataFlavor.imageFlavor)) {
                binarySwingTypes |= 2;
            } else if (flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref")) {
                binarySwingTypes |= 4;
            }
            ++n2;
        }
        return (binaryScoutTypes & binarySwingTypes) != 0;
    }

    public static TransferObject createScoutTransferable(Transferable swingT) {
        if (swingT == null) {
            return null;
        }
        DataFlavor[] flavors = swingT.getTransferDataFlavors();
        Exception ex = null;
        FileListTransferObject fileTransferObject = null;
        TextTransferObject textTransferObject = null;
        ImageTransferObject imageTransferObject = null;
        TextTransferObject serializedTransferObject = null;
        JavaTransferObject jvmTransferObject = null;
        int i = 0;
        while (i < flavors.length) {
            block32: {
                if (flavors[i].isFlavorJavaFileListType()) {
                    try {
                        ArrayList fileList = new ArrayList();
                        fileList.addAll((List)swingT.getTransferData(flavors[i]));
                        if (fileTransferObject == null) {
                            fileTransferObject = new FileListTransferObject(fileList);
                        }
                        break block32;
                    }
                    catch (Exception e) {
                        if (ex == null) {
                            ex = e;
                        }
                        break block32;
                    }
                }
                if (flavors[i].isMimeTypeEqual("application/x-java-serialized-object")) {
                    try {
                        if (serializedTransferObject == null) {
                            serializedTransferObject = new TextTransferObject((String)swingT.getTransferData(flavors[i]));
                        }
                        break block32;
                    }
                    catch (Exception e) {
                        if (ex == null) {
                            ex = e;
                        }
                        break block32;
                    }
                }
                if (flavors[i].isMimeTypeEqual(DataFlavor.imageFlavor)) {
                    try {
                        if (imageTransferObject == null) {
                            imageTransferObject = new ImageTransferObject(swingT.getTransferData(flavors[i]));
                        }
                        break block32;
                    }
                    catch (Exception e) {
                        if (ex == null) {
                            ex = e;
                        }
                        break block32;
                    }
                }
                if (flavors[i].isFlavorTextType()) {
                    try {
                        if (textTransferObject == null) {
                            textTransferObject = new TextTransferObject((String)swingT.getTransferData(flavors[i]));
                        }
                        break block32;
                    }
                    catch (Exception e) {
                        if (ex == null) {
                            ex = e;
                        }
                        break block32;
                    }
                }
                if (flavors[i].isMimeTypeEqual("application/x-java-jvm-local-objectref")) {
                    try {
                        if (jvmTransferObject == null) {
                            jvmTransferObject = new JavaTransferObject(swingT.getTransferData(flavors[i]));
                        }
                    }
                    catch (Exception e) {
                        if (ex != null) break block32;
                        ex = e;
                    }
                }
            }
            ++i;
        }
        if (fileTransferObject != null) {
            return fileTransferObject;
        }
        if (imageTransferObject != null) {
            return imageTransferObject;
        }
        if (serializedTransferObject != null) {
            return serializedTransferObject;
        }
        if (textTransferObject != null) {
            return textTransferObject;
        }
        if (jvmTransferObject != null) {
            return jvmTransferObject;
        }
        if (ex != null) {
            LOG.warn("swing transferable=" + swingT, (Throwable)ex);
        }
        return null;
    }

    public static int createHorizontalAlignment(int scoutAlign) {
        switch (scoutAlign) {
            case -1: {
                return 2;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 4;
            }
        }
        return SwingUtility.createDefaultHorizontalAlignment();
    }

    private static int createDefaultHorizontalAlignment() {
        int swingAlign = 4;
        String defaultAlignment = UIManager.getDefaults().getString("Label.defaultHorizontalAlignment");
        if (defaultAlignment != null) {
            if ("LEFT".equalsIgnoreCase(defaultAlignment)) {
                swingAlign = 2;
            } else if ("RIGHT".equalsIgnoreCase(defaultAlignment)) {
                swingAlign = 4;
            } else if ("CENTER".equalsIgnoreCase(defaultAlignment)) {
                swingAlign = 0;
            }
        }
        return swingAlign;
    }

    public static float createAlignmentX(int scoutAlign) {
        switch (scoutAlign) {
            case -1: {
                return 0.0f;
            }
            case 0: {
                return 0.5f;
            }
            case 1: {
                return 1.0f;
            }
        }
        return 0.0f;
    }

    public static int createVerticalAlignment(int scoutAlign) {
        switch (scoutAlign) {
            case -1: {
                return 1;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 3;
            }
        }
        return 1;
    }

    public static float createAlignmentY(int scoutAlign) {
        switch (scoutAlign) {
            case -1: {
                return 0.0f;
            }
            case 0: {
                return 0.5f;
            }
            case 1: {
                return 1.0f;
            }
        }
        return 0.0f;
    }

    public static JComponent createGlue(int w, int h, boolean fillHorizontal, boolean fillVertical) {
        JPanel filler = new JPanel(null);
        filler.setOpaque(false);
        filler.setMinimumSize(new Dimension(fillHorizontal ? 0 : w, fillVertical ? 0 : h));
        filler.setPreferredSize(new Dimension(w, h));
        filler.setMaximumSize(new Dimension(fillHorizontal ? 10240 : w, fillVertical ? 10240 : h));
        return filler;
    }

    public static boolean runInputVerifier() {
        Component comp = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return SwingUtility.runInputVerifier(comp);
    }

    public static boolean runInputVerifier(Component comp) {
        if (comp == null || !(comp instanceof JComponent)) {
            return true;
        }
        JComponent jFocusOwner = (JComponent)comp;
        InputVerifier iv = jFocusOwner.getInputVerifier();
        if (iv == null) {
            return true;
        }
        return iv.shouldYieldFocus(jFocusOwner);
    }

    public static void installDefaultFocusHandling(Container c) {
        JComponent jc;
        InputMap inputMapWhenFocused;
        HashSet<KeyStroke> set = new HashSet<KeyStroke>(1);
        set.add(KeyStroke.getKeyStroke(9, 0));
        c.setFocusTraversalKeys(0, set);
        set = new HashSet(1);
        set.add(KeyStroke.getKeyStroke(9, 1));
        c.setFocusTraversalKeys(1, set);
        if (c instanceof JComponent && (inputMapWhenFocused = (jc = (JComponent)c).getInputMap(0)).size() == 0) {
            inputMapWhenFocused.put(KeyStroke.getKeyStroke(65480, 400), "swingDummyFocusKey");
        }
    }

    public static void installFocusCycleRoot(Container c, FocusTraversalPolicy cyclePolicy) {
        Container contentPane;
        c.setFocusCycleRoot(true);
        c.setFocusTraversalPolicy(cyclePolicy);
        if (c instanceof RootPaneContainer && (contentPane = ((RootPaneContainer)((Object)c)).getContentPane()) != null) {
            contentPane.setFocusTraversalPolicy(null);
            contentPane.setFocusCycleRoot(false);
        }
    }

    public static void installAlternateCopyPaste(JComponent comp) {
        comp.getInputMap(0).put(KeyStroke.getKeyStroke("shift INSERT"), "paste-from-clipboard");
        comp.getInputMap(0).put(KeyStroke.getKeyStroke("shift DELETE"), "cut-to-clipboard");
        comp.getInputMap(0).put(KeyStroke.getKeyStroke("ctrl INSERT"), "copy-to-clipboard");
    }

    public static void installDevelopmentShortcuts(JComponent pane) {
        if (Platform.inDevelopmentMode()) {
            SwingScoutSimulator.getInstance().attach();
            pane.getInputMap(2).put(KeyStroke.getKeyStroke("control R"), "record");
            pane.getActionMap().put("record", new SimulatorAction('R'));
            pane.getInputMap(2).put(KeyStroke.getKeyStroke("control S"), "stop");
            pane.getActionMap().put("stop", new SimulatorAction('S'));
            pane.getInputMap(2).put(KeyStroke.getKeyStroke("control P"), "play");
            pane.getActionMap().put("play", new SimulatorAction('P'));
            pane.getInputMap(2).put(KeyStroke.getKeyStroke("control M"), "playMulti");
            pane.getActionMap().put("playMulti", new SimulatorAction('M'));
        }
    }

    public static boolean isMultilineLabelText(String s) {
        return s != null && (s.indexOf(10) >= 0 || s.indexOf(13) >= 0);
    }

    public static String createHtmlLabelText(String s, boolean allowTextWrap) {
        if (s != null && !BasicHTML.isHTMLString(s)) {
            String body = StringUtility.htmlEncode((String)s, (!allowTextWrap ? 1 : 0) != 0);
            s = "<html>" + body + "</html>";
        }
        return s;
    }

    public static Rectangle getFullScreenBoundsFor(Rectangle r, boolean includeReservedInsets) {
        GraphicsDevice screenDevice = SwingUtility.getCurrentScreen(r);
        GraphicsConfiguration config = screenDevice.getDefaultConfiguration();
        Rectangle bounds = config.getBounds();
        if (!includeReservedInsets) {
            Insets screenInsets = SwingUtility.getScreenInsets(screenDevice);
            bounds.x += screenInsets.left;
            bounds.y += screenInsets.top;
            bounds.width = bounds.width - screenInsets.left - screenInsets.right;
            bounds.height = bounds.height - screenInsets.top - screenInsets.bottom;
        }
        return bounds;
    }

    public static GraphicsDevice getCurrentScreen(Rectangle r) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        TreeMap<Integer, GraphicsDevice> prioMap = new TreeMap<Integer, GraphicsDevice>();
        prioMap.put(-1, ge.getDefaultScreenDevice());
        GraphicsDevice[] graphicsDeviceArray = ge.getScreenDevices();
        int n = graphicsDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicsDevice dev = graphicsDeviceArray[n2];
            Rectangle bounds = dev.getDefaultConfiguration().getBounds();
            Rectangle intersection = bounds.intersection(r);
            if (intersection.width < 0 && intersection.height < 0) {
                intersection.width *= -1;
            }
            prioMap.put(intersection.width * intersection.height, dev);
            ++n2;
        }
        return (GraphicsDevice)prioMap.get(prioMap.lastKey());
    }

    public static Insets getScreenInsets(GraphicsDevice screenDevice) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (screenDevice == ge.getDefaultScreenDevice()) {
            return Toolkit.getDefaultToolkit().getScreenInsets(screenDevice.getDefaultConfiguration());
        }
        return new Insets(0, 0, 0, 0);
    }

    public static Rectangle getOppositeFullScreenBoundsFor(Rectangle r, boolean includeReservedInsets) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        TreeMap<Integer, Rectangle> prioMap = new TreeMap<Integer, Rectangle>();
        GraphicsDevice[] graphicsDeviceArray = ge.getScreenDevices();
        int n = graphicsDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicsDevice dev = graphicsDeviceArray[n2];
            Rectangle bounds = !includeReservedInsets && dev == ge.getDefaultScreenDevice() ? ge.getMaximumWindowBounds() : dev.getDefaultConfiguration().getBounds();
            Rectangle intersection = bounds.intersection(r);
            prioMap.put(intersection.width * intersection.height, bounds);
            ++n2;
        }
        if (prioMap.size() <= 1) {
            return null;
        }
        return (Rectangle)prioMap.get(prioMap.firstKey());
    }

    public static Rectangle intersectRectangleWithScreen(Rectangle r, boolean includeReservedInsets, boolean singleMonitor) {
        if (singleMonitor) {
            return r.intersection(SwingUtility.getFullScreenBoundsFor(r, includeReservedInsets));
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        ArrayList<Rectangle> intersections = new ArrayList<Rectangle>();
        GraphicsDevice[] graphicsDeviceArray = ge.getScreenDevices();
        int n = graphicsDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicsDevice dev = graphicsDeviceArray[n2];
            Rectangle bounds = !includeReservedInsets && dev == ge.getDefaultScreenDevice() ? ge.getMaximumWindowBounds() : dev.getDefaultConfiguration().getBounds();
            Rectangle intersection = bounds.intersection(r);
            if (!intersection.isEmpty()) {
                intersections.add(intersection);
            }
            ++n2;
        }
        if (intersections.size() > 0) {
            Rectangle unionAll = null;
            for (Rectangle i : intersections) {
                unionAll = unionAll == null ? i : unionAll.union(i);
            }
            return unionAll;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public static boolean isRectangleInsideScreen(Rectangle r, boolean includeReservedInsets, boolean singleMonitor) {
        Rectangle t = SwingUtility.intersectRectangleWithScreen(r, includeReservedInsets, singleMonitor);
        return t.equals(r);
    }

    public static Rectangle validateRectangleOnScreen(Rectangle r, boolean includeReservedInsets, boolean singleMonitor) {
        return SwingUtility.validateRectangleOnScreen(r, new Rectangle(-100000, -100000, 200000, 200000), includeReservedInsets, singleMonitor);
    }

    public static Rectangle validateRectangleOnScreen(Rectangle r, Rectangle referenceRect, boolean includeReservedInsets, boolean singleMonitor) {
        Rectangle t = SwingUtility.intersectRectangleWithScreen(r, includeReservedInsets, singleMonitor);
        if (!t.equals(r)) {
            Rectangle a = r.getBounds();
            Rectangle screen = SwingUtility.intersectRectangleWithScreen(referenceRect, includeReservedInsets, singleMonitor);
            if (screen.width < a.width) {
                a.width = screen.width;
            }
            if (screen.height < a.height) {
                a.height = screen.height;
            }
            if (a.x < screen.x) {
                a.x = screen.x;
            }
            if (a.y < screen.y) {
                a.y = screen.y;
            }
            if (a.x + a.width > screen.x + screen.width) {
                a.x = screen.x + screen.width - a.width;
            }
            if (a.y + a.height > screen.y + screen.height) {
                a.y = screen.y + screen.height - a.height;
            }
            return a;
        }
        return r;
    }

    public static void adjustBoundsToScreen(Window window) {
        Rectangle origBounds = window.getBounds();
        Rectangle newBounds = SwingUtility.validateRectangleOnScreen(origBounds, false, true);
        if (!newBounds.equals(origBounds)) {
            window.setLocation(newBounds.getLocation());
            window.setSize(newBounds.getSize());
        }
    }

    public static boolean isAtScrollPaneRightBorder(Component c, int x) {
        int localX;
        JScrollPane sp = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, c);
        return sp != null && (localX = SwingUtilities.convertPoint((Component)c, (int)x, (int)0, (Component)sp).x) + 1 == sp.getWidth();
    }

    public static boolean isAtScrollPaneBottomBorder(Component c, int y) {
        int localY;
        JScrollPane sp = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, c);
        return sp != null && (localY = SwingUtilities.convertPoint((Component)c, (int)0, (int)y, (Component)sp).y) + 1 == sp.getHeight();
    }

    public static <T extends Component> T findChildComponent(Component parent, Class<T> type) {
        ArrayList list = new ArrayList(1);
        SwingUtility.findChildComponentsRec(parent, type, list, 1);
        if (list.size() > 0) {
            return (T)((Component)list.get(0));
        }
        return null;
    }

    public static <T extends Component> List<T> findChildComponents(Component parent, Class<T> type) {
        ArrayList list = new ArrayList();
        SwingUtility.findChildComponentsRec(parent, type, list, Integer.MAX_VALUE);
        return list;
    }

    private static <T extends Component> void findChildComponentsRec(Component parent, Class<T> type, List<T> list, int maxCount) {
        if (type.isAssignableFrom(parent.getClass())) {
            list.add(parent);
            if (list.size() >= maxCount) {
                return;
            }
        }
        if (parent instanceof Container) {
            Component[] componentArray = ((Container)parent).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                SwingUtility.findChildComponentsRec(c, type, list, maxCount);
                if (list.size() >= maxCount) {
                    return;
                }
                ++n2;
            }
        }
    }

    public static Dimension getVisibleSizeInViewport(Component c) {
        if (c.getParent() instanceof JViewport) {
            JViewport vp = (JViewport)c.getParent();
            Dimension d = vp.getExtentSize();
            if (vp.getParent() instanceof JScrollPane) {
                JScrollPane sp = (JScrollPane)vp.getParent();
                if (sp.getVerticalScrollBar() != null && sp.getVerticalScrollBar().isVisible()) {
                    d.width += sp.getVerticalScrollBar().getWidth();
                }
                if (sp.getHorizontalScrollBar() != null && sp.getHorizontalScrollBar().isVisible()) {
                    d.height += sp.getHorizontalScrollBar().getHeight();
                }
            }
            return d;
        }
        return null;
    }

    public static Point getAdjustedToolTipLocation(MouseEvent e, JComponent c, Component frame) {
        Rectangle intersection;
        JToolTip tip = new JToolTip();
        tip.setTipText(c.getToolTipText(e));
        Dimension tipSize = tip.getPreferredSize();
        Rectangle frameR = frame.getBounds();
        if (frame instanceof Container) {
            Container container = (Container)frame;
            Insets insets = container.getInsets();
            frameR.x += insets.left;
            frameR.y += insets.top;
            frameR.width -= insets.left + insets.right;
            frameR.height -= insets.top + insets.bottom;
        }
        frameR.x += 5;
        frameR.y += 5;
        frameR.width -= 10;
        frameR.height -= 10;
        Rectangle r = new Rectangle(e.getXOnScreen(), c.getLocationOnScreen().y + c.getSize().height + 1, tipSize.width, tipSize.height);
        if (r.equals(intersection = frameR.intersection(r))) {
            return null;
        }
        int correction = 0;
        if (r.height == intersection.height) {
            r = new Rectangle(r.x, c.getLocationOnScreen().y + c.getSize().height + 5, tipSize.width, tipSize.height);
            correction = -5;
        } else {
            r = new Rectangle(c.getLocationOnScreen().x + 10, c.getLocationOnScreen().y - tipSize.height - 1, tipSize.width, tipSize.height);
        }
        intersection = frameR.intersection(r);
        intersection.x -= r.width - intersection.width;
        intersection.y -= r.height - intersection.height;
        return new Point(-c.getLocationOnScreen().x + intersection.x + correction, -c.getLocationOnScreen().y + intersection.y);
    }

    public static boolean hasScoutLookAndFeelFrameAndDialog() {
        String useScoutLafFrameAndDialog = System.getProperty("scout.laf.useLafFrameAndDialog");
        boolean useLafFrameAndDialog = true;
        if (StringUtility.hasText((String)useScoutLafFrameAndDialog)) {
            useLafFrameAndDialog = Boolean.parseBoolean(useScoutLafFrameAndDialog);
        }
        return useLafFrameAndDialog;
    }

    public static int getTopMarginForField() {
        if (topMarginForField == null) {
            String topMarginForFieldProperty = System.getProperty("scout.laf.topMarginForField");
            topMarginForField = topMarginForFieldProperty != null ? Integer.valueOf(Integer.parseInt(topMarginForFieldProperty)) : Integer.valueOf(0);
        }
        return topMarginForField;
    }

    public static void setDefaultImageIcons(Window window) {
        Object icons;
        Icon icon = UIManager.getIcon("Window.icon");
        if (icon instanceof ImageIcon) {
            window.setIconImage(((ImageIcon)icon).getImage());
        }
        if ((icons = UIManager.getDefaults().get("Window.icons")) instanceof List) {
            ArrayList<Image> iconList = new ArrayList<Image>();
            for (Object ico : (List)icons) {
                if (!(ico instanceof Image)) continue;
                iconList.add((Image)ico);
            }
            window.setIconImages(iconList);
        }
    }

    public static void setZeroBounds(Component ... components) {
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            c.setBounds(0, 0, 0, 0);
            ++n2;
        }
    }
}

