/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.tablefield;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.ITableField;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.basic.table.ISwingScoutTable;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.JTableEx;
import org.eclipse.scout.rt.ui.swing.ext.JTableHeaderEx;
import org.eclipse.scout.rt.ui.swing.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.tablefield.ISwingScoutTableField;
import org.eclipse.scout.rt.ui.swing.form.fields.tablefield.ISwingTableStatus;
import org.eclipse.scout.rt.ui.swing.form.fields.tablefield.SwingTableStatus;

public class SwingScoutTableField
extends SwingScoutFieldComposite<ITableField<?>>
implements ISwingScoutTableField {
    private ISwingScoutTable m_tableComposite;
    private ISwingTableStatus m_swingTableStatus;

    @Override
    protected void initializeSwing() {
        JPanelEx container = new JPanelEx();
        container.setName(String.valueOf(((ITableField)this.getScoutObject()).getClass().getName()) + ".container");
        container.setOpaque(false);
        JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel((IFormField)this.getScoutObject());
        container.add(label);
        this.m_swingTableStatus = this.createSwingTableStatus(container);
        this.setSwingContainer(container);
        this.setSwingLabel(label);
        container.setLayout(new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
    }

    protected ISwingTableStatus createSwingTableStatus(JComponent container) {
        if (((ITableField)this.getScoutObject()).isTableStatusVisible()) {
            return new SwingTableStatus(this.getSwingEnvironment(), container, (ITableField)this.getScoutObject());
        }
        return null;
    }

    @Override
    public JScrollPane getSwingScrollPane() {
        return this.m_tableComposite != null ? this.m_tableComposite.getSwingScrollPane() : null;
    }

    @Override
    public JTableEx getSwingTable() {
        return this.m_tableComposite != null ? this.m_tableComposite.getSwingTable() : null;
    }

    @Override
    public ISwingTableStatus getSwingTableStatus() {
        return this.m_swingTableStatus;
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.setTableFromScout();
        this.setTableStatusFromScout();
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        this.getSwingLabel().setEnabled(b);
        if (this.getSwingScrollPane() != null) {
            this.getSwingScrollPane().getViewport().setOpaque(b);
        }
        if (this.getSwingTable() != null) {
            this.getSwingTable().repaint();
            if (this.getSwingTable().getTableHeader() != null) {
                this.getSwingTable().getTableHeader().repaint();
            }
        }
    }

    protected void setTableStatusFromScout() {
        if (this.m_swingTableStatus != null) {
            IProcessingStatus dataStatus = ((ITableField)this.getScoutObject()).getTablePopulateStatus();
            IProcessingStatus selectionStatus = ((ITableField)this.getScoutObject()).getTableSelectionStatus();
            this.m_swingTableStatus.setStatus(dataStatus, selectionStatus);
        }
    }

    protected void setTableFromScout() {
        ITable newTable;
        ITable oldTable = this.m_tableComposite != null ? (ITable)this.m_tableComposite.getScoutObject() : null;
        if (oldTable != (newTable = ((ITableField)this.getScoutObject()).getTable())) {
            JComponent container = this.getSwingContainer();
            if (this.m_tableComposite != null) {
                container.remove(this.m_tableComposite.getSwingScrollPane());
                this.setSwingField(null);
                this.m_tableComposite.disconnectFromScout();
                this.m_tableComposite = null;
            }
            if (newTable != null) {
                IGroupBox g;
                ISwingScoutTable newTableComposite = this.getSwingEnvironment().createTable(newTable);
                newTableComposite.createField(newTable, this.getSwingEnvironment());
                IForm form = this.getScoutObject() != null ? ((ITableField)this.getScoutObject()).getForm() : null;
                JTableEx newSwingTable = newTableComposite.getSwingTable();
                if (newSwingTable != null && form != null && "PAGE_TABLE".equals(form.getDisplayViewId())) {
                    newSwingTable.setName("Synth.WideTable");
                    if (newSwingTable.getTableHeader() instanceof JTableHeaderEx) {
                        ((JTableHeaderEx)newSwingTable.getTableHeader()).updatePreferredHeight();
                    }
                }
                newTableComposite.getSwingScrollPane().putClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME, LogicalGridDataBuilder.createField(this.getSwingEnvironment(), ((ITableField)this.getScoutObject()).getGridData()));
                if (((ITableField)this.getScoutObject()).getForm().getOuterForm() == null && ((ITableField)this.getScoutObject()).getParentField() instanceof IGroupBox && (g = (IGroupBox)((ITableField)this.getScoutObject()).getParentField()).isMainBox() && !g.isBorderVisible()) {
                    JScrollPane scrollPane = newTableComposite.getSwingScrollPane();
                    scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
                }
                this.m_tableComposite = newTableComposite;
                container.add(newTableComposite.getSwingScrollPane());
                this.setSwingField(newTableComposite.getSwingTable());
                container.revalidate();
                container.repaint();
            }
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("table")) {
            this.setTableFromScout();
        } else if (name.equals("tableSelectionStatus")) {
            this.setTableStatusFromScout();
        } else if (name.equals("tablePopulateStatus")) {
            this.setTableStatusFromScout();
        }
    }
}

