/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt;

import java.net.Authenticator;
import java.util.Hashtable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.rt.ui.swt.icons.SwtBundleIconLocator;
import org.eclipse.scout.rt.ui.swt.login.internal.InternalNetAuthenticator;
import org.eclipse.scout.rt.ui.swt.util.ISwtIconLocator;
import org.eclipse.scout.rt.ui.swt.util.SwtIconLocator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.scout.rt.ui.swt";
    private static Activator m_plugin;
    private ISwtIconLocator m_iconLocator;
    private ServiceRegistration m_netAuthRegistration;

    public static Activator getDefault() {
        return m_plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        m_plugin = this;
        Hashtable<String, Integer> map = new Hashtable<String, Integer>();
        map.put("service.ranking", -1);
        this.m_netAuthRegistration = Activator.getDefault().getBundle().getBundleContext().registerService(Authenticator.class.getName(), (Object)new InternalNetAuthenticator(), map);
    }

    public void stop(BundleContext context) throws Exception {
        this.m_iconLocator = null;
        if (this.m_netAuthRegistration != null) {
            this.m_netAuthRegistration.unregister();
            this.m_netAuthRegistration = null;
        }
        m_plugin = null;
        super.stop(context);
    }

    public static Image getIcon(String name) {
        return Activator.getDefault().getIconImpl(name);
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        Activator activator = Activator.getDefault();
        if (activator != null) {
            return activator.getImageDescriptorImpl(name);
        }
        return null;
    }

    private Image getIconImpl(String name) {
        if (this.m_iconLocator == null) {
            this.m_iconLocator = new SwtIconLocator(new SwtBundleIconLocator());
        }
        return this.m_iconLocator.getIcon(name, 0);
    }

    private ImageDescriptor getImageDescriptorImpl(String name) {
        if (this.m_iconLocator == null) {
            this.m_iconLocator = new SwtIconLocator(new SwtBundleIconLocator());
        }
        return this.m_iconLocator.getImageDescriptor(name);
    }
}

