/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.action.menu;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class MenuPositionCorrectionListener
implements Listener {
    public static final int HORIZONTAL_LEFT = 1;
    public static final int HORIZONTAL_CENTER = 2;
    public static final int HORIZONTAL_RIGHT = 4;
    public static final int VERTICAL_TOP = 8;
    public static final int VERTICAL_CENTER = 16;
    public static final int VERTICAL_BOTTOM = 32;
    private final Control m_owner;
    private final int m_position;

    public MenuPositionCorrectionListener(Control owner) {
        this(owner, 33);
    }

    public MenuPositionCorrectionListener(Control owner, int position) {
        this.m_owner = owner;
        this.m_position = position;
    }

    public void handleEvent(Event event) {
        Rectangle ownerBounds = this.getOwner().getBounds();
        if (!ownerBounds.contains(this.getOwner().getParent().toControl(event.x, event.y))) {
            Point newLocation = new Point(0, 0);
            newLocation.x = (this.getPosition() & 4) != 0 ? ownerBounds.x + ownerBounds.width : ((this.getPosition() & 2) != 0 ? ownerBounds.x + ownerBounds.width / 2 : ownerBounds.x);
            newLocation.y = (this.getPosition() & 8) != 0 ? ownerBounds.y : ((this.getPosition() & 0x10) != 0 ? ownerBounds.y + ownerBounds.height / 2 : ownerBounds.y + ownerBounds.height);
            newLocation = this.getOwner().toDisplay(newLocation);
            event.x = newLocation.x;
            event.y = newLocation.y;
        } else {
            ++event.x;
        }
    }

    public Control getOwner() {
        return this.m_owner;
    }

    public int getPosition() {
        return this.m_position;
    }
}

