/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.action.menu.text;

import org.eclipse.scout.rt.ui.swt.action.menu.text.ITextAccess;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TextAccess
implements ITextAccess {
    private Text m_textControl;

    public TextAccess(Text textControl) {
        this.m_textControl = textControl;
    }

    @Override
    public boolean isEnabled() {
        return this.m_textControl.isEnabled();
    }

    @Override
    public boolean isEditable() {
        return this.m_textControl.getEditable();
    }

    @Override
    public boolean hasSelection() {
        return this.m_textControl.getSelectionCount() > 0;
    }

    @Override
    public Point getSelection() {
        return this.m_textControl.getSelection();
    }

    @Override
    public String getText() {
        return this.m_textControl.getText();
    }

    @Override
    public String getSelectedText() {
        return this.m_textControl.getSelectionText();
    }

    @Override
    public Control getTextControl() {
        return this.m_textControl;
    }

    @Override
    public boolean isMasked() {
        return (this.m_textControl.getStyle() & 0x400000) != 0;
    }

    @Override
    public void copy() {
        this.m_textControl.copy();
    }

    @Override
    public boolean hasTextOnClipboard() {
        TextTransfer plainTextTransfer = TextTransfer.getInstance();
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(this.m_textControl.getDisplay());
            String contents = (String)clipboard.getContents((Transfer)plainTextTransfer, 1);
            boolean bl = contents != null && contents.length() > 0;
            return bl;
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }

    @Override
    public void paste() {
        this.m_textControl.paste();
    }

    @Override
    public void cut() {
        this.m_textControl.cut();
    }
}

