/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.calendar.widgets;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swt.basic.calendar.CalendarModel;
import org.eclipse.scout.rt.ui.swt.basic.calendar.CalendarViewEvent;
import org.eclipse.scout.rt.ui.swt.basic.calendar.EmptyCalendarModel;
import org.eclipse.scout.rt.ui.swt.basic.calendar.ICalendarViewListener;
import org.eclipse.scout.rt.ui.swt.basic.calendar.SwtColors;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.AbstractCell;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.CentralPanel;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.DateBrowserBar;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.SelectionScopeBar;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class SwtCalendar
extends Composite
implements PaintListener {
    protected static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtCalendar.class);
    private ArrayList<ICalendarViewListener> calendarViewListeners;
    private int m_workDayCount = 5;
    private Map m_itemMap;
    private Calendar m_selectedDate;
    private Calendar m_viewDate;
    private Calendar m_viewDateStart;
    private Calendar m_viewDateEnd;
    private CalendarModel m_model = new EmptyCalendarModel();
    private Object m_selectedItem;
    private boolean m_calendarUpdating;
    private DateBrowserBar m_browserBar;
    private Composite m_centralComposite;
    private CentralPanel m_calendarPanel;
    private SelectionScopeBar m_selectionScope;
    private int m_startHour = 6;
    private int m_endHour = 20;
    private boolean m_useOverflowCells = true;
    private boolean m_markNoonHour = true;
    private boolean m_markOutOfMonthDays = true;

    public SwtCalendar(Composite parent, int style) {
        super(parent, style);
        this.calendarViewListeners = new ArrayList();
        this.createControls();
        this.addPaintListener(this);
        this.setToday();
    }

    protected void createControls() {
        GridLayout toplayout = new GridLayout();
        toplayout.numColumns = 1;
        toplayout.verticalSpacing = 1;
        toplayout.marginHeight = 2;
        toplayout.marginWidth = 2;
        this.setLayout((Layout)toplayout);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.setLayoutData(gd);
        this.m_browserBar = new DateBrowserBar(this, 0);
        this.m_centralComposite = new Composite((Composite)this, 0);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.m_centralComposite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_centralComposite.setLayout((Layout)layout);
        this.m_selectionScope = new SelectionScopeBar(this, 0);
    }

    protected void reloadCalendarItems() {
        this.m_calendarPanel.reloadCalendarItems();
    }

    public void refreshLayout() {
        if (this.m_calendarPanel != null && !this.m_calendarPanel.isDisposed()) {
            this.m_calendarPanel.dispose();
        }
        this.m_calendarPanel = new CentralPanel(this.m_centralComposite, 0, this);
        this.m_calendarPanel.setState();
        this.m_calendarPanel.updateSelection(this.m_selectedDate);
        this.m_centralComposite.layout();
        this.layout(true);
    }

    public void setModel(CalendarModel model) {
        this.m_model = model;
        this.modelChanged();
    }

    public CalendarModel getModel() {
        return this.m_model;
    }

    public Composite getCentralComposite() {
        return this.m_centralComposite;
    }

    public CentralPanel getCentralPanel() {
        return this.m_calendarPanel;
    }

    protected void fireSelectionChanged() {
        if (this.calendarViewListeners != null && this.calendarViewListeners.size() > 0) {
            Date viewDate = this.getViewDate().getTime();
            Date viewDateStart = this.getViewDateStart().getTime();
            Date viewDateEnd = this.getViewDateEnd().getTime();
            CalendarViewEvent e = new CalendarViewEvent((Object)this, 30, viewDate, viewDateStart, viewDateEnd);
            int i = 0;
            while (i < this.calendarViewListeners.size()) {
                this.calendarViewListeners.get(i).viewChanged(e);
                ++i;
            }
        }
    }

    protected void fireViewDateChanged() {
        if (this.calendarViewListeners != null && this.calendarViewListeners.size() > 0) {
            Date viewDate = this.getViewDate().getTime();
            Date viewDateStart = this.getViewDateStart().getTime();
            Date viewDateEnd = this.getViewDateEnd().getTime();
            CalendarViewEvent e = new CalendarViewEvent((Object)this, 10, viewDate, viewDateStart, viewDateEnd);
            int i = 0;
            while (i < this.calendarViewListeners.size()) {
                this.calendarViewListeners.get(i).viewChanged(e);
                ++i;
            }
        }
    }

    public void setSelectedItem(Object item) {
        Date b;
        Date a;
        Object oldItem = this.m_selectedItem;
        this.m_selectedItem = item;
        CalendarModel model = this.getModel();
        if (oldItem != null) {
            a = model.getFromDate(oldItem);
            b = model.getToDate(oldItem);
            this.repaintCellRange(a, b);
        }
        if (item != null) {
            a = model.getFromDate(item);
            b = model.getToDate(item);
            this.repaintCellRange(a, b);
        }
        this.fireSelectionChanged();
    }

    protected void repaintCellRange(Date a, Date b) {
        if (b == null) {
            b = a;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(SwtCalendar.truncDate(a));
        while (cal.getTime().compareTo(b) <= 0) {
            AbstractCell cell = this.m_calendarPanel.getCellFromDate(cal.getTime());
            if (cell != null) {
                cell.redraw();
            }
            cal.add(5, 1);
        }
    }

    public static Calendar getCalendarFromDate(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c;
    }

    public Object getSelectedItem() {
        return this.m_selectedItem;
    }

    public void modelChanged() {
        LOG.debug("Reloading items...");
        if (this.m_calendarPanel != null) {
            this.m_calendarPanel.reloadCalendarItems();
        }
    }

    public void setShowDisplayModeSelection(boolean showDisplayModeSelection) {
        this.m_selectionScope.setVisible(showDisplayModeSelection);
        ((GridData)this.m_selectionScope.getLayoutData()).exclude = !showDisplayModeSelection;
    }

    public void setWorkingHours(int startHour, int endHour, boolean useOverflowCells) {
        this.m_startHour = startHour;
        this.m_endHour = endHour + 1;
        this.m_useOverflowCells = useOverflowCells;
    }

    public void setMarkNoonHour(boolean markNoonHour) {
        this.m_markNoonHour = markNoonHour;
    }

    public void setMarkOutOfMonthDays(boolean markOutOfMonthDays) {
        this.m_markOutOfMonthDays = markOutOfMonthDays;
    }

    public int getStartHour() {
        return this.m_startHour;
    }

    public int getEndHour() {
        return this.m_endHour;
    }

    public boolean getUseOverflowCells() {
        return this.m_useOverflowCells;
    }

    public boolean getMarkNoonHour() {
        return this.m_markNoonHour;
    }

    public boolean getMarkOutOfMonthDays() {
        return this.m_markOutOfMonthDays;
    }

    public void setDisplayMode(int newMode) {
        if (newMode != 3 && newMode != 2 && newMode != 4 && newMode != 1) {
            throw new IllegalArgumentException("illegal display mode: " + newMode);
        }
        int oldMode = this.m_selectionScope.getDisplayMode();
        if (oldMode == newMode) {
            return;
        }
        this.m_selectionScope.setDisplayMode(newMode);
        this.calcViewDateInterval();
        LOG.debug("displayMode set to " + newMode);
    }

    public int getDisplayMode() {
        return this.m_selectionScope.getDisplayMode();
    }

    public void setCondensedMode(boolean mode) {
        boolean oldMode = this.m_selectionScope.getCondensedMode();
        if (oldMode == mode) {
            return;
        }
        this.m_selectionScope.setCondensedMode(mode);
        LOG.debug("set to condensed mode " + mode);
    }

    public boolean getCondensedMode() {
        return this.m_selectionScope.getCondensedMode();
    }

    public void setFirstDayOfWeek(int day) {
        if (day < 1 || day > 7) {
            throw new IllegalArgumentException("Illegal first day of week: " + day);
        }
        int oldDay = this.m_selectionScope.getFirstDayOfWeek();
        if (oldDay == day) {
            return;
        }
        this.calcViewDateInterval();
        LOG.debug("first day of week set to " + day);
    }

    public void setDateBrowserHeader(String header) {
        if (this.m_browserBar != null) {
            this.m_browserBar.setHeaderText(header);
            this.m_browserBar.layout(true);
        }
    }

    public int getFirstDayOfWeek() {
        return this.m_selectionScope.getFirstDayOfWeek();
    }

    public void addCalendarViewListener(ICalendarViewListener listener) {
        this.calendarViewListeners.add(listener);
    }

    public void removeCalendarViewListener(ICalendarViewListener listener) {
        this.calendarViewListeners.remove(listener);
    }

    public void showContextMenu(Menu manager) {
    }

    public void paintControl(PaintEvent e) {
        this.setBackground(SwtColors.getInstance().getWhite());
        this.setForeground(SwtColors.getInstance().getDarkgray());
        this.drawBorders(e);
    }

    protected void drawBorders(PaintEvent e) {
        Rectangle bounds = this.getBounds();
        e.gc.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
    }

    protected boolean changedViewDateInterval(Calendar newViewDate) {
        switch (this.getDisplayMode()) {
            case 1: {
                return !newViewDate.equals(this.m_viewDate);
            }
            case 2: 
            case 4: {
                Calendar viewDateStart = Calendar.getInstance();
                viewDateStart.setTime(newViewDate.getTime());
                viewDateStart.add(7, -((viewDateStart.get(7) - this.getFirstDayOfWeek() + 7) % 7));
                return !viewDateStart.equals(this.m_viewDateStart);
            }
            case 3: {
                Calendar viewDateStart = Calendar.getInstance();
                viewDateStart.setTime(newViewDate.getTime());
                viewDateStart.add(5, -(viewDateStart.get(5) - 1));
                viewDateStart.add(7, -((viewDateStart.get(7) - this.getFirstDayOfWeek() + 7) % 7));
                return !viewDateStart.equals(this.m_viewDateStart);
            }
        }
        LOG.error("Should not reach this case");
        return false;
    }

    protected void calcViewDateInterval() {
        switch (this.getDisplayMode()) {
            case 1: {
                this.m_viewDateStart = Calendar.getInstance();
                this.m_viewDateStart.setTime(this.m_viewDate.getTime());
                this.m_viewDateEnd = (Calendar)this.m_viewDateStart.clone();
                this.m_viewDateEnd.set(10, 23);
                this.m_viewDateEnd.set(12, 59);
                break;
            }
            case 2: 
            case 4: {
                this.m_viewDateStart = Calendar.getInstance();
                this.m_viewDateStart.setTime(this.m_viewDate.getTime());
                this.m_viewDateStart.add(7, -((this.m_viewDateStart.get(7) - this.getFirstDayOfWeek() + 7) % 7));
                this.m_viewDateEnd = Calendar.getInstance();
                this.m_viewDateEnd.setTime(this.m_viewDateStart.getTime());
                this.m_viewDateEnd.add(5, this.getDisplayMode() == 2 ? 7 : 5);
                break;
            }
            case 3: {
                this.m_viewDateStart = Calendar.getInstance();
                this.m_viewDateStart.setTime(this.m_viewDate.getTime());
                this.m_viewDateStart.add(5, -(this.m_viewDateStart.get(5) - 1));
                this.m_viewDateStart.add(7, -((this.m_viewDateStart.get(7) - this.getFirstDayOfWeek() + 7) % 7));
                this.m_viewDateEnd = Calendar.getInstance();
                this.m_viewDateEnd.setTime(this.m_viewDateStart.getTime());
                this.m_viewDateEnd.add(5, 41);
            }
        }
    }

    protected void shiftViewDate(int type, int amount) {
        this.shiftViewDate(type, amount, true);
    }

    protected void shiftViewDate(int type, int amount, boolean fireNotification) {
        this.m_viewDate.add(type, amount);
        this.calcViewDateInterval();
        LOG.debug("new date: " + this.m_viewDate.getTime().toString());
    }

    public void setToday() {
        this.m_viewDate = SwtCalendar.truncDate(Calendar.getInstance());
        LOG.debug("new date: " + this.m_viewDate.getTime().toString());
        this.calcViewDateInterval();
        this.setSelectedDate(this.m_viewDate);
        this.refreshLayout();
    }

    public void setViewDate(Calendar c) {
        if (c == null) {
            if (this.m_viewDate != null) {
                return;
            }
            c = Calendar.getInstance();
        }
        if (this.m_viewDate.equals(c = SwtCalendar.truncDate(c))) {
            return;
        }
        boolean showingScopeChanged = this.changedViewDateInterval(c);
        this.m_viewDate = c;
        this.calcViewDateInterval();
        if (showingScopeChanged) {
            this.refreshLayout();
        }
    }

    public Calendar getViewDate() {
        return this.m_viewDate;
    }

    public Calendar getViewDateStart() {
        return this.m_viewDateStart;
    }

    public Calendar getViewDateEnd() {
        return this.m_viewDateEnd;
    }

    public static Date truncDate(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return SwtCalendar.truncDate(c).getTime();
    }

    public static Calendar truncDate(Calendar c) {
        if (c == null) {
            return null;
        }
        c.set(10, 0);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c;
    }

    public void prevDay() {
        this.shiftViewDate(5, -1);
    }

    public void prevWeek() {
        this.shiftViewDate(3, -1);
    }

    public void prevMonth() {
        this.shiftViewDate(2, -1);
    }

    public void prevYear() {
        this.shiftViewDate(1, -1);
    }

    public void nextDay() {
        this.shiftViewDate(5, 1);
    }

    public void nextWeek() {
        this.shiftViewDate(3, 1);
    }

    public void nextMonth() {
        this.shiftViewDate(2, 1);
    }

    public void nextYear() {
        this.shiftViewDate(1, 1);
    }

    public void setSelectedDate(Calendar c) {
        if ((c = SwtCalendar.truncDate(c)) != null) {
            this.m_selectedDate = c;
        }
    }

    public void setSelectedDateFromUI(Calendar c) {
        this.setSelectedDate(c);
    }

    public void updateSelection() {
        if (this.m_calendarPanel != null) {
            this.m_calendarPanel.updateSelection(this.m_selectedDate);
        }
    }

    public Calendar getSelectedDate() {
        return this.m_selectedDate;
    }

    public void fastBackward() {
        LOG.debug("fast backward");
        switch (this.m_selectionScope.getDisplayMode()) {
            case 3: {
                this.prevYear();
                break;
            }
            case 2: 
            case 4: {
                this.prevMonth();
                break;
            }
            default: {
                this.prevMonth();
            }
        }
    }

    public void backward() {
        LOG.debug("backward");
        switch (this.m_selectionScope.getDisplayMode()) {
            case 3: {
                this.prevMonth();
                break;
            }
            case 2: 
            case 4: {
                this.prevWeek();
                break;
            }
            default: {
                this.prevDay();
            }
        }
    }

    public void forward() {
        LOG.debug("forward");
        switch (this.m_selectionScope.getDisplayMode()) {
            case 3: {
                this.nextMonth();
                break;
            }
            case 2: 
            case 4: {
                this.nextWeek();
                break;
            }
            default: {
                this.nextDay();
            }
        }
    }

    public void fastForward() {
        LOG.debug("fast forward");
        switch (this.m_selectionScope.getDisplayMode()) {
            case 3: {
                this.nextYear();
                break;
            }
            case 2: 
            case 4: {
                this.nextMonth();
                break;
            }
            default: {
                this.nextMonth();
            }
        }
    }

    public void dispose() {
        if (this.m_browserBar != null && !this.m_browserBar.isDisposed()) {
            this.m_browserBar.dispose();
        }
        if (this.m_centralComposite != null && !this.m_centralComposite.isDisposed()) {
            this.m_centralComposite.dispose();
        }
        if (this.m_calendarPanel != null && !this.m_calendarPanel.isDisposed()) {
            this.m_calendarPanel.dispose();
        }
        if (this.m_selectionScope != null && !this.m_selectionScope.isDisposed()) {
            this.m_selectionScope.dispose();
        }
        super.dispose();
    }
}

