/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.tree;

import java.util.List;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.ui.swt.Activator;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class SwtScoutTreeModel
extends LabelProvider
implements ITreeContentProvider,
IFontProvider,
IColorProvider {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutTreeModel.class);
    private ITree m_tree;
    private final ISwtEnvironment m_environment;
    private final TreeViewer m_treeViewer;
    private Image m_imgCheckboxTrue;
    private Image m_imgCheckboxFalse;
    private Color m_disabledForegroundColor;
    private Color m_disabledBackgroundColor;

    public SwtScoutTreeModel(ITree tree, ISwtEnvironment environment, TreeViewer treeViewer) {
        this.m_tree = tree;
        this.m_environment = environment;
        this.m_treeViewer = treeViewer;
        this.m_imgCheckboxTrue = Activator.getIcon("checkbox_yes");
        this.m_imgCheckboxFalse = Activator.getIcon("checkbox_no");
        this.m_disabledForegroundColor = this.m_environment.getColor(UiDecorationExtensionPoint.getLookAndFeel().getColorForegroundDisabled());
        this.m_disabledBackgroundColor = this.m_environment.getColor(UiDecorationExtensionPoint.getLookAndFeel().getColorBackgroundDisabled());
    }

    public Object[] getChildren(Object parentElement) {
        ITreeNode scoutNode = (ITreeNode)parentElement;
        List childNodes = scoutNode.getFilteredChildNodes();
        return childNodes.toArray(new ITreeNode[childNodes.size()]);
    }

    public Object getParent(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        return scoutNode.getParentNode();
    }

    public boolean hasChildren(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        return !scoutNode.isLeaf();
    }

    public Object[] getElements(Object inputElement) {
        if (this.m_tree != null) {
            if (this.m_tree.isRootNodeVisible()) {
                return new Object[]{this.m_tree.getRootNode()};
            }
            List childNodes = this.m_tree.getRootNode().getFilteredChildNodes();
            return childNodes.toArray(new ITreeNode[childNodes.size()]);
        }
        return new Object[0];
    }

    public Image getImage(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        Image img = null;
        if (this.m_tree.isCheckable()) {
            if (scoutNode != null && scoutNode.isChecked()) {
                return this.m_imgCheckboxTrue;
            }
            return this.m_imgCheckboxFalse;
        }
        img = this.m_environment.getIcon(scoutNode.getCell().getIconId());
        return img;
    }

    public String getText(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        String text = scoutNode.getCell().getText();
        text = StringUtility.removeNewLines((String)text);
        return text;
    }

    public Font getFont(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        if (scoutNode.getCell().getFont() != null) {
            return this.m_environment.getFont(scoutNode.getCell().getFont(), this.m_treeViewer.getTree().getFont());
        }
        return null;
    }

    public Color getForeground(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        ICell scoutCell = scoutNode.getCell();
        Color col = this.m_environment.getColor(scoutCell.getForegroundColor());
        if (col == null && !scoutCell.isEnabled()) {
            col = this.m_disabledForegroundColor;
        }
        return col;
    }

    public Color getBackground(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        if (scoutNode.getCell().getBackgroundColor() != null) {
            Color col = this.m_environment.getColor(scoutNode.getCell().getBackgroundColor());
            if (col == null && !scoutNode.isEnabled()) {
                col = this.m_disabledBackgroundColor;
            }
            return col;
        }
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

