/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.ext.table;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IStringColumn;
import org.eclipse.scout.rt.ui.swt.ext.table.internal.EditableTableMarkerSupport;
import org.eclipse.scout.rt.ui.swt.ext.table.internal.TableMultilineListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableEx
extends Table {
    private static final int TEXT_MARGIN_Y = 1;
    private static final int TEXT_MARGIN_X = 6;
    private boolean m_readOnly;
    private int m_insideSetTopIndex;

    public TableEx(Composite parent, int style, ITable table) {
        super(parent, style);
        if (table != null) {
            int rowHeight = table.getRowHeightHint() - 2;
            boolean multiline = table.isMultilineText();
            Set<Integer> wrapTextColumns = this.getWrapTextColumnIdxs(table);
            if (multiline || wrapTextColumns.size() > 0) {
                TableMultilineListener multilineListener = new TableMultilineListener(multiline, rowHeight, wrapTextColumns, 6, 1);
                this.addListener(41, multilineListener);
                this.addListener(40, multilineListener);
                this.addListener(42, multilineListener);
            }
            new EditableTableMarkerSupport(this);
        }
    }

    private Set<Integer> getWrapTextColumnIdxs(ITable table) {
        HashSet<Integer> res = new HashSet<Integer>();
        for (IColumn column : table.getColumns()) {
            if (!(column instanceof IStringColumn) || !((IStringColumn)column).isTextWrap()) continue;
            res.add(column.getColumnIndex());
        }
        return res;
    }

    protected void checkSubclass() {
    }

    public void setTopIndex(int index) {
        if (this.m_insideSetTopIndex > 0) {
            return;
        }
        try {
            ++this.m_insideSetTopIndex;
            super.setTopIndex(index);
        }
        finally {
            --this.m_insideSetTopIndex;
        }
    }

    public Point computeSize(int hint, int hint2, boolean changed) {
        Point size = super.computeSize(hint, hint2, changed);
        TableColumn[] columns = this.getColumns();
        if (columns != null) {
            int x = 0;
            TableColumn[] tableColumnArray = columns;
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn col = tableColumnArray[n2];
                x += col.getWidth();
                ++n2;
            }
            size.x = x += columns.length * this.getGridLineWidth();
        }
        return size;
    }

    public void setReadOnly(boolean readOnly) {
        if (this.m_readOnly != readOnly) {
            this.m_readOnly = readOnly;
        }
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.setForeground(null);
        } else {
            this.setForeground(this.getDisplay().getSystemColor(15));
        }
    }
}

