/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.ext.table.util;

import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableCellRolloverSupport {
    private TableItem m_mouseHoverItem;
    private int m_cursorIndex = -1;
    private int[] m_colPositions;
    private Color m_mouseHoverBackground;
    private P_RowMouseTrackListener m_trackListener = new P_RowMouseTrackListener();
    private final Table m_table;
    private final TableViewer m_viewer;

    public TableCellRolloverSupport(TableViewer viewer) {
        this.m_viewer = viewer;
        this.m_table = this.m_viewer.getTable();
        this.m_mouseHoverBackground = new Color((Device)this.m_table.getDisplay(), 179, 195, 255);
        this.attachListeners();
    }

    protected void attachListeners() {
        this.getTable().addMouseMoveListener((MouseMoveListener)this.m_trackListener);
        this.getTable().addMouseTrackListener((MouseTrackListener)this.m_trackListener);
        this.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TableCellRolloverSupport.this.dettachListeners();
                TableCellRolloverSupport.this.m_mouseHoverBackground.dispose();
            }
        });
    }

    protected void dettachListeners() {
        this.getTable().removeMouseMoveListener((MouseMoveListener)this.m_trackListener);
        this.getTable().removeMouseTrackListener((MouseTrackListener)this.m_trackListener);
    }

    public Table getTable() {
        return this.m_table;
    }

    public TableViewer getViewer() {
        return this.m_viewer;
    }

    private void saveColumnPositions() {
        this.m_colPositions = new int[this.getTable().getColumnCount()];
        TableItem item = this.getTable().getItem(0);
        int i = 0;
        while (i < this.getTable().getColumnCount()) {
            this.m_colPositions[i] = item.getBounds((int)i).x + item.getBounds((int)i).width;
            ++i;
        }
    }

    private int getColumnIndex(int x) {
        int i = 0;
        while (i < this.m_colPositions.length && x > this.m_colPositions[i]) {
            ++i;
        }
        return i;
    }

    private void asyncRedraw(final int x, final int y, final int width, final int height) {
        this.getTable().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (TableCellRolloverSupport.this.getTable() != null && !TableCellRolloverSupport.this.getTable().isDisposed()) {
                    TableCellRolloverSupport.this.getTable().redraw(x, y, width, height, true);
                }
            }
        });
    }

    private class P_RowMouseTrackListener
    extends MouseTrackAdapter
    implements MouseMoveListener {
        private P_RowMouseTrackListener() {
        }

        public void mouseMove(MouseEvent e) {
            TableItem item;
            Point p = new Point(e.x, e.y);
            int index = TableCellRolloverSupport.this.getColumnIndex(e.x);
            if ((TableCellRolloverSupport.this.getTable().getItem(p) != TableCellRolloverSupport.this.m_mouseHoverItem || TableCellRolloverSupport.this.m_cursorIndex != index) && (item = TableCellRolloverSupport.this.getTable().getItem(p)) != null) {
                Rectangle bounds;
                if (TableCellRolloverSupport.this.m_mouseHoverItem != null && !TableCellRolloverSupport.this.m_mouseHoverItem.isDisposed() && TableCellRolloverSupport.this.m_cursorIndex > -1) {
                    TableCellRolloverSupport.this.m_mouseHoverItem.setBackground(TableCellRolloverSupport.this.m_cursorIndex, ((ITableColorProvider)TableCellRolloverSupport.this.m_viewer.getLabelProvider()).getBackground(TableCellRolloverSupport.this.m_mouseHoverItem.getData(), TableCellRolloverSupport.this.m_cursorIndex));
                    TableCellRolloverSupport.this.m_mouseHoverItem.setForeground(TableCellRolloverSupport.this.m_cursorIndex, ((ITableColorProvider)TableCellRolloverSupport.this.m_viewer.getLabelProvider()).getForeground(TableCellRolloverSupport.this.m_mouseHoverItem.getData(), TableCellRolloverSupport.this.m_cursorIndex));
                    bounds = TableCellRolloverSupport.this.m_mouseHoverItem.getBounds(TableCellRolloverSupport.this.m_cursorIndex);
                    TableCellRolloverSupport.this.asyncRedraw(bounds.x, bounds.y, bounds.width, bounds.height);
                }
                TableCellRolloverSupport.this.m_mouseHoverItem = item;
                TableCellRolloverSupport.this.m_cursorIndex = index;
                TableCellRolloverSupport.this.m_mouseHoverItem.setBackground(TableCellRolloverSupport.this.m_cursorIndex, TableCellRolloverSupport.this.m_mouseHoverBackground);
                TableCellRolloverSupport.this.m_mouseHoverItem.setForeground(TableCellRolloverSupport.this.m_cursorIndex, Display.getCurrent().getSystemColor(24));
                bounds = TableCellRolloverSupport.this.m_mouseHoverItem.getBounds(TableCellRolloverSupport.this.m_cursorIndex);
                TableCellRolloverSupport.this.asyncRedraw(bounds.x, bounds.y, bounds.width, bounds.height);
            }
        }

        public void mouseExit(MouseEvent e) {
            if (TableCellRolloverSupport.this.m_mouseHoverItem != null && !TableCellRolloverSupport.this.m_mouseHoverItem.isDisposed() && TableCellRolloverSupport.this.m_cursorIndex > -1) {
                TableCellRolloverSupport.this.m_mouseHoverItem.setBackground(TableCellRolloverSupport.this.m_cursorIndex, ((ITableColorProvider)TableCellRolloverSupport.this.getViewer().getLabelProvider()).getBackground(TableCellRolloverSupport.this.m_mouseHoverItem.getData(), TableCellRolloverSupport.this.m_cursorIndex));
                TableCellRolloverSupport.this.m_mouseHoverItem.setForeground(TableCellRolloverSupport.this.m_cursorIndex, ((ITableColorProvider)TableCellRolloverSupport.this.getViewer().getLabelProvider()).getForeground(TableCellRolloverSupport.this.m_mouseHoverItem.getData(), TableCellRolloverSupport.this.m_cursorIndex));
                Rectangle bounds = TableCellRolloverSupport.this.m_mouseHoverItem.getBounds(TableCellRolloverSupport.this.m_cursorIndex);
                TableCellRolloverSupport.this.m_mouseHoverItem = null;
                TableCellRolloverSupport.this.m_cursorIndex = -1;
                TableCellRolloverSupport.this.asyncRedraw(bounds.x, bounds.y, bounds.width, bounds.height);
            }
        }

        public void mouseEnter(MouseEvent e) {
            if (TableCellRolloverSupport.this.m_colPositions == null) {
                TableCellRolloverSupport.this.saveColumnPositions();
            }
        }
    }
}

