/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.rap.ui.internal.extensions.bundle;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.sdk.ui.extensions.bundle.IProductLauncherContributor;
import org.eclipse.scout.sdk.ui.internal.extensions.bundle.ServerProductLauncherContributor;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.ILink;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.LinksPresenterModel;

public class RapProductLauncherContributor
implements IProductLauncherContributor {
    private ServerProductLauncherContributor.JettyProductUrlOpenLink m_deviceDispatchLink;
    private ServerProductLauncherContributor.JettyProductUrlOpenLink m_desktopLink;
    private ServerProductLauncherContributor.JettyProductUrlOpenLink m_smartphoneLink;
    private ServerProductLauncherContributor.JettyProductUrlOpenLink m_tabletLink;

    public void contributeLinks(IFile productFile, LinksPresenterModel model) throws CoreException {
        boolean isJettyConfigured;
        boolean bl = isJettyConfigured = ServerProductLauncherContributor.getJettyBaseUrl((IFile)productFile) != null;
        if (isJettyConfigured) {
            this.m_deviceDispatchLink = new ServerProductLauncherContributor.JettyProductUrlOpenLink("Automatic Device Dispatch", productFile, "", 30);
            this.m_desktopLink = new ServerProductLauncherContributor.JettyProductUrlOpenLink("Desktop Devices", productFile, "web", 40);
            this.m_smartphoneLink = new ServerProductLauncherContributor.JettyProductUrlOpenLink("Smartphone Devices", productFile, "mobile", 50);
            this.m_tabletLink = new ServerProductLauncherContributor.JettyProductUrlOpenLink("Tablet Devices", productFile, "tablet", 60);
            model.addGlobalLink((ILink)this.m_deviceDispatchLink);
            model.addGlobalLink((ILink)this.m_desktopLink);
            model.addGlobalLink((ILink)this.m_smartphoneLink);
            model.addGlobalLink((ILink)this.m_tabletLink);
        }
    }

    public void refreshLaunchState(String mode) {
        if (this.m_deviceDispatchLink != null && this.m_desktopLink != null && this.m_smartphoneLink != null && this.m_tabletLink != null) {
            boolean running = !"terminated".equals(mode);
            this.m_deviceDispatchLink.setEnabled(running);
            this.m_desktopLink.setEnabled(running);
            this.m_smartphoneLink.setEnabled(running);
            this.m_tabletLink.setEnabled(running);
        }
    }
}

