/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.library;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.library.LibraryBundleUnlinkOperation;
import org.eclipse.scout.sdk.ui.action.AbstractScoutHandler;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LibrariesBundleUnlinkAction
extends AbstractScoutHandler {
    private HashMap<IScoutBundle, List<IPluginModelBase>> m_libraries = new HashMap();

    public LibrariesBundleUnlinkAction() {
        super(Texts.get((String)"UnlinkLibraryBundlePopup"), ScoutSdkUi.getImageDescriptor("libraries_remove.png"), "Delete", true, IScoutHandler.Category.DELETE);
    }

    @Override
    public Object execute(Shell shell, IPage[] selection, ExecutionEvent event) throws ExecutionException {
        BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                LibrariesBundleUnlinkAction.this.unlinkLibraries();
            }
        });
        return null;
    }

    protected void unlinkLibraries() {
        OperationJob job = new OperationJob();
        for (Map.Entry<IScoutBundle, List<IPluginModelBase>> workUnit : this.m_libraries.entrySet()) {
            LibraryBundleUnlinkOperation op = new LibraryBundleUnlinkOperation(workUnit.getKey(), (Collection)workUnit.getValue());
            job.addOperation((IOperation)op);
        }
        job.schedule();
    }

    @Override
    public boolean isVisible() {
        if (this.m_libraries.size() < 1) {
            return false;
        }
        for (IScoutBundle b : this.m_libraries.keySet()) {
            if (!b.isBinary()) continue;
            return false;
        }
        return true;
    }

    public void addLibraryToRemove(IScoutBundle ownerBundle, IPluginModelBase libraryModel) {
        List<IPluginModelBase> libs = this.m_libraries.get(ownerBundle);
        if (libs == null) {
            libs = new ArrayList<IPluginModelBase>(3);
            this.m_libraries.put(ownerBundle, libs);
        }
        libs.add(libraryModel);
    }
}

