/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.rename;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.rename.AbstractRenameAction;
import org.eclipse.scout.sdk.ui.internal.jdt.JdtRenameTransaction;
import org.eclipse.scout.sdk.util.type.TypeUtility;

public class TypeRenameAction
extends AbstractRenameAction {
    private IType m_type;

    @Override
    protected void fillTransaction(JdtRenameTransaction transaction, String newName) throws CoreException {
        transaction.add(this.getType(), newName);
    }

    @Override
    public boolean isVisible() {
        return this.isEditable((IJavaElement)this.m_type);
    }

    @Override
    protected IStatus validate(String newName) {
        String packName;
        IStatus inheritedStatus = this.getJavaNameStatus(newName);
        if (inheritedStatus.matches(4)) {
            return inheritedStatus;
        }
        IType declaringType = this.getType().getDeclaringType();
        if (declaringType != null ? TypeUtility.exists((IJavaElement)declaringType.getType(newName)) : TypeUtility.existsType((String)(String.valueOf(packName = this.getType().getPackageFragment().getElementName()) + "." + newName))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        return inheritedStatus;
    }

    public IType getType() {
        return this.m_type;
    }

    public void setType(IType type) {
        this.m_type = type;
    }
}

