/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal;

import java.util.EventListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.window.Window;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.fields.proposal.IDialogSettingsProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.ILazyProposalContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalDescriptionProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalPopupListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ISelectionStateLabelProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.ISeparatorLabelProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.ISeparatorProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalPopupEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.styled.ISearchRangeConsumer;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class ProposalPopup
extends Window {
    private static final String DIALOG_SETTINGS_WIDTH = "dialogSettingsWidth";
    private static final String DIALOG_SETTINGS_HEIGHT = "dialogSettingsHeight";
    private static final int POPUP_OFFSET = 2;
    private static final int MINIMUM_HEIGHT = 100;
    private static final int MINIMUM_WIDTH = 200;
    private static final int DEFAULT_WIDTH = 400;
    private static final int DEFAULT_HEIGHT = 300;
    public static final Object[] LOADING_PROPOSAL = new Object[]{new ISeparatorProposal(){

        @Override
        public String getLabel() {
            return Texts.get((String)"Loading");
        }

        @Override
        public Image getImage() {
            return ScoutSdkUi.getImage("type_separator.gif");
        }
    }};
    private final Control m_proposalField;
    private final EventListenerList m_selectionListeners;
    private final OptimisticLock m_uiLock = new OptimisticLock();
    private TableViewer m_tableViewer;
    private Label m_itemCountLabel;
    private ScrolledComposite m_proposalDescriptionArea;
    private Object m_selectedProposal;
    private SearchPatternInput m_input;
    private IProposalDescriptionProvider m_proposalDescriptionProvider;
    private IBaseLabelProvider m_labelProvider;
    private IContentProvider m_contentProvider;
    private P_LazyLoader m_lazyLoaderJob;
    private IDialogSettings m_dialogSettings;
    private Point m_shellSizeDif;

    public ProposalPopup(Control proposalField) {
        super(proposalField.getShell());
        this.m_selectionListeners = new EventListenerList();
        this.m_proposalField = proposalField;
        this.setShellStyle(540692);
        this.setBlockOnOpen(false);
        this.getOwnerControl().getShell().addListener(10, new Listener(){

            public void handleEvent(Event event) {
                ProposalPopup.this.close();
            }
        });
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setBackground(shell.getDisplay().getSystemColor(1));
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent e) {
                ProposalPopup.this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ProposalPopup.this.getOwnerControl() != null && !ProposalPopup.this.getOwnerControl().isDisposed()) {
                            if (!ProposalPopup.this.getOwnerControl().isFocusControl()) {
                                ProposalPopup.this.close();
                            }
                        } else {
                            ProposalPopup.this.close();
                        }
                    }
                });
            }
        });
    }

    protected Control createContents(Composite parent) {
        Composite proposalArea = new Composite(parent, 2);
        proposalArea.setBackground(proposalArea.getDisplay().getSystemColor(1));
        Table table = new Table(proposalArea, 66304);
        this.m_tableViewer = new TableViewer(table);
        this.m_tableViewer.setContentProvider(this.m_contentProvider);
        this.m_tableViewer.setLabelProvider(this.m_labelProvider);
        this.m_tableViewer.setInput((Object)this.getInput());
        this.m_tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object newSelection = null;
                if (!event.getSelection().isEmpty() && (newSelection = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof ISeparatorProposal) {
                    return;
                }
                ProposalPopup.this.handleProposalSelection(newSelection);
            }
        });
        this.m_tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    if (selection.size() == 1 && selection.getFirstElement() instanceof ISeparatorProposal) {
                        return;
                    }
                    ProposalPopupEvent delegateEvent = new ProposalPopupEvent(2);
                    delegateEvent.setData("selectedProposal", selection.getFirstElement());
                    ProposalPopup.this.firePopupEvent(delegateEvent);
                }
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                switch (e.keyCode) {
                    case 13: {
                        break;
                    }
                    case 32: {
                        IStructuredSelection selection = (IStructuredSelection)ProposalPopup.this.m_tableViewer.getSelection();
                        if (selection.isEmpty()) break;
                        ProposalPopupEvent delegateEvent = new ProposalPopupEvent(2);
                        delegateEvent.setData("selectedProposal", selection.getFirstElement());
                        ProposalPopup.this.firePopupEvent(delegateEvent);
                        break;
                    }
                }
                super.keyReleased(e);
            }
        });
        table.setHeaderVisible(false);
        this.m_proposalDescriptionArea = new ScrolledComposite(parent, 2816);
        this.m_proposalDescriptionArea.setBackground(this.m_proposalDescriptionArea.getDisplay().getSystemColor(29));
        this.m_proposalDescriptionArea.setExpandHorizontal(true);
        this.m_proposalDescriptionArea.setExpandVertical(true);
        Group group = new Group(proposalArea, 64);
        group.setBackground(group.getDisplay().getSystemColor(1));
        group.setForeground(group.getDisplay().getSystemColor(9));
        this.m_itemCountLabel = new Label((Composite)group, 0);
        this.m_itemCountLabel.setBackground(this.m_itemCountLabel.getDisplay().getSystemColor(1));
        GridLayout parentLayout = new GridLayout(1, true);
        parentLayout.horizontalSpacing = 0;
        parentLayout.marginHeight = 0;
        parentLayout.marginWidth = 0;
        parentLayout.verticalSpacing = 0;
        parent.setLayout((Layout)parentLayout);
        proposalArea.setLayoutData((Object)new GridData(1808));
        GridData proposalDescriptionData = new GridData(1808);
        proposalDescriptionData.exclude = true;
        this.m_proposalDescriptionArea.setLayoutData((Object)proposalDescriptionData);
        proposalArea.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment((Control)group, -2);
        table.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 2);
        data.right = new FormAttachment(100, -2);
        data.bottom = new FormAttachment(100, -2);
        group.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        group.setLayout((Layout)gridLayout);
        GridData gd = new GridData(769);
        this.m_itemCountLabel.setLayoutData((Object)gd);
        return parent;
    }

    private void handleProposalSelection(Object proposal) {
        Object old = this.m_selectedProposal;
        this.m_selectedProposal = null;
        if (old != null) {
            this.m_tableViewer.update(old, new String[]{"label"});
        }
        this.m_selectedProposal = proposal;
        if (this.m_selectedProposal != null) {
            this.m_tableViewer.update(this.m_selectedProposal, new String[]{"label"});
        }
        this.updateDescription(this.m_selectedProposal);
        try {
            if (this.m_uiLock.acquire()) {
                ProposalPopupEvent delegateEvent = new ProposalPopupEvent(4);
                delegateEvent.setData("selectedProposal", this.m_selectedProposal);
                this.firePopupEvent(delegateEvent);
            }
        }
        finally {
            this.m_uiLock.release();
        }
    }

    public void setDialogSettings(IDialogSettings dialogSettings) {
        this.m_dialogSettings = dialogSettings;
    }

    public IDialogSettings getDialogSettings() {
        return this.m_dialogSettings;
    }

    public void updatePattern(String pattern, Object input) {
        this.setInput(new SearchPatternInput(input, pattern));
    }

    public SearchPatternInput getInput() {
        return this.m_input;
    }

    public void setInput(SearchPatternInput input) {
        this.m_input = input;
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            try {
                Object proposal;
                this.m_uiLock.acquire();
                this.m_tableViewer.getTable().setRedraw(false);
                this.m_tableViewer.setInput((Object)this.m_input);
                if (this.m_tableViewer.getSelection().isEmpty() && (proposal = this.m_tableViewer.getElementAt(0)) != null) {
                    this.m_tableViewer.setSelection((ISelection)new StructuredSelection(proposal));
                }
                if (this.m_itemCountLabel != null) {
                    this.m_itemCountLabel.setText(String.valueOf(this.m_tableViewer.getTable().getItemCount()) + " " + Texts.get((String)"ItemsFound"));
                }
                this.updateDescription(this.m_selectedProposal);
            }
            finally {
                this.m_tableViewer.getTable().setRedraw(true);
                this.m_uiLock.release();
            }
            this.constrainShellSize();
        }
    }

    public void setContentProvider(IContentProvider contentProvider) {
        if (contentProvider instanceof ILazyProposalContentProvider) {
            ILazyProposalContentProvider lazyProvider = (ILazyProposalContentProvider)contentProvider;
            this.m_contentProvider = new P_LazyContentProvider(lazyProvider);
        } else {
            this.m_contentProvider = contentProvider;
        }
        if (contentProvider instanceof IDialogSettingsProvider) {
            this.setDialogSettings(((IDialogSettingsProvider)contentProvider).getDialogSettings());
        } else {
            this.setDialogSettings(null);
        }
        if (this.m_tableViewer != null) {
            this.m_tableViewer.setContentProvider(this.m_contentProvider);
        }
    }

    public IContentProvider getContentProvider() {
        if (this.m_contentProvider instanceof P_LazyContentProvider) {
            return ((P_LazyContentProvider)this.m_contentProvider).getWrappedProvider();
        }
        return this.m_contentProvider;
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.m_labelProvider = labelProvider instanceof ITableLabelProvider || labelProvider instanceof ILabelProvider ? new P_StyledLabelProvider(labelProvider) : labelProvider;
        if (this.m_tableViewer != null) {
            this.m_tableViewer.setLabelProvider(this.m_labelProvider);
        }
    }

    public IBaseLabelProvider getLabelProvider() {
        if (this.m_labelProvider instanceof P_StyledLabelProvider) {
            return ((P_StyledLabelProvider)this.m_labelProvider).getWrappedLabelProvider();
        }
        return this.m_labelProvider;
    }

    public String getText(Object element) {
        if (this.m_labelProvider instanceof P_StyledLabelProvider) {
            return ((P_StyledLabelProvider)this.m_labelProvider).getText(element, 0, false);
        }
        return ((ILabelProvider)this.m_labelProvider).getText(element);
    }

    public Object getSelectedProposal() {
        return this.m_selectedProposal;
    }

    public int open() {
        Shell shell = this.getShell();
        if (shell == null || shell.isDisposed()) {
            shell = null;
            this.create();
            shell = this.getShell();
        }
        this.constrainShellSize();
        shell.setVisible(true);
        return 0;
    }

    protected void constrainShellSize() {
        Shell shell = this.getShell();
        try {
            int xDiff;
            shell.setRedraw(false);
            Rectangle ownerBounds = this.getOwnerControl().getDisplay().map((Control)this.getOwnerControl().getParent(), null, this.getOwnerControl().getBounds());
            Rectangle displayBounds = shell.getDisplay().getBounds();
            Rectangle shellBounds = new Rectangle(ownerBounds.x + 2, ownerBounds.y + ownerBounds.height + 2, 400, 300);
            if (this.getDialogSettings() != null) {
                String heightString;
                String widthString = this.getDialogSettings().get(DIALOG_SETTINGS_WIDTH);
                if (!StringUtility.isNullOrEmpty((String)widthString)) {
                    shellBounds.width = Integer.parseInt(widthString);
                }
                if (!StringUtility.isNullOrEmpty((String)(heightString = this.getDialogSettings().get(DIALOG_SETTINGS_HEIGHT)))) {
                    shellBounds.height = Integer.parseInt(heightString);
                }
            }
            if (!((GridData)this.m_proposalDescriptionArea.getLayoutData()).exclude) {
                shellBounds.width *= 2;
            }
            shellBounds.height = Math.min(displayBounds.height / 2, shellBounds.height);
            shellBounds.width = Math.min(displayBounds.width / 2, shellBounds.width);
            int yDiff = displayBounds.y + displayBounds.height - (shellBounds.y + shellBounds.height);
            if (yDiff < 0) {
                if (Math.abs(yDiff) <= 100) {
                    shellBounds.height += yDiff;
                } else {
                    shellBounds.y = shellBounds.y - (ownerBounds.height - 4) - shellBounds.height - 10;
                }
            }
            if ((xDiff = displayBounds.x + displayBounds.width - (shellBounds.x + shellBounds.width)) < 0) {
                shellBounds.x += xDiff;
            }
            if (shellBounds.width < 200) {
                shellBounds.width = 200;
            }
            if (shellBounds.height < 100) {
                shellBounds.height = 100;
            }
            shell.setBounds(shellBounds);
            shell.layout();
            Point sizeAfterSetBounds = shell.getSize();
            int deltaX = shellBounds.width - sizeAfterSetBounds.x;
            int deltaY = shellBounds.height - sizeAfterSetBounds.y;
            if (deltaX != 0 || deltaY != 0) {
                this.m_shellSizeDif = new Point(deltaX / 2, deltaY);
            }
        }
        finally {
            shell.setRedraw(true);
        }
    }

    private void updateDescription(Object proposal) {
        Control[] controlArray = this.m_proposalDescriptionArea.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (!c.isDisposed()) {
                c.dispose();
            }
            ++n2;
        }
        if (this.getProposalDescriptionProvider() != null) {
            Control content = this.getProposalDescriptionProvider().createDescriptionContent((Composite)this.m_proposalDescriptionArea, proposal);
            if (content != null) {
                ((GridLayout)this.m_proposalDescriptionArea.getParent().getLayout()).numColumns = 2;
                this.m_proposalDescriptionArea.setContent(content);
                this.m_proposalDescriptionArea.setMinSize(content.computeSize(-1, -1));
                ((GridData)this.m_proposalDescriptionArea.getLayoutData()).exclude = false;
            } else {
                ((GridLayout)this.m_proposalDescriptionArea.getParent().getLayout()).numColumns = 1;
                ((GridData)this.m_proposalDescriptionArea.getLayoutData()).exclude = true;
            }
            this.constrainShellSize();
        }
    }

    public void setProposalDescriptionProvider(IProposalDescriptionProvider proposalDescriptionProvider) {
        this.m_proposalDescriptionProvider = proposalDescriptionProvider;
    }

    public IProposalDescriptionProvider getProposalDescriptionProvider() {
        return this.m_proposalDescriptionProvider;
    }

    public boolean close() {
        if (this.isVisible()) {
            this.firePopupEvent(new ProposalPopupEvent(8));
            if (this.getDialogSettings() != null) {
                Point size = this.getShell().getSize();
                if (!((GridData)this.m_proposalDescriptionArea.getLayoutData()).exclude) {
                    size.x /= 2;
                }
                if (this.m_shellSizeDif != null) {
                    size.x += this.m_shellSizeDif.x;
                    size.y += this.m_shellSizeDif.y;
                    this.m_shellSizeDif = null;
                }
                this.getDialogSettings().put(DIALOG_SETTINGS_WIDTH, size.x);
                this.getDialogSettings().put(DIALOG_SETTINGS_HEIGHT, size.y);
            }
            this.getShell().setVisible(false);
            return true;
        }
        return false;
    }

    public void dispose() {
        super.close();
    }

    public boolean isFocusOwner() {
        if (this.getShell() == null || this.getShell().isDisposed()) {
            return false;
        }
        Control focusControl = this.getShell().getDisplay().getFocusControl();
        return focusControl != null && focusControl.getShell() == this.getShell();
    }

    public boolean isVisible() {
        return this.getShell() != null && !this.getShell().isDisposed() && this.getShell().isVisible();
    }

    public void addPopupListener(IProposalPopupListener proposalSelectionListener) {
        this.m_selectionListeners.add(IProposalPopupListener.class, (EventListener)proposalSelectionListener);
    }

    public void removePopupListener(IProposalPopupListener proposalSelectionListener) {
        this.m_selectionListeners.remove(IProposalPopupListener.class, (EventListener)proposalSelectionListener);
    }

    private void firePopupEvent(ProposalPopupEvent event) {
        IProposalPopupListener[] iProposalPopupListenerArray = (IProposalPopupListener[])this.m_selectionListeners.getListeners(IProposalPopupListener.class);
        int n = iProposalPopupListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProposalPopupListener listener = iProposalPopupListenerArray[n2];
            try {
                listener.popupChanged(event);
            }
            catch (Exception e) {
                ScoutSdkUi.logError("Error in IProposalPopupListener listener.", e);
            }
            ++n2;
        }
    }

    boolean setFocus() {
        return this.m_tableViewer.getTable().setFocus();
    }

    protected Control getOwnerControl() {
        return this.m_proposalField;
    }

    private synchronized Object[] loadProposals(String pattern, IProgressMonitor monitor) {
        IContentProvider contentProvider = this.m_contentProvider;
        Object[] proposals = ((P_LazyContentProvider)contentProvider).getWrappedProvider().getProposals(pattern, monitor);
        return proposals;
    }

    private void setInputSync(SearchPatternInput input, IProgressMonitor monitor) {
        if (!this.m_tableViewer.getControl().isDisposed()) {
            this.m_tableViewer.getControl().getDisplay().syncExec((Runnable)new P_InputUpdateRunnable(monitor, input, this));
        }
    }

    private static class P_InputUpdateRunnable
    implements Runnable {
        private final IProgressMonitor m_monitor;
        private final SearchPatternInput m_input;
        private final ProposalPopup m_instance;

        private P_InputUpdateRunnable(IProgressMonitor monitor, SearchPatternInput input, ProposalPopup instance) {
            this.m_input = input;
            this.m_monitor = monitor;
            this.m_instance = instance;
        }

        @Override
        public void run() {
            if (this.m_monitor.isCanceled()) {
                return;
            }
            this.m_instance.setInput(this.m_input);
        }
    }

    private class P_LazyContentProvider
    implements IStructuredContentProvider {
        private final ILazyProposalContentProvider m_wrappedProvider;

        public P_LazyContentProvider(ILazyProposalContentProvider wrappedProvider) {
            this.m_wrappedProvider = wrappedProvider;
        }

        public ILazyProposalContentProvider getWrappedProvider() {
            return this.m_wrappedProvider;
        }

        public void dispose() {
            this.m_wrappedProvider.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.m_wrappedProvider.inputChanged(viewer, oldInput, newInput);
        }

        public synchronized Object[] getElements(Object inputElement) {
            SearchPatternInput input = (SearchPatternInput)inputElement;
            if (input.getProposals() == null) {
                if (ProposalPopup.this.m_lazyLoaderJob != null) {
                    ProposalPopup.this.m_lazyLoaderJob.cancel();
                } else {
                    ProposalPopup.this.m_lazyLoaderJob = new P_LazyLoader();
                }
                ProposalPopup.this.m_lazyLoaderJob.schedule(input);
                return new Object[0];
            }
            return input.getProposals();
        }
    }

    private class P_LazyLoader
    extends JobEx {
        private SearchPatternInput m_input;
        private boolean m_loaded;

        public P_LazyLoader() {
            super("proposal loader");
            this.setSystem(true);
            this.m_loaded = false;
        }

        public void schedule(SearchPatternInput input) {
            this.m_input = new SearchPatternInput(input.getInput(), input.getPattern());
            new P_LoadingProposalJob(this, input).schedule();
            this.schedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            this.m_input.setProposals(ProposalPopup.this.loadProposals(this.m_input.getPattern(), monitor));
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            P_LazyLoader p_LazyLoader = this;
            synchronized (p_LazyLoader) {
                ProposalPopup.this.setInputSync(this.m_input, monitor);
                this.m_loaded = true;
            }
            return Status.OK_STATUS;
        }
    }

    private class P_LoadingProposalJob
    extends Job {
        private final P_LazyLoader m_parentJob;
        private final SearchPatternInput m_inputLoading;

        public P_LoadingProposalJob(P_LazyLoader parentJob, SearchPatternInput input) {
            super("loading proposal job");
            this.setSystem(true);
            this.m_parentJob = parentJob;
            this.m_inputLoading = new SearchPatternInput(input.getInput(), input.getPattern());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.m_parentJob.join(250L);
                P_LazyLoader p_LazyLoader = this.m_parentJob;
                synchronized (p_LazyLoader) {
                    if (!this.m_parentJob.m_loaded) {
                        this.m_inputLoading.setProposals(LOADING_PROPOSAL);
                        ProposalPopup.this.setInputSync(this.m_inputLoading, monitor);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return Status.OK_STATUS;
        }
    }

    private class P_StyledLabelProvider
    extends StyledCellLabelProvider {
        private final IBaseLabelProvider m_wrappedLabelProvider;
        private Font m_boldFont;
        private StyledString.Styler m_boldStyler;

        private P_StyledLabelProvider(IBaseLabelProvider labelProvider) {
            this.m_wrappedLabelProvider = labelProvider;
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.m_wrappedLabelProvider.isLabelProperty(element, property);
        }

        public IBaseLabelProvider getWrappedLabelProvider() {
            return this.m_wrappedLabelProvider;
        }

        public void initialize(ColumnViewer viewer, ViewerColumn column) {
            super.initialize(viewer, column);
            Font defaultFont = viewer.getControl().getFont();
            FontData[] defaultFontData = defaultFont.getFontData();
            FontData[] boldFontData = new FontData[defaultFontData.length];
            int i = 0;
            while (i < defaultFontData.length) {
                boldFontData[i] = new FontData(defaultFontData[i].getName(), defaultFontData[i].getHeight(), defaultFontData[i].getStyle() | 1);
                ++i;
            }
            this.m_boldFont = new Font((Device)viewer.getControl().getDisplay(), boldFontData);
            this.m_boldStyler = new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    textStyle.font = P_StyledLabelProvider.this.m_boldFont;
                }
            };
        }

        public void dispose() {
            super.dispose();
            this.m_wrappedLabelProvider.dispose();
            this.m_boldFont.dispose();
            this.m_boldFont = null;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            StyledString text = new StyledString(this.getText(element, cell.getColumnIndex(), CompareUtility.equals((Object)ProposalPopup.this.m_selectedProposal, (Object)element)));
            if (cell.getColumnIndex() == 0 && this.m_wrappedLabelProvider instanceof ISearchRangeConsumer) {
                int index;
                ISearchRangeConsumer labelProvider = (ISearchRangeConsumer)this.m_wrappedLabelProvider;
                int[] matchingRegions = labelProvider.getMatchRanges(element);
                if (matchingRegions != null && matchingRegions.length > 0) {
                    int i = 0;
                    while (i < matchingRegions.length - 1) {
                        text.setStyle(matchingRegions[i], matchingRegions[i + 1], this.m_boldStyler);
                        i += 2;
                    }
                }
                if (labelProvider.isFormatConcatString() && (index = text.getString().indexOf(JavaElementLabels.CONCAT_STRING)) > 0) {
                    text.setStyle(index, text.length() - index, StyledString.QUALIFIER_STYLER);
                }
            }
            cell.setText(text.getString());
            cell.setStyleRanges(text.getStyleRanges());
            cell.setImage(this.getImage(element, cell.getColumnIndex(), ProposalPopup.this.m_selectedProposal == element));
        }

        private String getText(Object element, int columnIndex, boolean selected) {
            if (element instanceof ISeparatorProposal) {
                if (this.m_wrappedLabelProvider instanceof ISeparatorLabelProvider) {
                    return ((ISeparatorLabelProvider)this.m_wrappedLabelProvider).getSeparatorText((ISeparatorProposal)element);
                }
                return ((ISeparatorProposal)element).getLabel();
            }
            if (selected && this.m_wrappedLabelProvider instanceof ISelectionStateLabelProvider) {
                return ((ISelectionStateLabelProvider)this.m_wrappedLabelProvider).getTextSelected(element);
            }
            if (this.m_wrappedLabelProvider instanceof ILabelProvider) {
                return ((ILabelProvider)this.m_wrappedLabelProvider).getText(element);
            }
            return null;
        }

        private Image getImage(Object element, int columnIndex, boolean selected) {
            if (element instanceof ISeparatorProposal) {
                if (this.m_wrappedLabelProvider instanceof ISeparatorLabelProvider) {
                    return ((ISeparatorLabelProvider)this.m_wrappedLabelProvider).getSeparatorImage((ISeparatorProposal)element);
                }
                return ((ISeparatorProposal)element).getImage();
            }
            if (selected && this.m_wrappedLabelProvider instanceof ISelectionStateLabelProvider) {
                return ((ISelectionStateLabelProvider)this.m_wrappedLabelProvider).getImageSelected(element);
            }
            if (this.m_wrappedLabelProvider instanceof ITableLabelProvider) {
                return ((ITableLabelProvider)this.m_wrappedLabelProvider).getColumnImage(element, columnIndex);
            }
            if (this.m_wrappedLabelProvider instanceof ILabelProvider) {
                return ((ILabelProvider)this.m_wrappedLabelProvider).getImage(element);
            }
            return null;
        }
    }

    public static class SearchPatternInput {
        private final String m_pattern;
        private final Object m_input;
        private Object[] m_proposals;

        public SearchPatternInput(Object input, String pattern) {
            this.m_input = input;
            this.m_pattern = pattern;
        }

        public Object getInput() {
            return this.m_input;
        }

        public String getPattern() {
            return this.m_pattern;
        }

        public Object[] getProposals() {
            return this.m_proposals;
        }

        public void setProposals(Object[] proposals) {
            this.m_proposals = proposals;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("input[").append(this.getInput()).append("] ");
            builder.append("pattern[").append(this.getPattern()).append("] ");
            builder.append("proposals[");
            Object[] proposals = this.getProposals();
            int i = 0;
            while (i < proposals.length) {
                if (proposals[i] == null) {
                    builder.append("null");
                } else {
                    builder.append(proposals[i].toString());
                }
                if (i < proposals.length - 1) {
                    builder.append(", ");
                }
                ++i;
            }
            builder.append("] ");
            return builder.toString();
        }

        public int hashCode() {
            int hash = 0;
            if (this.m_input != null) {
                hash ^= this.m_input.hashCode();
            }
            if (this.m_pattern != null) {
                hash ^= this.m_pattern.hashCode();
            }
            if (this.m_proposals != null) {
                Object[] objectArray = this.m_proposals;
                int n = this.m_proposals.length;
                int n2 = 0;
                while (n2 < n) {
                    Object proposal = objectArray[n2];
                    if (proposal != null) {
                        hash ^= proposal.hashCode();
                    }
                    ++n2;
                }
            }
            return hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SearchPatternInput)) {
                return false;
            }
            SearchPatternInput input = (SearchPatternInput)obj;
            return CompareUtility.equals((Object)input.getInput(), (Object)this.getInput()) && CompareUtility.equals((Object)input.getPattern(), (Object)this.getPattern()) && CompareUtility.equals((Object)input.getProposals(), (Object)this.getProposals());
        }
    }
}

