/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal.icon;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.icon.IIconProvider;
import org.eclipse.scout.sdk.icon.ScoutIconDesc;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalProvider;
import org.eclipse.scout.sdk.util.IRegEx;

public class IconContentProvider
extends ContentProposalProvider
implements IStructuredContentProvider {
    private final IIconProvider m_iconProvider;
    private ScoutIconDesc[] m_elements;
    private final ILabelProvider m_labelProvider;

    public IconContentProvider(IIconProvider iconProvider, ILabelProvider labelProvider) {
        this.m_iconProvider = iconProvider;
        this.m_labelProvider = labelProvider;
    }

    @Override
    public Object[] getProposals(String searchPattern, IProgressMonitor monitor) {
        searchPattern = !StringUtility.hasText((String)searchPattern) ? "*" : String.valueOf(IRegEx.STAR_END.matcher(searchPattern).replaceAll("").toLowerCase()) + "*";
        char[] pattern = searchPattern.toCharArray();
        ArrayList<Object> accepted = new ArrayList<Object>();
        Object[] objectArray = this.getElements(this);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            String iconName = this.m_labelProvider.getText(element);
            if (iconName != null && CharOperation.match((char[])pattern, (char[])iconName.toCharArray(), (boolean)false)) {
                accepted.add(element);
            }
            ++n2;
        }
        return accepted.toArray(new Object[accepted.size()]);
    }

    public Object[] getElements(Object inputElement) {
        if (this.m_elements == null) {
            this.m_elements = this.m_iconProvider != null ? this.m_iconProvider.getIcons() : new ScoutIconDesc[0];
        }
        return this.m_elements;
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

