/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions.technology.laf;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.sdk.extensions.runtime.classes.IRuntimeClasses;
import org.eclipse.scout.sdk.ui.extensions.technology.AbstractScoutTechnologyHandler;
import org.eclipse.scout.sdk.ui.extensions.technology.IScoutTechnologyResource;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.technology.IMarketplaceConstants;
import org.eclipse.scout.sdk.util.pde.ProductFileModelHelper;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;

public class RayoUiSwingProdTechnologyHandler
extends AbstractScoutTechnologyHandler
implements IMarketplaceConstants {
    private static final String SCOUT_LAF_KEY = "scout.laf";
    private static final String RAYO_LAF_NAME = "com.bsiag.scout.rt.ui.swing.laf.rayo.Rayo";
    private static final String RAYO_LAF_FRAME_KEY = "scout.laf.useLafFrameAndDialog";
    private static final String RAYO_LAF_FRAME_NAME = "true";

    @Override
    public void selectionChanged(Set<IScoutTechnologyResource> resources, boolean selected, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        this.selectionChangedProductFiles(resources, selected, new String[][]{{"com.bsiag.scout.rt.ui.swing.rayo", "com.bsiag.scout.rt.ui.swing.laf.rayo.fragment"}});
        for (IScoutTechnologyResource res : resources) {
            ProductFileModelHelper pfmh = new ProductFileModelHelper(res.getResource());
            if (selected) {
                pfmh.ConfigurationFile.setEntry(SCOUT_LAF_KEY, RAYO_LAF_NAME);
                pfmh.ConfigurationFile.setEntry(RAYO_LAF_FRAME_KEY, RAYO_LAF_FRAME_NAME);
            } else {
                pfmh.ConfigurationFile.removeEntry(SCOUT_LAF_KEY);
                pfmh.ConfigurationFile.removeEntry(RAYO_LAF_FRAME_KEY);
            }
            pfmh.save();
        }
    }

    @Override
    public TriState getSelection(IScoutBundle project) throws CoreException {
        TriState ret = this.getSelectionProductFiles(new String[]{IRuntimeClasses.ScoutClientBundleId, IRuntimeClasses.ScoutUiSwingBundleId}, new String[][]{{"com.bsiag.scout.rt.ui.swing.rayo", "com.bsiag.scout.rt.ui.swing.laf.rayo.fragment"}});
        List<AbstractScoutTechnologyHandler.P_TechProductFile> productFiles = this.getFilteredProductFiles(IRuntimeClasses.ScoutClientBundleId, IRuntimeClasses.ScoutUiSwingBundleId);
        if (productFiles.size() == 0) {
            return null;
        }
        int i = 0;
        while (i < productFiles.size()) {
            TriState tmp = TriState.parseTriState((Object)this.isRayoLafEnabledInConfigIni(productFiles.get((int)i).productFile));
            if (ret != tmp) {
                return TriState.UNDEFINED;
            }
            ++i;
        }
        return ret;
    }

    @Override
    public boolean isActive(IScoutBundle project) {
        return project.getChildBundle(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"UI_SWING"}), false) != null;
    }

    @Override
    protected void contributeResources(IScoutBundle project, List<IScoutTechnologyResource> list) throws CoreException {
        this.contributeProductFiles(list, IRuntimeClasses.ScoutClientBundleId, IRuntimeClasses.ScoutUiSwingBundleId);
    }

    private boolean isRayoLafEnabledInConfigIni(IFile productFile) {
        try {
            ProductFileModelHelper pfmh = new ProductFileModelHelper(productFile);
            String scoutLaf = pfmh.ConfigurationFile.getEntry(SCOUT_LAF_KEY);
            return RAYO_LAF_NAME.equals(scoutLaf);
        }
        catch (CoreException e) {
            ScoutSdkUi.logError("cannot parse product file: " + productFile, e);
            return false;
        }
    }
}

