/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.job;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.jobs.AbstractWorkspaceBlockingJob;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ProjectsTablePage;
import org.eclipse.scout.sdk.ui.view.outline.DirtyUpdateManager;
import org.eclipse.scout.sdk.ui.view.outline.IDirtyManageable;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.ITypePage;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;

public class RefreshOutlineSubTreeJob
extends AbstractWorkspaceBlockingJob {
    public static final String SELECTION_PREVENTER = "selectionPreventer";
    private final IDirtyManageable m_view;
    private final DirtyUpdateManager m_manager;
    private P_BackupNode[] m_backupTree;
    private ITreeSelection m_backupedSelection;

    public RefreshOutlineSubTreeJob(IDirtyManageable view, DirtyUpdateManager manager, String name) {
        super(name);
        this.m_manager = manager;
        this.m_view = view;
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        Cursor waitCursor;
        Control treeControl;
        TreeViewer treeViewer;
        Display display;
        IPage[] dirtyStructureRoots;
        block19: {
            block20: {
                if (monitor.isCanceled()) {
                    return;
                }
                dirtyStructureRoots = this.m_manager.fetchDirtyStructurePages();
                if (dirtyStructureRoots.length == 0) {
                    return;
                }
                display = ScoutSdkUi.getDisplay();
                treeViewer = this.m_view.getTreeViewer();
                treeControl = treeViewer.getControl();
                waitCursor = new Cursor((Device)display, 1);
                this.m_backupTree = new P_BackupNode[dirtyStructureRoots.length];
                if (dirtyStructureRoots.length <= 0) break block19;
                if (treeControl != null && !treeControl.isDisposed()) break block20;
                try {
                    if (treeControl != null && !treeControl.isDisposed()) {
                        display.syncExec(new Runnable(treeControl, dirtyStructureRoots, treeViewer){
                            private final /* synthetic */ Control val$treeControl;
                            private final /* synthetic */ IPage[] val$dirtyStructureRoots;
                            private final /* synthetic */ TreeViewer val$treeViewer;
                            {
                                this.val$treeControl = control;
                                this.val$dirtyStructureRoots = iPageArray;
                                this.val$treeViewer = treeViewer;
                            }

                            @Override
                            public void run() {
                                try {
                                    if (this.val$treeControl == null || this.val$treeControl.isDisposed()) {
                                        return;
                                    }
                                    if (this.val$dirtyStructureRoots.length > 0) {
                                        try {
                                            this.val$treeViewer.setData(RefreshOutlineSubTreeJob.SELECTION_PREVENTER, (Object)this);
                                            IPage[] iPageArray = this.val$dirtyStructureRoots;
                                            int n = this.val$dirtyStructureRoots.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                IPage p = iPageArray[n2];
                                                this.val$treeViewer.refresh((Object)p, true);
                                                ++n2;
                                            }
                                            int i = 0;
                                            while (i < RefreshOutlineSubTreeJob.this.m_backupTree.length) {
                                                RefreshOutlineSubTreeJob.this.m_backupTree[i].restoreGui(this.val$dirtyStructureRoots[i]);
                                                ++i;
                                            }
                                        }
                                        finally {
                                            this.val$treeViewer.setData(RefreshOutlineSubTreeJob.SELECTION_PREVENTER, null);
                                        }
                                        RefreshOutlineSubTreeJob.this.restoreSelectionInUiThread();
                                    }
                                    RefreshOutlineSubTreeJob.this.m_view.getViewContentProvider().setAutoLoadChildren(true);
                                }
                                finally {
                                    if (this.val$treeControl != null && !this.val$treeControl.isDisposed()) {
                                        this.val$treeControl.setCursor(null);
                                    }
                                }
                            }
                        });
                    }
                }
                finally {
                    waitCursor.dispose();
                }
                return;
            }
            try {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (treeControl == null || treeControl.isDisposed()) {
                            return;
                        }
                        treeControl.setCursor(waitCursor);
                        RefreshOutlineSubTreeJob.this.m_view.getViewContentProvider().setAutoLoadChildren(false);
                        RefreshOutlineSubTreeJob.this.m_backupedSelection = (ITreeSelection)treeViewer.getSelection();
                        int i = 0;
                        while (i < RefreshOutlineSubTreeJob.this.m_backupTree.length) {
                            ((RefreshOutlineSubTreeJob)RefreshOutlineSubTreeJob.this).m_backupTree[i] = new P_BackupNode(null, dirtyStructureRoots[i]);
                            ++i;
                        }
                        try {
                            treeViewer.setData(RefreshOutlineSubTreeJob.SELECTION_PREVENTER, (Object)this);
                            treeViewer.setSelection(null, false);
                        }
                        finally {
                            treeViewer.setData(RefreshOutlineSubTreeJob.SELECTION_PREVENTER, null);
                        }
                    }
                });
                int i = 0;
                while (i < this.m_backupTree.length) {
                    if (this.m_backupTree[i] != null) {
                        this.m_backupTree[i].refreshStructure(dirtyStructureRoots[i]);
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (treeControl != null && !treeControl.isDisposed()) {
                        display.syncExec(new /* invalid duplicate definition of identical inner class */);
                    }
                }
                finally {
                    waitCursor.dispose();
                }
                throw throwable;
            }
        }
        try {
            if (treeControl != null && !treeControl.isDisposed()) {
                display.syncExec(new /* invalid duplicate definition of identical inner class */);
            }
        }
        finally {
            waitCursor.dispose();
        }
    }

    private void restoreSelectionInUiThread() {
        TreePath[] paths = this.m_backupedSelection.getPaths();
        ArrayList<TreePath> newPaths = new ArrayList<TreePath>(paths.length);
        TreePath[] treePathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath p = treePathArray[n2];
            TreePath newPath = this.getNewPath(p);
            if (newPath.getSegmentCount() > 0) {
                newPaths.add(newPath);
            }
            ++n2;
        }
        TreeSelection newTreeSelection = new TreeSelection(newPaths.toArray(new TreePath[newPaths.size()]));
        TreeViewer treeViewer = this.m_view.getTreeViewer();
        if (!treeViewer.getControl().isDisposed() && !treeViewer.getTree().isDisposed()) {
            treeViewer.setSelection((ISelection)newTreeSelection);
        }
    }

    private TreePath getNewPath(TreePath oldPath) {
        TreeItem item = null;
        ArrayList<Object> newSegments = new ArrayList<Object>(oldPath.getSegmentCount());
        int i = 0;
        while (i < oldPath.getSegmentCount()) {
            TreeItem[] curItems = null;
            curItems = item == null ? this.m_view.getTreeViewer().getTree().getItems() : item.getItems();
            if ((item = this.findItemWithData(curItems, oldPath.getSegment(i))) == null) break;
            Object page = item.getData();
            if (page instanceof ITypePage) {
                if (!((ITypePage)page).getType().exists()) break;
                newSegments.add(page);
            } else {
                newSegments.add(page);
            }
            ++i;
        }
        return new TreePath(newSegments.toArray());
    }

    private TreeItem findItemWithData(TreeItem[] candidates, Object data) {
        if (data instanceof IPage) {
            IPage search = (IPage)data;
            TreeItem[] treeItemArray = candidates;
            int n = candidates.length;
            int n2 = 0;
            while (n2 < n) {
                IPage p;
                TreeItem ti = treeItemArray[n2];
                Object data2 = ti.getData();
                if (data2 instanceof IPage && this.isSame(search, p = (IPage)data2)) {
                    return ti;
                }
                ++n2;
            }
        }
        return null;
    }

    private boolean isSame(IPage a, IPage b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getParent() != null && b.getParent() != null) {
            return CompareUtility.equals((Object)a, (Object)b);
        }
        if (!a.getClass().equals(b.getClass())) {
            return false;
        }
        if (!CompareUtility.equals((Object)a.getPageId(), (Object)b.getPageId())) {
            return false;
        }
        if (!CompareUtility.equals((Object)a.getName(), (Object)b.getName())) {
            return false;
        }
        if (a instanceof ITypePage && b instanceof ITypePage) {
            return CompareUtility.equals((Object)((ITypePage)a).getType(), (Object)((ITypePage)b).getType());
        }
        return true;
    }

    private class P_BackupNode {
        private String m_name;
        private boolean m_expanded;
        private HashMap<String, P_BackupNode> m_children = new HashMap();

        public P_BackupNode(P_BackupNode parent, IPage p) {
            this.m_name = p.getName();
            this.m_expanded = RefreshOutlineSubTreeJob.this.m_view.getTreeViewer().getExpandedState((Object)p);
            if (parent != null) {
                parent.m_children.put(this.m_name, this);
            }
            if (this.m_expanded) {
                for (IPage childPage : p.getChildren()) {
                    new P_BackupNode(this, childPage);
                }
            }
        }

        public void refreshStructure(IPage p) {
            if (p.getParent() != null || p instanceof ProjectsTablePage) {
                p.unloadChildren();
                if (this.m_expanded) {
                    p.loadChildren();
                    for (IPage childPage : p.getChildren()) {
                        P_BackupNode node = this.m_children.get(childPage.getName());
                        if (node == null) continue;
                        node.refreshStructure(childPage);
                    }
                }
            }
        }

        public void restoreGui(IPage p) {
            if (this.m_expanded) {
                RefreshOutlineSubTreeJob.this.m_view.getTreeViewer().setExpandedState((Object)p, true);
                for (IPage childPage : p.getChildren()) {
                    P_BackupNode node = this.m_children.get(childPage.getName());
                    if (node == null) continue;
                    node.restoreGui(childPage);
                }
            }
        }
    }
}

