/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutBundleNode;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class ScoutBundleNodeGroup
implements Comparable<ScoutBundleNodeGroup> {
    private final ScoutBundleNode m_definingBundle;
    private final Set<ScoutBundleNode> m_childBundles;
    private final Set<ScoutBundleNodeGroup> m_parentGroups;
    private final Set<ScoutBundleNodeGroup> m_childGroups;
    private final String m_groupName;

    public ScoutBundleNodeGroup(ScoutBundleNode definingBundle) {
        this.m_definingBundle = definingBundle;
        this.m_parentGroups = new HashSet<ScoutBundleNodeGroup>();
        this.m_childGroups = new HashSet<ScoutBundleNodeGroup>();
        this.m_childBundles = new HashSet<ScoutBundleNode>();
        this.m_groupName = this.getGroupName(definingBundle.getScoutBundle());
        this.m_childBundles.add(definingBundle);
    }

    public static String[] getBundleBaseNameAndPostfix(IScoutBundle b) {
        String type = b.getType().toLowerCase();
        String symbolicName = b.getSymbolicName().toLowerCase();
        Matcher m = Pattern.compile("^(.*)\\.(" + type.toLowerCase() + ")(\\.(.*))?$").matcher(symbolicName);
        if (m.find()) {
            String baseName = StringUtility.trim((String)m.group(1));
            String postfix = StringUtility.trim((String)m.group(4));
            return new String[]{baseName, postfix};
        }
        return new String[]{symbolicName, ""};
    }

    private String getGroupName(IScoutBundle b) {
        String[] baseNameAndPostfix = ScoutBundleNodeGroup.getBundleBaseNameAndPostfix(b);
        StringBuilder builder = new StringBuilder();
        builder.append(baseNameAndPostfix[0]);
        if (!StringUtility.isNullOrEmpty((String)baseNameAndPostfix[1])) {
            builder.append(" (").append(baseNameAndPostfix[1]).append(")");
        }
        return builder.toString();
    }

    public void addChildBundle(ScoutBundleNode child) {
        this.m_childBundles.add(child);
    }

    public ScoutBundleNode getDefiningBundle() {
        return this.m_definingBundle;
    }

    public Set<ScoutBundleNodeGroup> getChildGroups() {
        return this.m_childGroups;
    }

    public void addChildGroup(ScoutBundleNodeGroup child) {
        this.m_childGroups.add(child);
        child.m_parentGroups.add(this);
    }

    public Set<ScoutBundleNode> getChildBundles() {
        return this.m_childBundles;
    }

    public Set<ScoutBundleNodeGroup> getParentGroups() {
        return this.m_parentGroups;
    }

    public boolean containsBundle(ScoutBundleNode node) {
        for (ScoutBundleNode n : this.getChildBundles()) {
            if (!node.equals(n)) continue;
            return true;
        }
        for (ScoutBundleNodeGroup grp : this.getChildGroups()) {
            if (!grp.containsBundle(node)) continue;
            return true;
        }
        return false;
    }

    public boolean isBinary() {
        for (ScoutBundleNode b : this.m_childBundles) {
            if (b.getScoutBundle().isBinary()) continue;
            return false;
        }
        return this.m_childBundles.size() > 0;
    }

    public int hashCode() {
        return this.m_definingBundle.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ScoutBundleNodeGroup)) {
            return false;
        }
        return this.m_definingBundle.equals(((ScoutBundleNodeGroup)obj).getDefiningBundle());
    }

    public String toString() {
        return this.m_definingBundle.toString();
    }

    public String getGroupName() {
        return this.m_groupName;
    }

    @Override
    public int compareTo(ScoutBundleNodeGroup o) {
        return this.getGroupName().compareTo(o.getGroupName());
    }
}

