/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.field;

import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.ITypeResolver;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.dto.TypeResolverFormDataAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.FormFieldExtensionPoint;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.ITypePage;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;

public class FormFieldTemplateTablePage
extends AbstractPage {
    private ICachedTypeHierarchy m_formFieldHierarchy;

    public FormFieldTemplateTablePage(IPage parent) {
        this.setParent(parent);
        this.setName(Texts.get((String)"FormFields"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("default.gif"));
    }

    @Override
    public void refresh(boolean clearCache) {
        if (clearCache && this.m_formFieldHierarchy != null) {
            this.m_formFieldHierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    @Override
    public void unloadPage() {
        if (this.m_formFieldHierarchy != null) {
            this.m_formFieldHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            this.m_formFieldHierarchy = null;
        }
        super.unloadPage();
    }

    @Override
    protected void loadChildrenImpl() {
        IType[] iTypeArray = this.resolveFormFieldTemplates();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType fieldTemplate = iTypeArray[n2];
            ITypePage nodePage = (ITypePage)FormFieldExtensionPoint.createNodePage(fieldTemplate, (ITypeHierarchy)this.m_formFieldHierarchy);
            if (nodePage != null) {
                nodePage.setParent(this);
                nodePage.setType(fieldTemplate);
            }
            ++n2;
        }
    }

    protected IType[] resolveFormFieldTemplates() {
        IType iFormField = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.IFormField");
        if (this.m_formFieldHierarchy == null) {
            this.m_formFieldHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iFormField);
            this.m_formFieldHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        ITypeFilter filter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{ScoutTypeFilters.getInScoutBundles((IScoutBundle[])new IScoutBundle[]{this.getScoutBundle()}), TypeFilters.getFlagsFilter((int)1025)});
        IType[] allSubtypes = this.m_formFieldHierarchy.getAllSubtypes(iFormField, filter, TypeComparators.getTypeNameComparator());
        return allSubtypes;
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof TypeResolverFormDataAction) {
            ((TypeResolverFormDataAction)menu).init(new ITypeResolver(){

                public IType[] getTypes() {
                    return FormFieldTemplateTablePage.this.resolveFormFieldTemplates();
                }
            }, this.getScoutBundle());
        }
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{TypeResolverFormDataAction.class};
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.FormFieldTemplateTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }
}

