/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.common.accesscontrol;

import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.common.accesscontrol.AccessControlServiceNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;

public class AccessControlServiceTablePage
extends AbstractPage {
    private ICachedTypeHierarchy m_serviceHierarchy;

    public AccessControlServiceTablePage(AbstractPage parent) {
        this.setParent(parent);
        this.setName(Texts.get((String)"AccessControlServices"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("services.png"));
    }

    @Override
    public void unloadPage() {
        if (this.m_serviceHierarchy != null) {
            this.m_serviceHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            this.m_serviceHierarchy = null;
        }
        super.unloadPage();
    }

    @Override
    public void refresh(boolean clearCache) {
        if (clearCache && this.m_serviceHierarchy != null) {
            this.m_serviceHierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.AccessControlServiceTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public void loadChildrenImpl() {
        IType[] iTypeArray = this.resolveServices();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType service = iTypeArray[n2];
            IType serviceInterface = null;
            IType[] interfaces = this.m_serviceHierarchy.getSuperInterfaces(service, TypeFilters.getElementNameFilter((String)("I" + service.getElementName())));
            if (interfaces.length > 0) {
                serviceInterface = interfaces[0];
            }
            new AccessControlServiceNodePage(this, service, serviceInterface);
            ++n2;
        }
    }

    protected IType[] resolveServices() {
        IType iAccessControlService = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.common.security.IAccessControlService");
        if (this.m_serviceHierarchy == null) {
            this.m_serviceHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iAccessControlService);
            this.m_serviceHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        IType[] services = this.m_serviceHierarchy.getAllSubtypes(iAccessControlService, ScoutTypeFilters.getTypesInScoutBundles((IScoutBundle[])new IScoutBundle[]{this.getScoutBundle()}), TypeComparators.getTypeNameComparator());
        return services;
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[0];
    }
}

