/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalProvider;
import org.eclipse.scout.sdk.util.IRegEx;
import org.eclipse.scout.sdk.util.jdt.AbstractElementChangedListener;
import org.eclipse.scout.sdk.util.type.TypeUtility;

public abstract class AbstractCachedTypeContentProposalProvider
extends ContentProposalProvider {
    private final ILabelProvider m_labelProvider;
    private IType m_type;
    private Object[] m_proposals;
    private AbstractElementChangedListener m_listener;

    protected AbstractCachedTypeContentProposalProvider(ILabelProvider labelProvider) {
        this.m_labelProvider = labelProvider;
    }

    public synchronized IType getType() {
        return this.m_type;
    }

    public synchronized void setType(IType t) {
        this.m_type = t;
        this.reset();
    }

    protected void reset() {
        if (this.m_listener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.m_listener);
            this.m_listener = null;
        }
        this.m_proposals = null;
    }

    @Override
    public Object[] getProposals(String searchPattern, IProgressMonitor monitor) {
        searchPattern = !StringUtility.hasText((String)searchPattern) ? "*" : String.valueOf(IRegEx.STAR_END.matcher(searchPattern).replaceAll("")) + "*";
        char[] pattern = CharOperation.toLowerCase((char[])searchPattern.toCharArray());
        ArrayList<Object> collector = new ArrayList<Object>();
        Object[] objectArray = this.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object proposal = objectArray[n2];
            if (CharOperation.match((char[])pattern, (char[])this.m_labelProvider.getText(proposal).toCharArray(), (boolean)false)) {
                collector.add(proposal);
            }
            ++n2;
        }
        return collector.toArray(new Object[collector.size()]);
    }

    @Override
    public synchronized void dispose() {
        this.reset();
        super.dispose();
    }

    private synchronized Object[] getElements() {
        if (this.m_proposals == null) {
            boolean typeExists = TypeUtility.exists((IJavaElement)this.m_type);
            if (this.m_listener == null && typeExists && !this.m_type.isBinary()) {
                this.m_listener = new P_ElementListener(this.m_type, this);
                JavaCore.addElementChangedListener((IElementChangedListener)this.m_listener);
            }
            if (typeExists) {
                this.m_proposals = this.computeProposals();
            }
        }
        return this.m_proposals;
    }

    protected abstract Object[] computeProposals();

    private static final class P_ElementListener
    extends AbstractElementChangedListener {
        private final IType m_type;
        private final AbstractCachedTypeContentProposalProvider m_provider;

        private P_ElementListener(IType type, AbstractCachedTypeContentProposalProvider provider) {
            this.m_type = type;
            this.m_provider = provider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean visitModify(int flags, IJavaElement e, CompilationUnit ast) {
            IType eventType;
            if (e != null && e.getElementType() == 7 && TypeUtility.exists((IJavaElement)(eventType = (IType)e)) && this.m_type.equals(eventType)) {
                AbstractCachedTypeContentProposalProvider abstractCachedTypeContentProposalProvider = this.m_provider;
                synchronized (abstractCachedTypeContentProposalProvider) {
                    this.m_provider.m_proposals = null;
                }
                return false;
            }
            return super.visitModify(flags, e, ast);
        }
    }
}

