/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.nls.sdk.ui.action.NlsEntryModifyAction;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.ILazyProposalContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalSelectionHandler;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.nls.NlsProposalDescriptionProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.nls.NlsTextContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.nls.NlsTextLabelProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.nls.NlsTextSelectionHandler;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractMethodPresenter;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.scout.sdk.workspace.type.config.ConfigPropertyUpdateOperation;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtility;
import org.eclipse.scout.sdk.workspace.type.config.parser.IPropertySourceParser;
import org.eclipse.scout.sdk.workspace.type.config.parser.NlsPropertySourceParser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class NlsTextPresenter
extends AbstractMethodPresenter {
    private ProposalTextField m_proposalField;
    private INlsEntry m_currentSourceTuple;
    private INlsProject m_nlsProject;
    private final OptimisticLock m_storeValueLock = new OptimisticLock();
    private NlsPropertySourceParser m_parser;

    public NlsTextPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    protected ProposalTextField createContent(Composite container) {
        this.m_proposalField = new ProposalTextField(container, 1024);
        this.toolkitAdapt((Control)this.m_proposalField);
        this.m_proposalField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                NlsTextPresenter.this.handleProposalAccepted(event);
            }
        });
        this.m_proposalField.setEnabled(false);
        this.m_proposalField.setProposalDescriptionProvider(new NlsProposalDescriptionProvider());
        MenuManager contextMenuManager = new MenuManager();
        contextMenuManager.setRemoveAllWhenShown(true);
        contextMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NlsTextPresenter.this.fillContextMenu(manager);
            }
        });
        Menu menu = contextMenuManager.createContextMenu((Control)this.m_proposalField);
        this.m_proposalField.setMenu(menu);
        this.m_proposalField.setMenu(menu);
        return this.m_proposalField;
    }

    protected void fillContextMenu(IMenuManager manager) {
        if (this.m_currentSourceTuple != null) {
            manager.add((IAction)new NlsEntryModifyAction(this.getContainer().getShell(), this.m_currentSourceTuple, this.getNlsProject()){

                protected void execute(IProgressMonitor monitor) {
                    super.execute(monitor);
                    NlsTextPresenter.this.m_proposalField.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            NlsTextPresenter.this.m_proposalField.acceptProposal(this.getEntry());
                        }
                    });
                }
            });
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!this.isDisposed()) {
            this.m_proposalField.setEnabled(enabled && this.getNlsProject() != null);
        }
        super.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        if (!this.isDisposed()) {
            return this.m_proposalField.getEnabled() && super.isEnabled();
        }
        return false;
    }

    @Override
    protected void init(ConfigurationMethod method) throws CoreException {
        if (method == null) {
            return;
        }
        super.init(method);
        INlsProject newNlsProject = this.resolveNlsProject(method);
        if (!CompareUtility.equals((Object)newNlsProject, (Object)this.m_nlsProject)) {
            this.m_nlsProject = newNlsProject;
            this.m_parser = new NlsPropertySourceParser(this.m_nlsProject);
            this.m_proposalField.setLabelProvider((IBaseLabelProvider)this.createLabelProvider(this.getNlsProject()));
            this.m_proposalField.setContentProvider(this.createContentProvider(this.getNlsProject()));
            this.m_proposalField.setSelectionHandler(this.createSelectionHandler(this.getNlsProject()));
        }
        if (this.getNlsProject() != null) {
            try {
                String simpleText;
                this.m_storeValueLock.acquire();
                this.m_currentSourceTuple = this.getParser().parseSourceValue(this.getMethod().computeValue(), this.getMethod().peekMethod(), this.getMethod().getSuperTypeHierarchy());
                if (this.m_currentSourceTuple == null && (simpleText = PropertyMethodSourceUtility.parseReturnParameterString((String)this.getMethod().computeValue(), (IMethod)this.getMethod().peekMethod(), (ITypeHierarchy)this.getMethod().getSuperTypeHierarchy())) != null) {
                    throw new CoreException((IStatus)new ScoutStatus(1, "Text '" + simpleText + "'.", null));
                }
                this.m_proposalField.acceptProposal(this.m_currentSourceTuple);
            }
            finally {
                this.m_storeValueLock.release();
            }
        }
        this.m_proposalField.setEnabled(this.getNlsProject() != null);
    }

    protected INlsProject resolveNlsProject(ConfigurationMethod method) {
        return ScoutTypeUtility.findNlsProject((IJavaElement)method.getType());
    }

    public NlsPropertySourceParser getParser() {
        return this.m_parser;
    }

    protected ILazyProposalContentProvider createContentProvider(INlsProject nlsProject) {
        if (nlsProject != null) {
            return new NlsTextContentProvider((NlsTextLabelProvider)this.getProposalField().getLabelProvider());
        }
        return null;
    }

    protected ILabelProvider createLabelProvider(INlsProject project) {
        if (project != null) {
            return new NlsTextLabelProvider(project);
        }
        return null;
    }

    protected IProposalSelectionHandler createSelectionHandler(INlsProject project) {
        if (project != null) {
            return new NlsTextSelectionHandler(project);
        }
        return null;
    }

    protected ProposalTextField getProposalField() {
        return this.m_proposalField;
    }

    protected void handleProposalAccepted(ContentProposalEvent event) {
        try {
            Object proposal = event.proposal;
            if (proposal == null) {
                this.m_proposalField.setText("");
                this.storeNlsText(null);
            } else {
                this.storeNlsText((INlsEntry)proposal);
            }
        }
        catch (CoreException e) {
            ScoutSdkUi.logError(e);
        }
    }

    protected synchronized void storeNlsText(INlsEntry proposal) throws CoreException {
        try {
            try {
                if (this.m_storeValueLock.acquire()) {
                    ConfigPropertyUpdateOperation updateOp = new ConfigPropertyUpdateOperation(this.getMethod(), (IPropertySourceParser)this.getParser());
                    updateOp.setValue((Object)proposal);
                    OperationJob job = new OperationJob(new IOperation[]{updateOp});
                    job.setDebug(true);
                    job.schedule();
                }
            }
            catch (Exception e) {
                ScoutSdkUi.logError("could not parse default value of method '" + this.getMethod().getMethodName() + "' in type '" + this.getMethod().getType().getFullyQualifiedName() + "'.", e);
                this.m_storeValueLock.release();
            }
        }
        finally {
            this.m_storeValueLock.release();
        }
    }

    public INlsProject getNlsProject() {
        return this.m_nlsProject;
    }
}

